/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannel;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannel
 * DistributionChannel}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.field.DistributionChannelField
 * DistributionChannelField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.link.DistributionChannelLink
 * DistributionChannelLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannel#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannel#TO_TEXT
 * TO_TEXT}</li>
 * </ul>
 *
 */
public interface DistributionChannelSelectable extends EntitySelectable<DistributionChannel>
{

}
