/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelText
 * DistributionChannelText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.field.DistributionChannelTextField
 * DistributionChannelTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.link.DistributionChannelTextLink
 * DistributionChannelTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelText#DISTRIBUTION_CHANNEL
 * DISTRIBUTION_CHANNEL}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelText#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelText#DISTRIBUTION_CHANNEL_NAME
 * DISTRIBUTION_CHANNEL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.distributionchannel.DistributionChannelText#TO_DISTRIBUTION_CHANNEL
 * TO_DISTRIBUTION_CHANNEL}</li>
 * </ul>
 *
 */
public interface DistributionChannelTextSelectable extends EntitySelectable<DistributionChannelText>
{

}
