/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.field.DivisionTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.link.DivisionTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.selectable.DivisionTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Division Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DivisionTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DivisionText extends VdmEntity<DivisionText>
{

    /**
     * Selector for all available fields of DivisionText.
     *
     */
    public final static DivisionTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @return Division
     */
    @Key
    @SerializedName( "Division" )
    @JsonProperty( "Division" )
    @Nullable
    @ODataField( odataName = "Division" )
    private String division;
    /**
     * Use with available fluent helpers to apply the <b>Division</b> field to query operations.
     *
     */
    public final static DivisionTextField<String> DIVISION = new DivisionTextField<String>("Division");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DivisionTextField<String> LANGUAGE = new DivisionTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DivisionName</b>
     * </p>
     *
     * @return Division Description
     */
    @SerializedName( "DivisionName" )
    @JsonProperty( "DivisionName" )
    @Nullable
    @ODataField( odataName = "DivisionName" )
    private String divisionName;
    /**
     * Use with available fluent helpers to apply the <b>DivisionName</b> field to query operations.
     *
     */
    public final static DivisionTextField<String> DIVISION_NAME = new DivisionTextField<String>("DivisionName");
    /**
     * Navigation property <b>to_Division</b> for <b>DivisionText</b> to single <b>Division</b>.
     *
     */
    @SerializedName( "to_Division" )
    @JsonProperty( "to_Division" )
    @ODataField( odataName = "to_Division" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Division toDivision;
    /**
     * Use with available fluent helpers to apply the <b>to_Division</b> navigation property to query operations.
     *
     */
    public final static DivisionTextOneToOneLink<Division> TO_DIVISION =
        new DivisionTextOneToOneLink<Division>("to_Division");

    @Nonnull
    @Override
    public Class<DivisionText> getType()
    {
        return DivisionText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Division</b>
     * </p>
     *
     * @param division
     *            Division
     */
    public void setDivision( @Nullable final String division )
    {
        rememberChangedField("Division", this.division);
        this.division = division;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>DivisionName</b>
     * </p>
     *
     * @param divisionName
     *            Division Description
     */
    public void setDivisionName( @Nullable final String divisionName )
    {
        rememberChangedField("DivisionName", this.divisionName);
        this.divisionName = divisionName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DivisionText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Division", getDivision());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Division", getDivision());
        values.put("Language", getLanguage());
        values.put("DivisionName", getDivisionName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Division") ) {
                final Object value = values.remove("Division");
                if( (value == null) || (!value.equals(getDivision())) ) {
                    setDivision(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DivisionName") ) {
                final Object value = values.remove("DivisionName");
                if( (value == null) || (!value.equals(getDivisionName())) ) {
                    setDivisionName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Division") ) {
                final Object value = (values).remove("to_Division");
                if( value instanceof Map ) {
                    if( toDivision == null ) {
                        toDivision = new Division();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDivision.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DivisionTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DivisionTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DivisionTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DivisionTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDivision != null ) {
            (values).put("to_Division", toDivision);
        }
        return values;
    }

    /**
     * Fetches the <b>Division</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Division</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Division</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Division fetchDivision()
    {
        return fetchFieldAsSingle("to_Division", Division.class);
    }

    /**
     * Retrieval of associated <b>Division</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Division</b>.
     * <p>
     * If the navigation property <b>to_Division</b> of a queried <b>DivisionText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Division</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Division getDivisionOrFetch()
    {
        if( toDivision == null ) {
            toDivision = fetchDivision();
        }
        return toDivision;
    }

    /**
     * Retrieval of associated <b>Division</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Division</b>.
     * <p>
     * If the navigation property for an entity <b>DivisionText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Division</b> is already loaded, the result will contain
     *         the <b>Division</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Division> getDivisionIfPresent()
    {
        return Option.of(toDivision);
    }

    /**
     * Overwrites the associated <b>Division</b> entity for the loaded navigation property <b>to_Division</b>.
     *
     * @param value
     *            New <b>Division</b> entity.
     */
    public void setDivision( final Division value )
    {
        toDivision = value;
    }

    /**
     * Helper class to allow for fluent creation of DivisionText instances.
     *
     */
    public final static class DivisionTextBuilder
    {

        private Division toDivision;
        private String division = null;

        private DivisionText.DivisionTextBuilder toDivision( final Division value )
        {
            toDivision = value;
            return this;
        }

        /**
         * Navigation property <b>to_Division</b> for <b>DivisionText</b> to single <b>Division</b>.
         *
         * @param value
         *            The Division to build this DivisionText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DivisionText.DivisionTextBuilder division( final Division value )
        {
            return toDivision(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 2
         * <p>
         * Original property name from the Odata EDM: <b>Division</b>
         * </p>
         *
         * @param value
         *            The division to build this DivisionText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DivisionText.DivisionTextBuilder division( final String value )
        {
            division = value;
            return this;
        }

    }

}
