/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DivisionServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService DivisionService}, allowing you to create
 * multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDivisionServiceBatch
    extends
    BatchFluentHelperBasic<DivisionServiceBatch, DivisionServiceBatchChangeSet>
    implements
    DivisionServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDivisionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDivisionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDivisionServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDivisionServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDivisionServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DivisionServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDivisionServiceBatchChangeSet(this, service);
    }

}
