/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;

/**
 * Implementation of the {@link DivisionServiceBatchChangeSet} interface, enabling you to combine multiple operations
 * into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService DivisionService}.
 *
 */
public class DefaultDivisionServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DivisionServiceBatch, DivisionServiceBatchChangeSet>
    implements
    DivisionServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService service;

    @SuppressWarnings( "deprecation" )
    DefaultDivisionServiceBatchChangeSet(
        @Nonnull final DefaultDivisionServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DivisionService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDivisionServiceBatchChangeSet getThis()
    {
        return this;
    }

}
