/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.Division;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.Division Division}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.field.DivisionField DivisionField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.link.DivisionLink DivisionLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.Division#DIVISION DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.Division#TO_TEXT TO_TEXT}</li>
 * </ul>
 *
 */
public interface DivisionSelectable extends EntitySelectable<Division>
{

}
