/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.DivisionText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.DivisionText DivisionText}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.field.DivisionTextField
 * DivisionTextField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.link.DivisionTextLink
 * DivisionTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.DivisionText#DIVISION DIVISION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.DivisionText#LANGUAGE LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.DivisionText#DIVISION_NAME
 * DIVISION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.division.DivisionText#TO_DIVISION TO_DIVISION}</li>
 * </ul>
 *
 */
public interface DivisionTextSelectable extends EntitySelectable<DivisionText>
{

}
