/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocInfoRecdObjLinkProductField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.link.DocInfoRecdObjLinkProductOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable.DocInfoRecdObjLinkProductSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Product Object Links
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DocInfoRecdObjLinkProductType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocInfoRecdObjLinkProduct extends VdmEntity<DocInfoRecdObjLinkProduct>
{

    /**
     * Selector for all available fields of DocInfoRecdObjLinkProduct.
     *
     */
    public final static DocInfoRecdObjLinkProductSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<Boolean> DELETE_MC =
        new DocInfoRecdObjLinkProductField<Boolean>("Delete_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new DocInfoRecdObjLinkProductField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new DocInfoRecdObjLinkProductField<String>("DocumentInfoRecordDocNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new DocInfoRecdObjLinkProductField<String>("DocumentInfoRecordDocVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return Document Part
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new DocInfoRecdObjLinkProductField<String>("DocumentInfoRecordDocPart");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObject</b>
     * </p>
     *
     * @return Linked SAP Object
     */
    @Key
    @SerializedName( "LinkedSAPObject" )
    @JsonProperty( "LinkedSAPObject" )
    @Nullable
    @ODataField( odataName = "LinkedSAPObject" )
    private String linkedSAPObject;
    /**
     * Use with available fluent helpers to apply the <b>LinkedSAPObject</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<String> LINKED_SAP_OBJECT =
        new DocInfoRecdObjLinkProductField<String>("LinkedSAPObject");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @return Document Management Object Key
     */
    @Key
    @SerializedName( "LinkedSAPObjectKey" )
    @JsonProperty( "LinkedSAPObjectKey" )
    @Nullable
    @ODataField( odataName = "LinkedSAPObjectKey" )
    private String linkedSAPObjectKey;
    /**
     * Use with available fluent helpers to apply the <b>LinkedSAPObjectKey</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<String> LINKED_SAP_OBJECT_KEY =
        new DocInfoRecdObjLinkProductField<String>("LinkedSAPObjectKey");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DocObjectLinkCounter</b>
     * </p>
     *
     * @return Counter key
     */
    @Key
    @SerializedName( "DocObjectLinkCounter" )
    @JsonProperty( "DocObjectLinkCounter" )
    @Nullable
    @ODataField( odataName = "DocObjectLinkCounter" )
    private String docObjectLinkCounter;
    /**
     * Use with available fluent helpers to apply the <b>DocObjectLinkCounter</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<String> DOC_OBJECT_LINK_COUNTER =
        new DocInfoRecdObjLinkProductField<String>("DocObjectLinkCounter");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return Time last change was made
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductField<ZonedDateTime> CHANGED_DATE_TIME =
        new DocInfoRecdObjLinkProductField<ZonedDateTime>("ChangedDateTime");
    /**
     * Navigation property <b>to_DocInfoRecord</b> for <b>DocInfoRecdObjLinkProduct</b> to single
     * <b>DocumentInfoRecord</b>.
     *
     */
    @SerializedName( "to_DocInfoRecord" )
    @JsonProperty( "to_DocInfoRecord" )
    @ODataField( odataName = "to_DocInfoRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentInfoRecord toDocInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>to_DocInfoRecord</b> navigation property to query operations.
     *
     */
    public final static DocInfoRecdObjLinkProductOneToOneLink<DocumentInfoRecord> TO_DOC_INFO_RECORD =
        new DocInfoRecdObjLinkProductOneToOneLink<DocumentInfoRecord>("to_DocInfoRecord");

    @Nonnull
    @Override
    public Class<DocInfoRecdObjLinkProduct> getType()
    {
        return DocInfoRecdObjLinkProduct.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            Document Type
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            Document number
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            Document Version
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            Document Part
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObject</b>
     * </p>
     *
     * @param linkedSAPObject
     *            Linked SAP Object
     */
    public void setLinkedSAPObject( @Nullable final String linkedSAPObject )
    {
        rememberChangedField("LinkedSAPObject", this.linkedSAPObject);
        this.linkedSAPObject = linkedSAPObject;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 90
     * <p>
     * Original property name from the Odata EDM: <b>LinkedSAPObjectKey</b>
     * </p>
     *
     * @param linkedSAPObjectKey
     *            Document Management Object Key
     */
    public void setLinkedSAPObjectKey( @Nullable final String linkedSAPObjectKey )
    {
        rememberChangedField("LinkedSAPObjectKey", this.linkedSAPObjectKey);
        this.linkedSAPObjectKey = linkedSAPObjectKey;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>DocObjectLinkCounter</b>
     * </p>
     *
     * @param docObjectLinkCounter
     *            Counter key
     */
    public void setDocObjectLinkCounter( @Nullable final String docObjectLinkCounter )
    {
        rememberChangedField("DocObjectLinkCounter", this.docObjectLinkCounter);
        this.docObjectLinkCounter = docObjectLinkCounter;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            Time last change was made
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DocInfoRecdObjLinkProduct";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        result.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        result.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        result.put("LinkedSAPObject", getLinkedSAPObject());
        result.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        result.put("DocObjectLinkCounter", getDocObjectLinkCounter());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("LinkedSAPObject", getLinkedSAPObject());
        values.put("LinkedSAPObjectKey", getLinkedSAPObjectKey());
        values.put("DocObjectLinkCounter", getDocObjectLinkCounter());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("LinkedSAPObject") ) {
                final Object value = values.remove("LinkedSAPObject");
                if( (value == null) || (!value.equals(getLinkedSAPObject())) ) {
                    setLinkedSAPObject(((String) value));
                }
            }
            if( values.containsKey("LinkedSAPObjectKey") ) {
                final Object value = values.remove("LinkedSAPObjectKey");
                if( (value == null) || (!value.equals(getLinkedSAPObjectKey())) ) {
                    setLinkedSAPObjectKey(((String) value));
                }
            }
            if( values.containsKey("DocObjectLinkCounter") ) {
                final Object value = values.remove("DocObjectLinkCounter");
                if( (value == null) || (!value.equals(getDocObjectLinkCounter())) ) {
                    setDocObjectLinkCounter(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_DocInfoRecord") ) {
                final Object value = (values).remove("to_DocInfoRecord");
                if( value instanceof Map ) {
                    if( toDocInfoRecord == null ) {
                        toDocInfoRecord = new DocumentInfoRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDocInfoRecord.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DocInfoRecdObjLinkProductField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DocInfoRecdObjLinkProductField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocInfoRecdObjLinkProductField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocInfoRecdObjLinkProductField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDocInfoRecord != null ) {
            (values).put("to_DocInfoRecord", toDocInfoRecord);
        }
        return values;
    }

    /**
     * Fetches the <b>DocumentInfoRecord</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DocInfoRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DocumentInfoRecord</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DocumentInfoRecord fetchDocInfoRecord()
    {
        return fetchFieldAsSingle("to_DocInfoRecord", DocumentInfoRecord.class);
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DocInfoRecord</b>.
     * <p>
     * If the navigation property <b>to_DocInfoRecord</b> of a queried <b>DocInfoRecdObjLinkProduct</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentInfoRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DocumentInfoRecord getDocInfoRecordOrFetch()
    {
        if( toDocInfoRecord == null ) {
            toDocInfoRecord = fetchDocInfoRecord();
        }
        return toDocInfoRecord;
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DocInfoRecord</b>.
     * <p>
     * If the navigation property for an entity <b>DocInfoRecdObjLinkProduct</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DocInfoRecord</b> is already loaded, the result will
     *         contain the <b>DocumentInfoRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DocumentInfoRecord> getDocInfoRecordIfPresent()
    {
        return Option.of(toDocInfoRecord);
    }

    /**
     * Overwrites the associated <b>DocumentInfoRecord</b> entity for the loaded navigation property
     * <b>to_DocInfoRecord</b>.
     *
     * @param value
     *            New <b>DocumentInfoRecord</b> entity.
     */
    public void setDocInfoRecord( final DocumentInfoRecord value )
    {
        toDocInfoRecord = value;
    }

    /**
     * Helper class to allow for fluent creation of DocInfoRecdObjLinkProduct instances.
     *
     */
    public final static class DocInfoRecdObjLinkProductBuilder
    {

        private DocumentInfoRecord toDocInfoRecord;

        private DocInfoRecdObjLinkProduct.DocInfoRecdObjLinkProductBuilder toDocInfoRecord(
            final DocumentInfoRecord value )
        {
            toDocInfoRecord = value;
            return this;
        }

        /**
         * Navigation property <b>to_DocInfoRecord</b> for <b>DocInfoRecdObjLinkProduct</b> to single
         * <b>DocumentInfoRecord</b>.
         *
         * @param value
         *            The DocumentInfoRecord to build this DocInfoRecdObjLinkProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocInfoRecdObjLinkProduct.DocInfoRecdObjLinkProductBuilder docInfoRecord(
            final DocumentInfoRecord value )
        {
            return toDocInfoRecord(value);
        }

    }

}
