/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.link.DocumentInfoRecordLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable.DocumentInfoRecordSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Info Record
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DocumentInfoRecordType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentInfoRecord extends VdmEntity<DocumentInfoRecord>
{

    /**
     * Selector for all available fields of DocumentInfoRecord.
     *
     */
    public final static DocumentInfoRecordSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<Boolean> UPDATE_MC = new DocumentInfoRecordField<Boolean>("Update_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_DocDesc_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_DocDesc_oc" )
    @JsonProperty( "to_DocDesc_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_DocDesc_oc" )
    private Boolean docDesc_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_DocDesc_oc</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<Boolean> DOC_DESC_OC =
        new DocumentInfoRecordField<Boolean>("to_DocDesc_oc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProductObj_oc</b>
     * </p>
     *
     * @return Dynamic CbA-Control
     */
    @SerializedName( "to_ProductObj_oc" )
    @JsonProperty( "to_ProductObj_oc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "to_ProductObj_oc" )
    private Boolean productObj_oc;
    /**
     * Use with available fluent helpers to apply the <b>to_ProductObj_oc</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<Boolean> PRODUCT_OBJ_OC =
        new DocumentInfoRecordField<Boolean>("to_ProductObj_oc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new DocumentInfoRecordField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new DocumentInfoRecordField<String>("DocumentInfoRecordDocVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new DocumentInfoRecordField<String>("DocumentInfoRecordDocNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return Document Part
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new DocumentInfoRecordField<String>("DocumentInfoRecordDocPart");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @return Document Info Record key in concatenated form
     */
    @SerializedName( "DocumentInfoRecord" )
    @JsonProperty( "DocumentInfoRecord" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecord" )
    private String documentInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecord</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> DOCUMENT_INFO_RECORD =
        new DocumentInfoRecordField<String>("DocumentInfoRecord");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @return Document Status
     */
    @SerializedName( "InternalDocumentStatus" )
    @JsonProperty( "InternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "InternalDocumentStatus" )
    private String internalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>InternalDocumentStatus</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> INTERNAL_DOCUMENT_STATUS =
        new DocumentInfoRecordField<String>("InternalDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @return Laboratory/Design Office
     */
    @SerializedName( "LaboratoryOrDesignOffice" )
    @JsonProperty( "LaboratoryOrDesignOffice" )
    @Nullable
    @ODataField( odataName = "LaboratoryOrDesignOffice" )
    private String laboratoryOrDesignOffice;
    /**
     * Use with available fluent helpers to apply the <b>LaboratoryOrDesignOffice</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> LABORATORY_OR_DESIGN_OFFICE =
        new DocumentInfoRecordField<String>("LaboratoryOrDesignOffice");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @return Authorization Group
     */
    @SerializedName( "AuthorizationGroup" )
    @JsonProperty( "AuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "AuthorizationGroup" )
    private String authorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>AuthorizationGroup</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> AUTHORIZATION_GROUP =
        new DocumentInfoRecordField<String>("AuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ChangeNumber" )
    @JsonProperty( "ChangeNumber" )
    @Nullable
    @ODataField( odataName = "ChangeNumber" )
    private String changeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ChangeNumber</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> CHANGE_NUMBER =
        new DocumentInfoRecordField<String>("ChangeNumber");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocInfoRecdIsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "DocInfoRecdIsMarkedForDeletion" )
    @JsonProperty( "DocInfoRecdIsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "DocInfoRecdIsMarkedForDeletion" )
    private Boolean docInfoRecdIsMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>DocInfoRecdIsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<Boolean> DOC_INFO_RECD_IS_MARKED_FOR_DELETION =
        new DocumentInfoRecordField<Boolean>("DocInfoRecdIsMarkedForDeletion");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocInfoRecdCreatedFromCAD</b>
     * </p>
     *
     * @return CAD Indicator
     */
    @SerializedName( "IsDocInfoRecdCreatedFromCAD" )
    @JsonProperty( "IsDocInfoRecdCreatedFromCAD" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsDocInfoRecdCreatedFromCAD" )
    private Boolean isDocInfoRecdCreatedFromCAD;
    /**
     * Use with available fluent helpers to apply the <b>IsDocInfoRecdCreatedFromCAD</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<Boolean> IS_DOC_INFO_RECD_CREATED_FROM_CAD =
        new DocumentInfoRecordField<Boolean>("IsDocInfoRecdCreatedFromCAD");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDocInfoRecdStructure</b>
     * </p>
     *
     * @return The isDocInfoRecdStructure contained in this entity.
     */
    @SerializedName( "IsDocInfoRecdStructure" )
    @JsonProperty( "IsDocInfoRecdStructure" )
    @Nullable
    @ODataField( odataName = "IsDocInfoRecdStructure" )
    private String isDocInfoRecdStructure;
    /**
     * Use with available fluent helpers to apply the <b>IsDocInfoRecdStructure</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> IS_DOC_INFO_RECD_STRUCTURE =
        new DocumentInfoRecordField<String>("IsDocInfoRecdStructure");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePersonName</b>
     * </p>
     *
     * @return Name of Person Responsible
     */
    @SerializedName( "ResponsiblePersonName" )
    @JsonProperty( "ResponsiblePersonName" )
    @Nullable
    @ODataField( odataName = "ResponsiblePersonName" )
    private String responsiblePersonName;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePersonName</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> RESPONSIBLE_PERSON_NAME =
        new DocumentInfoRecordField<String>("ResponsiblePersonName");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @return Time Document Was Created
     */
    @SerializedName( "CreationDateTime" )
    @JsonProperty( "CreationDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime creationDateTime;
    /**
     * Use with available fluent helpers to apply the <b>CreationDateTime</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<ZonedDateTime> CREATION_DATE_TIME =
        new DocumentInfoRecordField<ZonedDateTime>("CreationDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Document Creator's Name
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> CREATED_BY_USER =
        new DocumentInfoRecordField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return Time last change was made
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<ZonedDateTime> CHANGED_DATE_TIME =
        new DocumentInfoRecordField<ZonedDateTime>("ChangedDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Last Changed By
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> LAST_CHANGED_BY_USER =
        new DocumentInfoRecordField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentStatus</b>
     * </p>
     *
     * @return Status of a document (language-dependent)
     */
    @SerializedName( "ExternalDocumentStatus" )
    @JsonProperty( "ExternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "ExternalDocumentStatus" )
    private String externalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>ExternalDocumentStatus</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> EXTERNAL_DOCUMENT_STATUS =
        new DocumentInfoRecordField<String>("ExternalDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentStatusName</b>
     * </p>
     *
     * @return Description of document status
     */
    @SerializedName( "DocumentStatusName" )
    @JsonProperty( "DocumentStatusName" )
    @Nullable
    @ODataField( odataName = "DocumentStatusName" )
    private String documentStatusName;
    /**
     * Use with available fluent helpers to apply the <b>DocumentStatusName</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordField<String> DOCUMENT_STATUS_NAME =
        new DocumentInfoRecordField<String>("DocumentStatusName");
    /**
     * Navigation property <b>to_BomObj</b> for <b>DocumentInfoRecord</b> to multiple <b>DocInfoRecdObjLinkBOM</b>.
     *
     */
    @SerializedName( "to_BomObj" )
    @JsonProperty( "to_BomObj" )
    @ODataField( odataName = "to_BomObj" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocInfoRecdObjLinkBOM> toBomObj;
    /**
     * Navigation property <b>to_Characteristics</b> for <b>DocumentInfoRecord</b> to multiple
     * <b>DocumentInfoRecordCharc</b>.
     *
     */
    @SerializedName( "to_Characteristics" )
    @JsonProperty( "to_Characteristics" )
    @ODataField( odataName = "to_Characteristics" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocumentInfoRecordCharc> toCharacteristics;
    /**
     * Navigation property <b>to_ChgRecdObj</b> for <b>DocumentInfoRecord</b> to multiple
     * <b>DocInfoRecdObjLinkChgRecd</b>.
     *
     */
    @SerializedName( "to_ChgRecdObj" )
    @JsonProperty( "to_ChgRecdObj" )
    @ODataField( odataName = "to_ChgRecdObj" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocInfoRecdObjLinkChgRecd> toChgRecdObj;
    /**
     * Navigation property <b>to_Classification</b> for <b>DocumentInfoRecord</b> to multiple
     * <b>DocumentInfoRecordClass</b>.
     *
     */
    @SerializedName( "to_Classification" )
    @JsonProperty( "to_Classification" )
    @ODataField( odataName = "to_Classification" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocumentInfoRecordClass> toClassification;
    /**
     * Navigation property <b>to_DocDesc</b> for <b>DocumentInfoRecord</b> to multiple <b>DocumentInfoRecordDesc</b>.
     *
     */
    @SerializedName( "to_DocDesc" )
    @JsonProperty( "to_DocDesc" )
    @ODataField( odataName = "to_DocDesc" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocumentInfoRecordDesc> toDocDesc;
    /**
     * Navigation property <b>to_DocStatusVH</b> for <b>DocumentInfoRecord</b> to multiple
     * <b>DocumentInfoRecordDocStsVH</b>.
     *
     */
    @SerializedName( "to_DocStatusVH" )
    @JsonProperty( "to_DocStatusVH" )
    @ODataField( odataName = "to_DocStatusVH" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocumentInfoRecordDocStsVH> toDocStatusVH;
    /**
     * Navigation property <b>to_ProductObj</b> for <b>DocumentInfoRecord</b> to multiple
     * <b>DocInfoRecdObjLinkProduct</b>.
     *
     */
    @SerializedName( "to_ProductObj" )
    @JsonProperty( "to_ProductObj" )
    @ODataField( odataName = "to_ProductObj" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<DocInfoRecdObjLinkProduct> toProductObj;
    /**
     * Use with available fluent helpers to apply the <b>to_BomObj</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordLink<DocInfoRecdObjLinkBOM> TO_BOM_OBJ =
        new DocumentInfoRecordLink<DocInfoRecdObjLinkBOM>("to_BomObj");
    /**
     * Use with available fluent helpers to apply the <b>to_Characteristics</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordLink<DocumentInfoRecordCharc> TO_CHARACTERISTICS =
        new DocumentInfoRecordLink<DocumentInfoRecordCharc>("to_Characteristics");
    /**
     * Use with available fluent helpers to apply the <b>to_ChgRecdObj</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordLink<DocInfoRecdObjLinkChgRecd> TO_CHG_RECD_OBJ =
        new DocumentInfoRecordLink<DocInfoRecdObjLinkChgRecd>("to_ChgRecdObj");
    /**
     * Use with available fluent helpers to apply the <b>to_Classification</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordLink<DocumentInfoRecordClass> TO_CLASSIFICATION =
        new DocumentInfoRecordLink<DocumentInfoRecordClass>("to_Classification");
    /**
     * Use with available fluent helpers to apply the <b>to_DocDesc</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordLink<DocumentInfoRecordDesc> TO_DOC_DESC =
        new DocumentInfoRecordLink<DocumentInfoRecordDesc>("to_DocDesc");
    /**
     * Use with available fluent helpers to apply the <b>to_DocStatusVH</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordLink<DocumentInfoRecordDocStsVH> TO_DOC_STATUS_VH =
        new DocumentInfoRecordLink<DocumentInfoRecordDocStsVH>("to_DocStatusVH");
    /**
     * Use with available fluent helpers to apply the <b>to_ProductObj</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordLink<DocInfoRecdObjLinkProduct> TO_PRODUCT_OBJ =
        new DocumentInfoRecordLink<DocInfoRecdObjLinkProduct>("to_ProductObj");

    @Nonnull
    @Override
    public Class<DocumentInfoRecord> getType()
    {
        return DocumentInfoRecord.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_DocDesc_oc</b>
     * </p>
     *
     * @param docDesc_oc
     *            Dynamic CbA-Control
     */
    public void setDocDesc_oc( @Nullable final Boolean docDesc_oc )
    {
        rememberChangedField("to_DocDesc_oc", this.docDesc_oc);
        this.docDesc_oc = docDesc_oc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>to_ProductObj_oc</b>
     * </p>
     *
     * @param productObj_oc
     *            Dynamic CbA-Control
     */
    public void setProductObj_oc( @Nullable final Boolean productObj_oc )
    {
        rememberChangedField("to_ProductObj_oc", this.productObj_oc);
        this.productObj_oc = productObj_oc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            Document Type
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            Document Version
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            Document number
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            Document Part
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecord</b>
     * </p>
     *
     * @param documentInfoRecord
     *            Document Info Record key in concatenated form
     */
    public void setDocumentInfoRecord( @Nullable final String documentInfoRecord )
    {
        rememberChangedField("DocumentInfoRecord", this.documentInfoRecord);
        this.documentInfoRecord = documentInfoRecord;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @param internalDocumentStatus
     *            Document Status
     */
    public void setInternalDocumentStatus( @Nullable final String internalDocumentStatus )
    {
        rememberChangedField("InternalDocumentStatus", this.internalDocumentStatus);
        this.internalDocumentStatus = internalDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>LaboratoryOrDesignOffice</b>
     * </p>
     *
     * @param laboratoryOrDesignOffice
     *            Laboratory/Design Office
     */
    public void setLaboratoryOrDesignOffice( @Nullable final String laboratoryOrDesignOffice )
    {
        rememberChangedField("LaboratoryOrDesignOffice", this.laboratoryOrDesignOffice);
        this.laboratoryOrDesignOffice = laboratoryOrDesignOffice;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>AuthorizationGroup</b>
     * </p>
     *
     * @param authorizationGroup
     *            Authorization Group
     */
    public void setAuthorizationGroup( @Nullable final String authorizationGroup )
    {
        rememberChangedField("AuthorizationGroup", this.authorizationGroup);
        this.authorizationGroup = authorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ChangeNumber</b>
     * </p>
     *
     * @param changeNumber
     *            Change Number
     */
    public void setChangeNumber( @Nullable final String changeNumber )
    {
        rememberChangedField("ChangeNumber", this.changeNumber);
        this.changeNumber = changeNumber;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>DocInfoRecdIsMarkedForDeletion</b>
     * </p>
     *
     * @param docInfoRecdIsMarkedForDeletion
     *            Deletion Indicator
     */
    public void setDocInfoRecdIsMarkedForDeletion( @Nullable final Boolean docInfoRecdIsMarkedForDeletion )
    {
        rememberChangedField("DocInfoRecdIsMarkedForDeletion", this.docInfoRecdIsMarkedForDeletion);
        this.docInfoRecdIsMarkedForDeletion = docInfoRecdIsMarkedForDeletion;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsDocInfoRecdCreatedFromCAD</b>
     * </p>
     *
     * @param isDocInfoRecdCreatedFromCAD
     *            CAD Indicator
     */
    public void setIsDocInfoRecdCreatedFromCAD( @Nullable final Boolean isDocInfoRecdCreatedFromCAD )
    {
        rememberChangedField("IsDocInfoRecdCreatedFromCAD", this.isDocInfoRecdCreatedFromCAD);
        this.isDocInfoRecdCreatedFromCAD = isDocInfoRecdCreatedFromCAD;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>IsDocInfoRecdStructure</b>
     * </p>
     *
     * @param isDocInfoRecdStructure
     *            The isDocInfoRecdStructure to set.
     */
    public void setIsDocInfoRecdStructure( @Nullable final String isDocInfoRecdStructure )
    {
        rememberChangedField("IsDocInfoRecdStructure", this.isDocInfoRecdStructure);
        this.isDocInfoRecdStructure = isDocInfoRecdStructure;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePersonName</b>
     * </p>
     *
     * @param responsiblePersonName
     *            Name of Person Responsible
     */
    public void setResponsiblePersonName( @Nullable final String responsiblePersonName )
    {
        rememberChangedField("ResponsiblePersonName", this.responsiblePersonName);
        this.responsiblePersonName = responsiblePersonName;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDateTime</b>
     * </p>
     *
     * @param creationDateTime
     *            Time Document Was Created
     */
    public void setCreationDateTime( @Nullable final ZonedDateTime creationDateTime )
    {
        rememberChangedField("CreationDateTime", this.creationDateTime);
        this.creationDateTime = creationDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Document Creator's Name
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            Time last change was made
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Last Changed By
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentStatus</b>
     * </p>
     *
     * @param externalDocumentStatus
     *            Status of a document (language-dependent)
     */
    public void setExternalDocumentStatus( @Nullable final String externalDocumentStatus )
    {
        rememberChangedField("ExternalDocumentStatus", this.externalDocumentStatus);
        this.externalDocumentStatus = externalDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentStatusName</b>
     * </p>
     *
     * @param documentStatusName
     *            Description of document status
     */
    public void setDocumentStatusName( @Nullable final String documentStatusName )
    {
        rememberChangedField("DocumentStatusName", this.documentStatusName);
        this.documentStatusName = documentStatusName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DocumentInfoRecord";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        result.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        result.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Update_mc", getUpdate_mc());
        values.put("to_DocDesc_oc", getDocDesc_oc());
        values.put("to_ProductObj_oc", getProductObj_oc());
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("DocumentInfoRecord", getDocumentInfoRecord());
        values.put("InternalDocumentStatus", getInternalDocumentStatus());
        values.put("LaboratoryOrDesignOffice", getLaboratoryOrDesignOffice());
        values.put("AuthorizationGroup", getAuthorizationGroup());
        values.put("ChangeNumber", getChangeNumber());
        values.put("DocInfoRecdIsMarkedForDeletion", getDocInfoRecdIsMarkedForDeletion());
        values.put("IsDocInfoRecdCreatedFromCAD", getIsDocInfoRecdCreatedFromCAD());
        values.put("IsDocInfoRecdStructure", getIsDocInfoRecdStructure());
        values.put("ResponsiblePersonName", getResponsiblePersonName());
        values.put("CreationDateTime", getCreationDateTime());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("ChangedDateTime", getChangedDateTime());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("ExternalDocumentStatus", getExternalDocumentStatus());
        values.put("DocumentStatusName", getDocumentStatusName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("to_DocDesc_oc") ) {
                final Object value = values.remove("to_DocDesc_oc");
                if( (value == null) || (!value.equals(getDocDesc_oc())) ) {
                    setDocDesc_oc(((Boolean) value));
                }
            }
            if( values.containsKey("to_ProductObj_oc") ) {
                final Object value = values.remove("to_ProductObj_oc");
                if( (value == null) || (!value.equals(getProductObj_oc())) ) {
                    setProductObj_oc(((Boolean) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecord") ) {
                final Object value = values.remove("DocumentInfoRecord");
                if( (value == null) || (!value.equals(getDocumentInfoRecord())) ) {
                    setDocumentInfoRecord(((String) value));
                }
            }
            if( values.containsKey("InternalDocumentStatus") ) {
                final Object value = values.remove("InternalDocumentStatus");
                if( (value == null) || (!value.equals(getInternalDocumentStatus())) ) {
                    setInternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("LaboratoryOrDesignOffice") ) {
                final Object value = values.remove("LaboratoryOrDesignOffice");
                if( (value == null) || (!value.equals(getLaboratoryOrDesignOffice())) ) {
                    setLaboratoryOrDesignOffice(((String) value));
                }
            }
            if( values.containsKey("AuthorizationGroup") ) {
                final Object value = values.remove("AuthorizationGroup");
                if( (value == null) || (!value.equals(getAuthorizationGroup())) ) {
                    setAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("ChangeNumber") ) {
                final Object value = values.remove("ChangeNumber");
                if( (value == null) || (!value.equals(getChangeNumber())) ) {
                    setChangeNumber(((String) value));
                }
            }
            if( values.containsKey("DocInfoRecdIsMarkedForDeletion") ) {
                final Object value = values.remove("DocInfoRecdIsMarkedForDeletion");
                if( (value == null) || (!value.equals(getDocInfoRecdIsMarkedForDeletion())) ) {
                    setDocInfoRecdIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("IsDocInfoRecdCreatedFromCAD") ) {
                final Object value = values.remove("IsDocInfoRecdCreatedFromCAD");
                if( (value == null) || (!value.equals(getIsDocInfoRecdCreatedFromCAD())) ) {
                    setIsDocInfoRecdCreatedFromCAD(((Boolean) value));
                }
            }
            if( values.containsKey("IsDocInfoRecdStructure") ) {
                final Object value = values.remove("IsDocInfoRecdStructure");
                if( (value == null) || (!value.equals(getIsDocInfoRecdStructure())) ) {
                    setIsDocInfoRecdStructure(((String) value));
                }
            }
            if( values.containsKey("ResponsiblePersonName") ) {
                final Object value = values.remove("ResponsiblePersonName");
                if( (value == null) || (!value.equals(getResponsiblePersonName())) ) {
                    setResponsiblePersonName(((String) value));
                }
            }
            if( values.containsKey("CreationDateTime") ) {
                final Object value = values.remove("CreationDateTime");
                if( (value == null) || (!value.equals(getCreationDateTime())) ) {
                    setCreationDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("ExternalDocumentStatus") ) {
                final Object value = values.remove("ExternalDocumentStatus");
                if( (value == null) || (!value.equals(getExternalDocumentStatus())) ) {
                    setExternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("DocumentStatusName") ) {
                final Object value = values.remove("DocumentStatusName");
                if( (value == null) || (!value.equals(getDocumentStatusName())) ) {
                    setDocumentStatusName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_BomObj") ) {
                final Object value = (values).remove("to_BomObj");
                if( value instanceof Iterable ) {
                    if( toBomObj == null ) {
                        toBomObj = Lists.newArrayList();
                    } else {
                        toBomObj = Lists.newArrayList(toBomObj);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocInfoRecdObjLinkBOM entity;
                        if( toBomObj.size() > i ) {
                            entity = toBomObj.get(i);
                        } else {
                            entity = new DocInfoRecdObjLinkBOM();
                            toBomObj.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Characteristics") ) {
                final Object value = (values).remove("to_Characteristics");
                if( value instanceof Iterable ) {
                    if( toCharacteristics == null ) {
                        toCharacteristics = Lists.newArrayList();
                    } else {
                        toCharacteristics = Lists.newArrayList(toCharacteristics);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocumentInfoRecordCharc entity;
                        if( toCharacteristics.size() > i ) {
                            entity = toCharacteristics.get(i);
                        } else {
                            entity = new DocumentInfoRecordCharc();
                            toCharacteristics.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ChgRecdObj") ) {
                final Object value = (values).remove("to_ChgRecdObj");
                if( value instanceof Iterable ) {
                    if( toChgRecdObj == null ) {
                        toChgRecdObj = Lists.newArrayList();
                    } else {
                        toChgRecdObj = Lists.newArrayList(toChgRecdObj);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocInfoRecdObjLinkChgRecd entity;
                        if( toChgRecdObj.size() > i ) {
                            entity = toChgRecdObj.get(i);
                        } else {
                            entity = new DocInfoRecdObjLinkChgRecd();
                            toChgRecdObj.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Classification") ) {
                final Object value = (values).remove("to_Classification");
                if( value instanceof Iterable ) {
                    if( toClassification == null ) {
                        toClassification = Lists.newArrayList();
                    } else {
                        toClassification = Lists.newArrayList(toClassification);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocumentInfoRecordClass entity;
                        if( toClassification.size() > i ) {
                            entity = toClassification.get(i);
                        } else {
                            entity = new DocumentInfoRecordClass();
                            toClassification.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_DocDesc") ) {
                final Object value = (values).remove("to_DocDesc");
                if( value instanceof Iterable ) {
                    if( toDocDesc == null ) {
                        toDocDesc = Lists.newArrayList();
                    } else {
                        toDocDesc = Lists.newArrayList(toDocDesc);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocumentInfoRecordDesc entity;
                        if( toDocDesc.size() > i ) {
                            entity = toDocDesc.get(i);
                        } else {
                            entity = new DocumentInfoRecordDesc();
                            toDocDesc.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_DocStatusVH") ) {
                final Object value = (values).remove("to_DocStatusVH");
                if( value instanceof Iterable ) {
                    if( toDocStatusVH == null ) {
                        toDocStatusVH = Lists.newArrayList();
                    } else {
                        toDocStatusVH = Lists.newArrayList(toDocStatusVH);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocumentInfoRecordDocStsVH entity;
                        if( toDocStatusVH.size() > i ) {
                            entity = toDocStatusVH.get(i);
                        } else {
                            entity = new DocumentInfoRecordDocStsVH();
                            toDocStatusVH.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_ProductObj") ) {
                final Object value = (values).remove("to_ProductObj");
                if( value instanceof Iterable ) {
                    if( toProductObj == null ) {
                        toProductObj = Lists.newArrayList();
                    } else {
                        toProductObj = Lists.newArrayList(toProductObj);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        DocInfoRecdObjLinkProduct entity;
                        if( toProductObj.size() > i ) {
                            entity = toProductObj.get(i);
                        } else {
                            entity = new DocInfoRecdObjLinkProduct();
                            toProductObj.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DocumentInfoRecordField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DocumentInfoRecordField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentInfoRecordField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentInfoRecordField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toBomObj != null ) {
            (values).put("to_BomObj", toBomObj);
        }
        if( toCharacteristics != null ) {
            (values).put("to_Characteristics", toCharacteristics);
        }
        if( toChgRecdObj != null ) {
            (values).put("to_ChgRecdObj", toChgRecdObj);
        }
        if( toClassification != null ) {
            (values).put("to_Classification", toClassification);
        }
        if( toDocDesc != null ) {
            (values).put("to_DocDesc", toDocDesc);
        }
        if( toDocStatusVH != null ) {
            (values).put("to_DocStatusVH", toDocStatusVH);
        }
        if( toProductObj != null ) {
            (values).put("to_ProductObj", toProductObj);
        }
        return values;
    }

    /**
     * Fetches the <b>DocInfoRecdObjLinkBOM</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_BomObj</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocInfoRecdObjLinkBOM</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocInfoRecdObjLinkBOM> fetchBomObj()
    {
        return fetchFieldAsList("to_BomObj", DocInfoRecdObjLinkBOM.class);
    }

    /**
     * Retrieval of associated <b>DocInfoRecdObjLinkBOM</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BomObj</b>.
     * <p>
     * If the navigation property <b>to_BomObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocInfoRecdObjLinkBOM</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocInfoRecdObjLinkBOM> getBomObjOrFetch()
    {
        if( toBomObj == null ) {
            toBomObj = fetchBomObj();
        }
        return toBomObj;
    }

    /**
     * Retrieval of associated <b>DocInfoRecdObjLinkBOM</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_BomObj</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_BomObj</b> is already loaded, the result will contain
     *         the <b>DocInfoRecdObjLinkBOM</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocInfoRecdObjLinkBOM>> getBomObjIfPresent()
    {
        return Option.of(toBomObj);
    }

    /**
     * Overwrites the list of associated <b>DocInfoRecdObjLinkBOM</b> entities for the loaded navigation property
     * <b>to_BomObj</b>.
     * <p>
     * If the navigation property <b>to_BomObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocInfoRecdObjLinkBOM</b> entities.
     */
    public void setBomObj( @Nonnull final List<DocInfoRecdObjLinkBOM> value )
    {
        if( toBomObj == null ) {
            toBomObj = Lists.newArrayList();
        }
        toBomObj.clear();
        toBomObj.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocInfoRecdObjLinkBOM</b> entities. This corresponds to the OData
     * navigation property <b>to_BomObj</b>.
     * <p>
     * If the navigation property <b>to_BomObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocInfoRecdObjLinkBOM</b> entities.
     */
    public void addBomObj( DocInfoRecdObjLinkBOM... entity )
    {
        if( toBomObj == null ) {
            toBomObj = Lists.newArrayList();
        }
        toBomObj.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DocumentInfoRecordCharc</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Characteristics</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocumentInfoRecordCharc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordCharc> fetchCharacteristics()
    {
        return fetchFieldAsList("to_Characteristics", DocumentInfoRecordCharc.class);
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>DocumentInfoRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentInfoRecordCharc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordCharc> getCharacteristicsOrFetch()
    {
        if( toCharacteristics == null ) {
            toCharacteristics = fetchCharacteristics();
        }
        return toCharacteristics;
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordCharc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Characteristics</b> is already loaded, the result will
     *         contain the <b>DocumentInfoRecordCharc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocumentInfoRecordCharc>> getCharacteristicsIfPresent()
    {
        return Option.of(toCharacteristics);
    }

    /**
     * Overwrites the list of associated <b>DocumentInfoRecordCharc</b> entities for the loaded navigation property
     * <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>DocumentInfoRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocumentInfoRecordCharc</b> entities.
     */
    public void setCharacteristics( @Nonnull final List<DocumentInfoRecordCharc> value )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.clear();
        toCharacteristics.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocumentInfoRecordCharc</b> entities. This corresponds to the OData
     * navigation property <b>to_Characteristics</b>.
     * <p>
     * If the navigation property <b>to_Characteristics</b> of a queried <b>DocumentInfoRecord</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocumentInfoRecordCharc</b> entities.
     */
    public void addCharacteristics( DocumentInfoRecordCharc... entity )
    {
        if( toCharacteristics == null ) {
            toCharacteristics = Lists.newArrayList();
        }
        toCharacteristics.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DocInfoRecdObjLinkChgRecd</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ChgRecdObj</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocInfoRecdObjLinkChgRecd</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocInfoRecdObjLinkChgRecd> fetchChgRecdObj()
    {
        return fetchFieldAsList("to_ChgRecdObj", DocInfoRecdObjLinkChgRecd.class);
    }

    /**
     * Retrieval of associated <b>DocInfoRecdObjLinkChgRecd</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChgRecdObj</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocInfoRecdObjLinkChgRecd</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocInfoRecdObjLinkChgRecd> getChgRecdObjOrFetch()
    {
        if( toChgRecdObj == null ) {
            toChgRecdObj = fetchChgRecdObj();
        }
        return toChgRecdObj;
    }

    /**
     * Retrieval of associated <b>DocInfoRecdObjLinkChgRecd</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ChgRecdObj</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ChgRecdObj</b> is already loaded, the result will
     *         contain the <b>DocInfoRecdObjLinkChgRecd</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocInfoRecdObjLinkChgRecd>> getChgRecdObjIfPresent()
    {
        return Option.of(toChgRecdObj);
    }

    /**
     * Overwrites the list of associated <b>DocInfoRecdObjLinkChgRecd</b> entities for the loaded navigation property
     * <b>to_ChgRecdObj</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocInfoRecdObjLinkChgRecd</b> entities.
     */
    public void setChgRecdObj( @Nonnull final List<DocInfoRecdObjLinkChgRecd> value )
    {
        if( toChgRecdObj == null ) {
            toChgRecdObj = Lists.newArrayList();
        }
        toChgRecdObj.clear();
        toChgRecdObj.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocInfoRecdObjLinkChgRecd</b> entities. This corresponds to the OData
     * navigation property <b>to_ChgRecdObj</b>.
     * <p>
     * If the navigation property <b>to_ChgRecdObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocInfoRecdObjLinkChgRecd</b> entities.
     */
    public void addChgRecdObj( DocInfoRecdObjLinkChgRecd... entity )
    {
        if( toChgRecdObj == null ) {
            toChgRecdObj = Lists.newArrayList();
        }
        toChgRecdObj.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DocumentInfoRecordClass</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_Classification</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocumentInfoRecordClass</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordClass> fetchClassification()
    {
        return fetchFieldAsList("to_Classification", DocumentInfoRecordClass.class);
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentInfoRecordClass</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordClass> getClassificationOrFetch()
    {
        if( toClassification == null ) {
            toClassification = fetchClassification();
        }
        return toClassification;
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordClass</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_Classification</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Classification</b> is already loaded, the result will
     *         contain the <b>DocumentInfoRecordClass</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocumentInfoRecordClass>> getClassificationIfPresent()
    {
        return Option.of(toClassification);
    }

    /**
     * Overwrites the list of associated <b>DocumentInfoRecordClass</b> entities for the loaded navigation property
     * <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocumentInfoRecordClass</b> entities.
     */
    public void setClassification( @Nonnull final List<DocumentInfoRecordClass> value )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.clear();
        toClassification.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocumentInfoRecordClass</b> entities. This corresponds to the OData
     * navigation property <b>to_Classification</b>.
     * <p>
     * If the navigation property <b>to_Classification</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocumentInfoRecordClass</b> entities.
     */
    public void addClassification( DocumentInfoRecordClass... entity )
    {
        if( toClassification == null ) {
            toClassification = Lists.newArrayList();
        }
        toClassification.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DocumentInfoRecordDesc</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_DocDesc</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocumentInfoRecordDesc</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordDesc> fetchDocDesc()
    {
        return fetchFieldAsList("to_DocDesc", DocumentInfoRecordDesc.class);
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordDesc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DocDesc</b>.
     * <p>
     * If the navigation property <b>to_DocDesc</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentInfoRecordDesc</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordDesc> getDocDescOrFetch()
    {
        if( toDocDesc == null ) {
            toDocDesc = fetchDocDesc();
        }
        return toDocDesc;
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordDesc</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DocDesc</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DocDesc</b> is already loaded, the result will contain
     *         the <b>DocumentInfoRecordDesc</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocumentInfoRecordDesc>> getDocDescIfPresent()
    {
        return Option.of(toDocDesc);
    }

    /**
     * Overwrites the list of associated <b>DocumentInfoRecordDesc</b> entities for the loaded navigation property
     * <b>to_DocDesc</b>.
     * <p>
     * If the navigation property <b>to_DocDesc</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocumentInfoRecordDesc</b> entities.
     */
    public void setDocDesc( @Nonnull final List<DocumentInfoRecordDesc> value )
    {
        if( toDocDesc == null ) {
            toDocDesc = Lists.newArrayList();
        }
        toDocDesc.clear();
        toDocDesc.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocumentInfoRecordDesc</b> entities. This corresponds to the OData
     * navigation property <b>to_DocDesc</b>.
     * <p>
     * If the navigation property <b>to_DocDesc</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocumentInfoRecordDesc</b> entities.
     */
    public void addDocDesc( DocumentInfoRecordDesc... entity )
    {
        if( toDocDesc == null ) {
            toDocDesc = Lists.newArrayList();
        }
        toDocDesc.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DocumentInfoRecordDocStsVH</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_DocStatusVH</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocumentInfoRecordDocStsVH</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordDocStsVH> fetchDocStatusVH()
    {
        return fetchFieldAsList("to_DocStatusVH", DocumentInfoRecordDocStsVH.class);
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordDocStsVH</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DocStatusVH</b>.
     * <p>
     * If the navigation property <b>to_DocStatusVH</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentInfoRecordDocStsVH</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocumentInfoRecordDocStsVH> getDocStatusVHOrFetch()
    {
        if( toDocStatusVH == null ) {
            toDocStatusVH = fetchDocStatusVH();
        }
        return toDocStatusVH;
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecordDocStsVH</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_DocStatusVH</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DocStatusVH</b> is already loaded, the result will
     *         contain the <b>DocumentInfoRecordDocStsVH</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocumentInfoRecordDocStsVH>> getDocStatusVHIfPresent()
    {
        return Option.of(toDocStatusVH);
    }

    /**
     * Overwrites the list of associated <b>DocumentInfoRecordDocStsVH</b> entities for the loaded navigation property
     * <b>to_DocStatusVH</b>.
     * <p>
     * If the navigation property <b>to_DocStatusVH</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocumentInfoRecordDocStsVH</b> entities.
     */
    public void setDocStatusVH( @Nonnull final List<DocumentInfoRecordDocStsVH> value )
    {
        if( toDocStatusVH == null ) {
            toDocStatusVH = Lists.newArrayList();
        }
        toDocStatusVH.clear();
        toDocStatusVH.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocumentInfoRecordDocStsVH</b> entities. This corresponds to the OData
     * navigation property <b>to_DocStatusVH</b>.
     * <p>
     * If the navigation property <b>to_DocStatusVH</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocumentInfoRecordDocStsVH</b> entities.
     */
    public void addDocStatusVH( DocumentInfoRecordDocStsVH... entity )
    {
        if( toDocStatusVH == null ) {
            toDocStatusVH = Lists.newArrayList();
        }
        toDocStatusVH.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>DocInfoRecdObjLinkProduct</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_ProductObj</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>DocInfoRecdObjLinkProduct</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocInfoRecdObjLinkProduct> fetchProductObj()
    {
        return fetchFieldAsList("to_ProductObj", DocInfoRecdObjLinkProduct.class);
    }

    /**
     * Retrieval of associated <b>DocInfoRecdObjLinkProduct</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductObj</b>.
     * <p>
     * If the navigation property <b>to_ProductObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocInfoRecdObjLinkProduct</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<DocInfoRecdObjLinkProduct> getProductObjOrFetch()
    {
        if( toProductObj == null ) {
            toProductObj = fetchProductObj();
        }
        return toProductObj;
    }

    /**
     * Retrieval of associated <b>DocInfoRecdObjLinkProduct</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_ProductObj</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecord</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_ProductObj</b> is already loaded, the result will
     *         contain the <b>DocInfoRecdObjLinkProduct</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<DocInfoRecdObjLinkProduct>> getProductObjIfPresent()
    {
        return Option.of(toProductObj);
    }

    /**
     * Overwrites the list of associated <b>DocInfoRecdObjLinkProduct</b> entities for the loaded navigation property
     * <b>to_ProductObj</b>.
     * <p>
     * If the navigation property <b>to_ProductObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>DocInfoRecdObjLinkProduct</b> entities.
     */
    public void setProductObj( @Nonnull final List<DocInfoRecdObjLinkProduct> value )
    {
        if( toProductObj == null ) {
            toProductObj = Lists.newArrayList();
        }
        toProductObj.clear();
        toProductObj.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>DocInfoRecdObjLinkProduct</b> entities. This corresponds to the OData
     * navigation property <b>to_ProductObj</b>.
     * <p>
     * If the navigation property <b>to_ProductObj</b> of a queried <b>DocumentInfoRecord</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>DocInfoRecdObjLinkProduct</b> entities.
     */
    public void addProductObj( DocInfoRecdObjLinkProduct... entity )
    {
        if( toProductObj == null ) {
            toProductObj = Lists.newArrayList();
        }
        toProductObj.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of DocumentInfoRecord instances.
     *
     */
    public final static class DocumentInfoRecordBuilder
    {

        private List<DocInfoRecdObjLinkBOM> toBomObj = Lists.newArrayList();
        private List<DocumentInfoRecordCharc> toCharacteristics = Lists.newArrayList();
        private List<DocInfoRecdObjLinkChgRecd> toChgRecdObj = Lists.newArrayList();
        private List<DocumentInfoRecordClass> toClassification = Lists.newArrayList();
        private List<DocumentInfoRecordDesc> toDocDesc = Lists.newArrayList();
        private List<DocumentInfoRecordDocStsVH> toDocStatusVH = Lists.newArrayList();
        private List<DocInfoRecdObjLinkProduct> toProductObj = Lists.newArrayList();

        private DocumentInfoRecord.DocumentInfoRecordBuilder toBomObj( final List<DocInfoRecdObjLinkBOM> value )
        {
            toBomObj.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_BomObj</b> for <b>DocumentInfoRecord</b> to multiple <b>DocInfoRecdObjLinkBOM</b>.
         *
         * @param value
         *            The DocInfoRecdObjLinkBOMs to build this DocumentInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecord.DocumentInfoRecordBuilder bomObj( DocInfoRecdObjLinkBOM... value )
        {
            return toBomObj(Lists.newArrayList(value));
        }

        private DocumentInfoRecord.DocumentInfoRecordBuilder toCharacteristics(
            final List<DocumentInfoRecordCharc> value )
        {
            toCharacteristics.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Characteristics</b> for <b>DocumentInfoRecord</b> to multiple
         * <b>DocumentInfoRecordCharc</b>.
         *
         * @param value
         *            The DocumentInfoRecordCharcs to build this DocumentInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecord.DocumentInfoRecordBuilder characteristics( DocumentInfoRecordCharc... value )
        {
            return toCharacteristics(Lists.newArrayList(value));
        }

        private DocumentInfoRecord.DocumentInfoRecordBuilder toChgRecdObj( final List<DocInfoRecdObjLinkChgRecd> value )
        {
            toChgRecdObj.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ChgRecdObj</b> for <b>DocumentInfoRecord</b> to multiple
         * <b>DocInfoRecdObjLinkChgRecd</b>.
         *
         * @param value
         *            The DocInfoRecdObjLinkChgRecds to build this DocumentInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecord.DocumentInfoRecordBuilder chgRecdObj( DocInfoRecdObjLinkChgRecd... value )
        {
            return toChgRecdObj(Lists.newArrayList(value));
        }

        private DocumentInfoRecord.DocumentInfoRecordBuilder toClassification(
            final List<DocumentInfoRecordClass> value )
        {
            toClassification.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Classification</b> for <b>DocumentInfoRecord</b> to multiple
         * <b>DocumentInfoRecordClass</b>.
         *
         * @param value
         *            The DocumentInfoRecordClasss to build this DocumentInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecord.DocumentInfoRecordBuilder classification( DocumentInfoRecordClass... value )
        {
            return toClassification(Lists.newArrayList(value));
        }

        private DocumentInfoRecord.DocumentInfoRecordBuilder toDocDesc( final List<DocumentInfoRecordDesc> value )
        {
            toDocDesc.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_DocDesc</b> for <b>DocumentInfoRecord</b> to multiple
         * <b>DocumentInfoRecordDesc</b>.
         *
         * @param value
         *            The DocumentInfoRecordDescs to build this DocumentInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecord.DocumentInfoRecordBuilder docDesc( DocumentInfoRecordDesc... value )
        {
            return toDocDesc(Lists.newArrayList(value));
        }

        private DocumentInfoRecord.DocumentInfoRecordBuilder toDocStatusVH(
            final List<DocumentInfoRecordDocStsVH> value )
        {
            toDocStatusVH.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_DocStatusVH</b> for <b>DocumentInfoRecord</b> to multiple
         * <b>DocumentInfoRecordDocStsVH</b>.
         *
         * @param value
         *            The DocumentInfoRecordDocStsVHs to build this DocumentInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecord.DocumentInfoRecordBuilder docStatusVH( DocumentInfoRecordDocStsVH... value )
        {
            return toDocStatusVH(Lists.newArrayList(value));
        }

        private DocumentInfoRecord.DocumentInfoRecordBuilder toProductObj( final List<DocInfoRecdObjLinkProduct> value )
        {
            toProductObj.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_ProductObj</b> for <b>DocumentInfoRecord</b> to multiple
         * <b>DocInfoRecdObjLinkProduct</b>.
         *
         * @param value
         *            The DocInfoRecdObjLinkProducts to build this DocumentInfoRecord with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecord.DocumentInfoRecordBuilder productObj( DocInfoRecdObjLinkProduct... value )
        {
            return toProductObj(Lists.newArrayList(value));
        }

    }

}
