/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordCharcValueField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable.DocumentInfoRecordCharcValueSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Classification Characteristic Values
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DocumentInfoRecordCharcValueType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentInfoRecordCharcValue extends VdmEntity<DocumentInfoRecordCharcValue>
{

    /**
     * Selector for all available fields of DocumentInfoRecordCharcValue.
     *
     */
    public final static DocumentInfoRecordCharcValueSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new DocumentInfoRecordCharcValueField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new DocumentInfoRecordCharcValueField<String>("DocumentInfoRecordDocNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new DocumentInfoRecordCharcValueField<String>("DocumentInfoRecordDocVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return Document Part
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new DocumentInfoRecordCharcValueField<String>("DocumentInfoRecordDocPart");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @Key
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CLASS_TYPE =
        new DocumentInfoRecordCharcValueField<String>("ClassType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARC_INTERNAL_ID =
        new DocumentInfoRecordCharcValueField<String>("CharcInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @return Characteristic value counter
     */
    @Key
    @SerializedName( "CharcValuePositionNumber" )
    @JsonProperty( "CharcValuePositionNumber" )
    @Nullable
    @ODataField( odataName = "CharcValuePositionNumber" )
    private String charcValuePositionNumber;
    /**
     * Use with available fluent helpers to apply the <b>CharcValuePositionNumber</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARC_VALUE_POSITION_NUMBER =
        new DocumentInfoRecordCharcValueField<String>("CharcValuePositionNumber");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<LocalDateTime> KEY_DATE =
        new DocumentInfoRecordCharcValueField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @return Code for value dependency
     */
    @SerializedName( "CharcValueDependency" )
    @JsonProperty( "CharcValueDependency" )
    @Nullable
    @ODataField( odataName = "CharcValueDependency" )
    private String charcValueDependency;
    /**
     * Use with available fluent helpers to apply the <b>CharcValueDependency</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARC_VALUE_DEPENDENCY =
        new DocumentInfoRecordCharcValueField<String>("CharcValueDependency");
    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @return Characteristic Value
     */
    @SerializedName( "CharcValue" )
    @JsonProperty( "CharcValue" )
    @Nullable
    @ODataField( odataName = "CharcValue" )
    private String charcValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcValue</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARC_VALUE =
        new DocumentInfoRecordCharcValueField<String>("CharcValue");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @return Internal floating point from
     */
    @SerializedName( "CharcFromNumericValue" )
    @JsonProperty( "CharcFromNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValue" )
    private Double charcFromNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValue</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<Double> CHARC_FROM_NUMERIC_VALUE =
        new DocumentInfoRecordCharcValueField<Double>("CharcFromNumericValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcFromNumericValueUnit" )
    @JsonProperty( "CharcFromNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcFromNumericValueUnit" )
    private String charcFromNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromNumericValueUnit</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARC_FROM_NUMERIC_VALUE_UNIT =
        new DocumentInfoRecordCharcValueField<String>("CharcFromNumericValueUnit");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @return Internal floating point value to
     */
    @SerializedName( "CharcToNumericValue" )
    @JsonProperty( "CharcToNumericValue" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValue" )
    private Double charcToNumericValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValue</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<Double> CHARC_TO_NUMERIC_VALUE =
        new DocumentInfoRecordCharcValueField<Double>("CharcToNumericValue");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @return Unit of Measurement
     */
    @SerializedName( "CharcToNumericValueUnit" )
    @JsonProperty( "CharcToNumericValueUnit" )
    @Nullable
    @ODataField( odataName = "CharcToNumericValueUnit" )
    private String charcToNumericValueUnit;
    /**
     * Use with available fluent helpers to apply the <b>CharcToNumericValueUnit</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARC_TO_NUMERIC_VALUE_UNIT =
        new DocumentInfoRecordCharcValueField<String>("CharcToNumericValueUnit");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDecimalValue</b>
     * </p>
     *
     * @return Lower Boundary for Numeric Field
     */
    @SerializedName( "CharcFromDecimalValue" )
    @JsonProperty( "CharcFromDecimalValue" )
    @Nullable
    @ODataField( odataName = "CharcFromDecimalValue" )
    private BigDecimal charcFromDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromDecimalValue</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<BigDecimal> CHARC_FROM_DECIMAL_VALUE =
        new DocumentInfoRecordCharcValueField<BigDecimal>("CharcFromDecimalValue");
    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDecimalValue</b>
     * </p>
     *
     * @return Upper Boundary for Numeric Field
     */
    @SerializedName( "CharcToDecimalValue" )
    @JsonProperty( "CharcToDecimalValue" )
    @Nullable
    @ODataField( odataName = "CharcToDecimalValue" )
    private BigDecimal charcToDecimalValue;
    /**
     * Use with available fluent helpers to apply the <b>CharcToDecimalValue</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<BigDecimal> CHARC_TO_DECIMAL_VALUE =
        new DocumentInfoRecordCharcValueField<BigDecimal>("CharcToDecimalValue");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @return Lower Boundary for Currency Field
     */
    @SerializedName( "CharcFromAmount" )
    @JsonProperty( "CharcFromAmount" )
    @Nullable
    @ODataField( odataName = "CharcFromAmount" )
    private BigDecimal charcFromAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromAmount</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<BigDecimal> CHARC_FROM_AMOUNT =
        new DocumentInfoRecordCharcValueField<BigDecimal>("CharcFromAmount");
    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @return Upper Boundary for Currency Field
     */
    @SerializedName( "CharcToAmount" )
    @JsonProperty( "CharcToAmount" )
    @Nullable
    @ODataField( odataName = "CharcToAmount" )
    private BigDecimal charcToAmount;
    /**
     * Use with available fluent helpers to apply the <b>CharcToAmount</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<BigDecimal> CHARC_TO_AMOUNT =
        new DocumentInfoRecordCharcValueField<BigDecimal>("CharcToAmount");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CURRENCY =
        new DocumentInfoRecordCharcValueField<String>("Currency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @return Lower Boundary for Date-Interval
     */
    @SerializedName( "CharcFromDate" )
    @JsonProperty( "CharcFromDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcFromDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromDate</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<LocalDateTime> CHARC_FROM_DATE =
        new DocumentInfoRecordCharcValueField<LocalDateTime>("CharcFromDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @return Upper Boundary for Date-Interval
     */
    @SerializedName( "CharcToDate" )
    @JsonProperty( "CharcToDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CharcToDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime charcToDate;
    /**
     * Use with available fluent helpers to apply the <b>CharcToDate</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<LocalDateTime> CHARC_TO_DATE =
        new DocumentInfoRecordCharcValueField<LocalDateTime>("CharcToDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @return Lower Boundary for Time-Interval
     */
    @SerializedName( "CharcFromTime" )
    @JsonProperty( "CharcFromTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcFromTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcFromTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcFromTime</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<LocalTime> CHARC_FROM_TIME =
        new DocumentInfoRecordCharcValueField<LocalTime>("CharcFromTime");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @return Upper Boundary for Time-Interval
     */
    @SerializedName( "CharcToTime" )
    @JsonProperty( "CharcToTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeAdapter.class )
    @ODataField(
        odataName = "CharcToTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalTimeCalendarConverter.class )
    private LocalTime charcToTime;
    /**
     * Use with available fluent helpers to apply the <b>CharcToTime</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<LocalTime> CHARC_TO_TIME =
        new DocumentInfoRecordCharcValueField<LocalTime>("CharcToTime");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAuthor</b>
     * </p>
     *
     * @return Classification: Author
     */
    @SerializedName( "CharacteristicAuthor" )
    @JsonProperty( "CharacteristicAuthor" )
    @Nullable
    @ODataField( odataName = "CharacteristicAuthor" )
    private String characteristicAuthor;
    /**
     * Use with available fluent helpers to apply the <b>CharacteristicAuthor</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARACTERISTIC_AUTHOR =
        new DocumentInfoRecordCharcValueField<String>("CharacteristicAuthor");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcMaintAuthGrp</b>
     * </p>
     *
     * @return Authorization Group for Characteristics Maintenance
     */
    @SerializedName( "CharcMaintAuthGrp" )
    @JsonProperty( "CharcMaintAuthGrp" )
    @Nullable
    @ODataField( odataName = "CharcMaintAuthGrp" )
    private String charcMaintAuthGrp;
    /**
     * Use with available fluent helpers to apply the <b>CharcMaintAuthGrp</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordCharcValueField<String> CHARC_MAINT_AUTH_GRP =
        new DocumentInfoRecordCharcValueField<String>("CharcMaintAuthGrp");

    @Nonnull
    @Override
    public Class<DocumentInfoRecordCharcValue> getType()
    {
        return DocumentInfoRecordCharcValue.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            Document Type
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            Document number
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            Document Version
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            Document Part
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcValuePositionNumber</b>
     * </p>
     *
     * @param charcValuePositionNumber
     *            Characteristic value counter
     */
    public void setCharcValuePositionNumber( @Nullable final String charcValuePositionNumber )
    {
        rememberChangedField("CharcValuePositionNumber", this.charcValuePositionNumber);
        this.charcValuePositionNumber = charcValuePositionNumber;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharcValueDependency</b>
     * </p>
     *
     * @param charcValueDependency
     *            Code for value dependency
     */
    public void setCharcValueDependency( @Nullable final String charcValueDependency )
    {
        rememberChangedField("CharcValueDependency", this.charcValueDependency);
        this.charcValueDependency = charcValueDependency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 70
     * <p>
     * Original property name from the Odata EDM: <b>CharcValue</b>
     * </p>
     *
     * @param charcValue
     *            Characteristic Value
     */
    public void setCharcValue( @Nullable final String charcValue )
    {
        rememberChangedField("CharcValue", this.charcValue);
        this.charcValue = charcValue;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValue</b>
     * </p>
     *
     * @param charcFromNumericValue
     *            Internal floating point from
     */
    public void setCharcFromNumericValue( @Nullable final Double charcFromNumericValue )
    {
        rememberChangedField("CharcFromNumericValue", this.charcFromNumericValue);
        this.charcFromNumericValue = charcFromNumericValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromNumericValueUnit</b>
     * </p>
     *
     * @param charcFromNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcFromNumericValueUnit( @Nullable final String charcFromNumericValueUnit )
    {
        rememberChangedField("CharcFromNumericValueUnit", this.charcFromNumericValueUnit);
        this.charcFromNumericValueUnit = charcFromNumericValueUnit;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValue</b>
     * </p>
     *
     * @param charcToNumericValue
     *            Internal floating point value to
     */
    public void setCharcToNumericValue( @Nullable final Double charcToNumericValue )
    {
        rememberChangedField("CharcToNumericValue", this.charcToNumericValue);
        this.charcToNumericValue = charcToNumericValue;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToNumericValueUnit</b>
     * </p>
     *
     * @param charcToNumericValueUnit
     *            Unit of Measurement
     */
    public void setCharcToNumericValueUnit( @Nullable final String charcToNumericValueUnit )
    {
        rememberChangedField("CharcToNumericValueUnit", this.charcToNumericValueUnit);
        this.charcToNumericValueUnit = charcToNumericValueUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDecimalValue</b>
     * </p>
     *
     * @param charcFromDecimalValue
     *            Lower Boundary for Numeric Field
     */
    public void setCharcFromDecimalValue( @Nullable final BigDecimal charcFromDecimalValue )
    {
        rememberChangedField("CharcFromDecimalValue", this.charcFromDecimalValue);
        this.charcFromDecimalValue = charcFromDecimalValue;
    }

    /**
     * Constraints: Not nullable, Precision: 31, Scale: 14
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDecimalValue</b>
     * </p>
     *
     * @param charcToDecimalValue
     *            Upper Boundary for Numeric Field
     */
    public void setCharcToDecimalValue( @Nullable final BigDecimal charcToDecimalValue )
    {
        rememberChangedField("CharcToDecimalValue", this.charcToDecimalValue);
        this.charcToDecimalValue = charcToDecimalValue;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromAmount</b>
     * </p>
     *
     * @param charcFromAmount
     *            Lower Boundary for Currency Field
     */
    public void setCharcFromAmount( @Nullable final BigDecimal charcFromAmount )
    {
        rememberChangedField("CharcFromAmount", this.charcFromAmount);
        this.charcFromAmount = charcFromAmount;
    }

    /**
     * Constraints: Not nullable, Precision: 24, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcToAmount</b>
     * </p>
     *
     * @param charcToAmount
     *            Upper Boundary for Currency Field
     */
    public void setCharcToAmount( @Nullable final BigDecimal charcToAmount )
    {
        rememberChangedField("CharcToAmount", this.charcToAmount);
        this.charcToAmount = charcToAmount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromDate</b>
     * </p>
     *
     * @param charcFromDate
     *            Lower Boundary for Date-Interval
     */
    public void setCharcFromDate( @Nullable final LocalDateTime charcFromDate )
    {
        rememberChangedField("CharcFromDate", this.charcFromDate);
        this.charcFromDate = charcFromDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToDate</b>
     * </p>
     *
     * @param charcToDate
     *            Upper Boundary for Date-Interval
     */
    public void setCharcToDate( @Nullable final LocalDateTime charcToDate )
    {
        rememberChangedField("CharcToDate", this.charcToDate);
        this.charcToDate = charcToDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcFromTime</b>
     * </p>
     *
     * @param charcFromTime
     *            Lower Boundary for Time-Interval
     */
    public void setCharcFromTime( @Nullable final LocalTime charcFromTime )
    {
        rememberChangedField("CharcFromTime", this.charcFromTime);
        this.charcFromTime = charcFromTime;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CharcToTime</b>
     * </p>
     *
     * @param charcToTime
     *            Upper Boundary for Time-Interval
     */
    public void setCharcToTime( @Nullable final LocalTime charcToTime )
    {
        rememberChangedField("CharcToTime", this.charcToTime);
        this.charcToTime = charcToTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>CharacteristicAuthor</b>
     * </p>
     *
     * @param characteristicAuthor
     *            Classification: Author
     */
    public void setCharacteristicAuthor( @Nullable final String characteristicAuthor )
    {
        rememberChangedField("CharacteristicAuthor", this.characteristicAuthor);
        this.characteristicAuthor = characteristicAuthor;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>CharcMaintAuthGrp</b>
     * </p>
     *
     * @param charcMaintAuthGrp
     *            Authorization Group for Characteristics Maintenance
     */
    public void setCharcMaintAuthGrp( @Nullable final String charcMaintAuthGrp )
    {
        rememberChangedField("CharcMaintAuthGrp", this.charcMaintAuthGrp);
        this.charcMaintAuthGrp = charcMaintAuthGrp;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DocumentInfoRecordCharcValue";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        result.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        result.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        result.put("ClassType", getClassType());
        result.put("CharcInternalID", getCharcInternalID());
        result.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("ClassType", getClassType());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("CharcValuePositionNumber", getCharcValuePositionNumber());
        values.put("KeyDate", getKeyDate());
        values.put("CharcValueDependency", getCharcValueDependency());
        values.put("CharcValue", getCharcValue());
        values.put("CharcFromNumericValue", getCharcFromNumericValue());
        values.put("CharcFromNumericValueUnit", getCharcFromNumericValueUnit());
        values.put("CharcToNumericValue", getCharcToNumericValue());
        values.put("CharcToNumericValueUnit", getCharcToNumericValueUnit());
        values.put("CharcFromDecimalValue", getCharcFromDecimalValue());
        values.put("CharcToDecimalValue", getCharcToDecimalValue());
        values.put("CharcFromAmount", getCharcFromAmount());
        values.put("CharcToAmount", getCharcToAmount());
        values.put("Currency", getCurrency());
        values.put("CharcFromDate", getCharcFromDate());
        values.put("CharcToDate", getCharcToDate());
        values.put("CharcFromTime", getCharcFromTime());
        values.put("CharcToTime", getCharcToTime());
        values.put("CharacteristicAuthor", getCharacteristicAuthor());
        values.put("CharcMaintAuthGrp", getCharcMaintAuthGrp());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcValuePositionNumber") ) {
                final Object value = values.remove("CharcValuePositionNumber");
                if( (value == null) || (!value.equals(getCharcValuePositionNumber())) ) {
                    setCharcValuePositionNumber(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcValueDependency") ) {
                final Object value = values.remove("CharcValueDependency");
                if( (value == null) || (!value.equals(getCharcValueDependency())) ) {
                    setCharcValueDependency(((String) value));
                }
            }
            if( values.containsKey("CharcValue") ) {
                final Object value = values.remove("CharcValue");
                if( (value == null) || (!value.equals(getCharcValue())) ) {
                    setCharcValue(((String) value));
                }
            }
            if( values.containsKey("CharcFromNumericValue") ) {
                final Object value = values.remove("CharcFromNumericValue");
                if( (value == null) || (!value.equals(getCharcFromNumericValue())) ) {
                    setCharcFromNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcFromNumericValueUnit") ) {
                final Object value = values.remove("CharcFromNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcFromNumericValueUnit())) ) {
                    setCharcFromNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcToNumericValue") ) {
                final Object value = values.remove("CharcToNumericValue");
                if( (value == null) || (!value.equals(getCharcToNumericValue())) ) {
                    setCharcToNumericValue(((Double) value));
                }
            }
            if( values.containsKey("CharcToNumericValueUnit") ) {
                final Object value = values.remove("CharcToNumericValueUnit");
                if( (value == null) || (!value.equals(getCharcToNumericValueUnit())) ) {
                    setCharcToNumericValueUnit(((String) value));
                }
            }
            if( values.containsKey("CharcFromDecimalValue") ) {
                final Object value = values.remove("CharcFromDecimalValue");
                if( (value == null) || (!value.equals(getCharcFromDecimalValue())) ) {
                    setCharcFromDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcToDecimalValue") ) {
                final Object value = values.remove("CharcToDecimalValue");
                if( (value == null) || (!value.equals(getCharcToDecimalValue())) ) {
                    setCharcToDecimalValue(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcFromAmount") ) {
                final Object value = values.remove("CharcFromAmount");
                if( (value == null) || (!value.equals(getCharcFromAmount())) ) {
                    setCharcFromAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("CharcToAmount") ) {
                final Object value = values.remove("CharcToAmount");
                if( (value == null) || (!value.equals(getCharcToAmount())) ) {
                    setCharcToAmount(((BigDecimal) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("CharcFromDate") ) {
                final Object value = values.remove("CharcFromDate");
                if( (value == null) || (!value.equals(getCharcFromDate())) ) {
                    setCharcFromDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcToDate") ) {
                final Object value = values.remove("CharcToDate");
                if( (value == null) || (!value.equals(getCharcToDate())) ) {
                    setCharcToDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("CharcFromTime") ) {
                final Object value = values.remove("CharcFromTime");
                if( (value == null) || (!value.equals(getCharcFromTime())) ) {
                    setCharcFromTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CharcToTime") ) {
                final Object value = values.remove("CharcToTime");
                if( (value == null) || (!value.equals(getCharcToTime())) ) {
                    setCharcToTime(((LocalTime) value));
                }
            }
            if( values.containsKey("CharacteristicAuthor") ) {
                final Object value = values.remove("CharacteristicAuthor");
                if( (value == null) || (!value.equals(getCharacteristicAuthor())) ) {
                    setCharacteristicAuthor(((String) value));
                }
            }
            if( values.containsKey("CharcMaintAuthGrp") ) {
                final Object value = values.remove("CharcMaintAuthGrp");
                if( (value == null) || (!value.equals(getCharcMaintAuthGrp())) ) {
                    setCharcMaintAuthGrp(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DocumentInfoRecordCharcValueField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new DocumentInfoRecordCharcValueField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentInfoRecordCharcValueField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentInfoRecordCharcValueField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService.DEFAULT_SERVICE_PATH);
    }

}
