/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordClassCharcField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable.DocumentInfoRecordClassCharcSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Classification Class Characteristics
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DocumentInfoRecordClassCharcType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentInfoRecordClassCharc extends VdmEntity<DocumentInfoRecordClassCharc>
{

    /**
     * Selector for all available fields of DocumentInfoRecordClassCharc.
     *
     */
    public final static DocumentInfoRecordClassCharcSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new DocumentInfoRecordClassCharcField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new DocumentInfoRecordClassCharcField<String>("DocumentInfoRecordDocNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new DocumentInfoRecordClassCharcField<String>("DocumentInfoRecordDocVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return Document Part
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new DocumentInfoRecordClassCharcField<String>("DocumentInfoRecordDocPart");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @return Internal Class Number
     */
    @Key
    @SerializedName( "ClassInternalID" )
    @JsonProperty( "ClassInternalID" )
    @Nullable
    @ODataField( odataName = "ClassInternalID" )
    private String classInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ClassInternalID</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<String> CLASS_INTERNAL_ID =
        new DocumentInfoRecordClassCharcField<String>("ClassInternalID");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @return Characteristic Internal ID
     */
    @Key
    @SerializedName( "CharcInternalID" )
    @JsonProperty( "CharcInternalID" )
    @Nullable
    @ODataField( odataName = "CharcInternalID" )
    private String charcInternalID;
    /**
     * Use with available fluent helpers to apply the <b>CharcInternalID</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<String> CHARC_INTERNAL_ID =
        new DocumentInfoRecordClassCharcField<String>("CharcInternalID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @return The keyDate contained in this entity.
     */
    @SerializedName( "KeyDate" )
    @JsonProperty( "KeyDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "KeyDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime keyDate;
    /**
     * Use with available fluent helpers to apply the <b>KeyDate</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<LocalDateTime> KEY_DATE =
        new DocumentInfoRecordClassCharcField<LocalDateTime>("KeyDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @return Class Type
     */
    @SerializedName( "ClassType" )
    @JsonProperty( "ClassType" )
    @Nullable
    @ODataField( odataName = "ClassType" )
    private String classType;
    /**
     * Use with available fluent helpers to apply the <b>ClassType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordClassCharcField<String> CLASS_TYPE =
        new DocumentInfoRecordClassCharcField<String>("ClassType");

    @Nonnull
    @Override
    public Class<DocumentInfoRecordClassCharc> getType()
    {
        return DocumentInfoRecordClassCharc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            Document Type
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            Document number
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            Document Version
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            Document Part
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ClassInternalID</b>
     * </p>
     *
     * @param classInternalID
     *            Internal Class Number
     */
    public void setClassInternalID( @Nullable final String classInternalID )
    {
        rememberChangedField("ClassInternalID", this.classInternalID);
        this.classInternalID = classInternalID;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CharcInternalID</b>
     * </p>
     *
     * @param charcInternalID
     *            Characteristic Internal ID
     */
    public void setCharcInternalID( @Nullable final String charcInternalID )
    {
        rememberChangedField("CharcInternalID", this.charcInternalID);
        this.charcInternalID = charcInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>KeyDate</b>
     * </p>
     *
     * @param keyDate
     *            The keyDate to set.
     */
    public void setKeyDate( @Nullable final LocalDateTime keyDate )
    {
        rememberChangedField("KeyDate", this.keyDate);
        this.keyDate = keyDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ClassType</b>
     * </p>
     *
     * @param classType
     *            Class Type
     */
    public void setClassType( @Nullable final String classType )
    {
        rememberChangedField("ClassType", this.classType);
        this.classType = classType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DocumentInfoRecordClassCharc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        result.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        result.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        result.put("ClassInternalID", getClassInternalID());
        result.put("CharcInternalID", getCharcInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("ClassInternalID", getClassInternalID());
        values.put("CharcInternalID", getCharcInternalID());
        values.put("KeyDate", getKeyDate());
        values.put("ClassType", getClassType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("ClassInternalID") ) {
                final Object value = values.remove("ClassInternalID");
                if( (value == null) || (!value.equals(getClassInternalID())) ) {
                    setClassInternalID(((String) value));
                }
            }
            if( values.containsKey("CharcInternalID") ) {
                final Object value = values.remove("CharcInternalID");
                if( (value == null) || (!value.equals(getCharcInternalID())) ) {
                    setCharcInternalID(((String) value));
                }
            }
            if( values.containsKey("KeyDate") ) {
                final Object value = values.remove("KeyDate");
                if( (value == null) || (!value.equals(getKeyDate())) ) {
                    setKeyDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ClassType") ) {
                final Object value = values.remove("ClassType");
                if( (value == null) || (!value.equals(getClassType())) ) {
                    setClassType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DocumentInfoRecordClassCharcField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new DocumentInfoRecordClassCharcField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentInfoRecordClassCharcField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentInfoRecordClassCharcField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService.DEFAULT_SERVICE_PATH);
    }

}
