/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement;

import java.time.ZonedDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordDescField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.link.DocumentInfoRecordDescOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable.DocumentInfoRecordDescSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Document Info Record Description
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DocumentInfoRecordDescType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentInfoRecordDesc extends VdmEntity<DocumentInfoRecordDesc>
{

    /**
     * Selector for all available fields of DocumentInfoRecordDesc.
     *
     */
    public final static DocumentInfoRecordDescSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Delete_mc" )
    @JsonProperty( "Delete_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Delete_mc" )
    private Boolean delete_mc;
    /**
     * Use with available fluent helpers to apply the <b>Delete_mc</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<Boolean> DELETE_MC =
        new DocumentInfoRecordDescField<Boolean>("Delete_mc");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @return Dyn. Method Control
     */
    @SerializedName( "Update_mc" )
    @JsonProperty( "Update_mc" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "Update_mc" )
    private Boolean update_mc;
    /**
     * Use with available fluent helpers to apply the <b>Update_mc</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<Boolean> UPDATE_MC =
        new DocumentInfoRecordDescField<Boolean>("Update_mc");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new DocumentInfoRecordDescField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @return Document number
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocNumber" )
    @JsonProperty( "DocumentInfoRecordDocNumber" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocNumber" )
    private String documentInfoRecordDocNumber;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocNumber</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> DOCUMENT_INFO_RECORD_DOC_NUMBER =
        new DocumentInfoRecordDescField<String>("DocumentInfoRecordDocNumber");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @return Document Version
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocVersion" )
    @JsonProperty( "DocumentInfoRecordDocVersion" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocVersion" )
    private String documentInfoRecordDocVersion;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocVersion</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> DOCUMENT_INFO_RECORD_DOC_VERSION =
        new DocumentInfoRecordDescField<String>("DocumentInfoRecordDocVersion");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @return Document Part
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocPart" )
    @JsonProperty( "DocumentInfoRecordDocPart" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocPart" )
    private String documentInfoRecordDocPart;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocPart</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> DOCUMENT_INFO_RECORD_DOC_PART =
        new DocumentInfoRecordDescField<String>("DocumentInfoRecordDocPart");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> LANGUAGE =
        new DocumentInfoRecordDescField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDescription</b>
     * </p>
     *
     * @return Document Description
     */
    @SerializedName( "DocumentDescription" )
    @JsonProperty( "DocumentDescription" )
    @Nullable
    @ODataField( odataName = "DocumentDescription" )
    private String documentDescription;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDescription</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> DOCUMENT_DESCRIPTION =
        new DocumentInfoRecordDescField<String>("DocumentDescription");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LongTextExists</b>
     * </p>
     *
     * @return Long Text Exists
     */
    @SerializedName( "LongTextExists" )
    @JsonProperty( "LongTextExists" )
    @Nullable
    @ODataField( odataName = "LongTextExists" )
    private String longTextExists;
    /**
     * Use with available fluent helpers to apply the <b>LongTextExists</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> LONG_TEXT_EXISTS =
        new DocumentInfoRecordDescField<String>("LongTextExists");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocInfoRecdShortText</b>
     * </p>
     *
     * @return DMS: Short Texts in Capital Letters
     */
    @SerializedName( "DocInfoRecdShortText" )
    @JsonProperty( "DocInfoRecdShortText" )
    @Nullable
    @ODataField( odataName = "DocInfoRecdShortText" )
    private String docInfoRecdShortText;
    /**
     * Use with available fluent helpers to apply the <b>DocInfoRecdShortText</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<String> DOC_INFO_RECD_SHORT_TEXT =
        new DocumentInfoRecordDescField<String>("DocInfoRecdShortText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @return Time last change was made
     */
    @SerializedName( "ChangedDateTime" )
    @JsonProperty( "ChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime changedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ChangedDateTime</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDescField<ZonedDateTime> CHANGED_DATE_TIME =
        new DocumentInfoRecordDescField<ZonedDateTime>("ChangedDateTime");
    /**
     * Navigation property <b>to_DocInfoRecord</b> for <b>DocumentInfoRecordDesc</b> to single
     * <b>DocumentInfoRecord</b>.
     *
     */
    @SerializedName( "to_DocInfoRecord" )
    @JsonProperty( "to_DocInfoRecord" )
    @ODataField( odataName = "to_DocInfoRecord" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private DocumentInfoRecord toDocInfoRecord;
    /**
     * Use with available fluent helpers to apply the <b>to_DocInfoRecord</b> navigation property to query operations.
     *
     */
    public final static DocumentInfoRecordDescOneToOneLink<DocumentInfoRecord> TO_DOC_INFO_RECORD =
        new DocumentInfoRecordDescOneToOneLink<DocumentInfoRecord>("to_DocInfoRecord");

    @Nonnull
    @Override
    public Class<DocumentInfoRecordDesc> getType()
    {
        return DocumentInfoRecordDesc.class;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Delete_mc</b>
     * </p>
     *
     * @param delete_mc
     *            Dyn. Method Control
     */
    public void setDelete_mc( @Nullable final Boolean delete_mc )
    {
        rememberChangedField("Delete_mc", this.delete_mc);
        this.delete_mc = delete_mc;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>Update_mc</b>
     * </p>
     *
     * @param update_mc
     *            Dyn. Method Control
     */
    public void setUpdate_mc( @Nullable final Boolean update_mc )
    {
        rememberChangedField("Update_mc", this.update_mc);
        this.update_mc = update_mc;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            Document Type
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocNumber</b>
     * </p>
     *
     * @param documentInfoRecordDocNumber
     *            Document number
     */
    public void setDocumentInfoRecordDocNumber( @Nullable final String documentInfoRecordDocNumber )
    {
        rememberChangedField("DocumentInfoRecordDocNumber", this.documentInfoRecordDocNumber);
        this.documentInfoRecordDocNumber = documentInfoRecordDocNumber;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocVersion</b>
     * </p>
     *
     * @param documentInfoRecordDocVersion
     *            Document Version
     */
    public void setDocumentInfoRecordDocVersion( @Nullable final String documentInfoRecordDocVersion )
    {
        rememberChangedField("DocumentInfoRecordDocVersion", this.documentInfoRecordDocVersion);
        this.documentInfoRecordDocVersion = documentInfoRecordDocVersion;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocPart</b>
     * </p>
     *
     * @param documentInfoRecordDocPart
     *            Document Part
     */
    public void setDocumentInfoRecordDocPart( @Nullable final String documentInfoRecordDocPart )
    {
        rememberChangedField("DocumentInfoRecordDocPart", this.documentInfoRecordDocPart);
        this.documentInfoRecordDocPart = documentInfoRecordDocPart;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDescription</b>
     * </p>
     *
     * @param documentDescription
     *            Document Description
     */
    public void setDocumentDescription( @Nullable final String documentDescription )
    {
        rememberChangedField("DocumentDescription", this.documentDescription);
        this.documentDescription = documentDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>LongTextExists</b>
     * </p>
     *
     * @param longTextExists
     *            Long Text Exists
     */
    public void setLongTextExists( @Nullable final String longTextExists )
    {
        rememberChangedField("LongTextExists", this.longTextExists);
        this.longTextExists = longTextExists;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>DocInfoRecdShortText</b>
     * </p>
     *
     * @param docInfoRecdShortText
     *            DMS: Short Texts in Capital Letters
     */
    public void setDocInfoRecdShortText( @Nullable final String docInfoRecdShortText )
    {
        rememberChangedField("DocInfoRecdShortText", this.docInfoRecdShortText);
        this.docInfoRecdShortText = docInfoRecdShortText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ChangedDateTime</b>
     * </p>
     *
     * @param changedDateTime
     *            Time last change was made
     */
    public void setChangedDateTime( @Nullable final ZonedDateTime changedDateTime )
    {
        rememberChangedField("ChangedDateTime", this.changedDateTime);
        this.changedDateTime = changedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DocumentInfoRecordDesc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        result.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        result.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Delete_mc", getDelete_mc());
        values.put("Update_mc", getUpdate_mc());
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("DocumentInfoRecordDocNumber", getDocumentInfoRecordDocNumber());
        values.put("DocumentInfoRecordDocVersion", getDocumentInfoRecordDocVersion());
        values.put("DocumentInfoRecordDocPart", getDocumentInfoRecordDocPart());
        values.put("Language", getLanguage());
        values.put("DocumentDescription", getDocumentDescription());
        values.put("LongTextExists", getLongTextExists());
        values.put("DocInfoRecdShortText", getDocInfoRecdShortText());
        values.put("ChangedDateTime", getChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Delete_mc") ) {
                final Object value = values.remove("Delete_mc");
                if( (value == null) || (!value.equals(getDelete_mc())) ) {
                    setDelete_mc(((Boolean) value));
                }
            }
            if( values.containsKey("Update_mc") ) {
                final Object value = values.remove("Update_mc");
                if( (value == null) || (!value.equals(getUpdate_mc())) ) {
                    setUpdate_mc(((Boolean) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocNumber") ) {
                final Object value = values.remove("DocumentInfoRecordDocNumber");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocNumber())) ) {
                    setDocumentInfoRecordDocNumber(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocVersion") ) {
                final Object value = values.remove("DocumentInfoRecordDocVersion");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocVersion())) ) {
                    setDocumentInfoRecordDocVersion(((String) value));
                }
            }
            if( values.containsKey("DocumentInfoRecordDocPart") ) {
                final Object value = values.remove("DocumentInfoRecordDocPart");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocPart())) ) {
                    setDocumentInfoRecordDocPart(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("DocumentDescription") ) {
                final Object value = values.remove("DocumentDescription");
                if( (value == null) || (!value.equals(getDocumentDescription())) ) {
                    setDocumentDescription(((String) value));
                }
            }
            if( values.containsKey("LongTextExists") ) {
                final Object value = values.remove("LongTextExists");
                if( (value == null) || (!value.equals(getLongTextExists())) ) {
                    setLongTextExists(((String) value));
                }
            }
            if( values.containsKey("DocInfoRecdShortText") ) {
                final Object value = values.remove("DocInfoRecdShortText");
                if( (value == null) || (!value.equals(getDocInfoRecdShortText())) ) {
                    setDocInfoRecdShortText(((String) value));
                }
            }
            if( values.containsKey("ChangedDateTime") ) {
                final Object value = values.remove("ChangedDateTime");
                if( (value == null) || (!value.equals(getChangedDateTime())) ) {
                    setChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_DocInfoRecord") ) {
                final Object value = (values).remove("to_DocInfoRecord");
                if( value instanceof Map ) {
                    if( toDocInfoRecord == null ) {
                        toDocInfoRecord = new DocumentInfoRecord();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toDocInfoRecord.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> DocumentInfoRecordDescField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new DocumentInfoRecordDescField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentInfoRecordDescField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentInfoRecordDescField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toDocInfoRecord != null ) {
            (values).put("to_DocInfoRecord", toDocInfoRecord);
        }
        return values;
    }

    /**
     * Fetches the <b>DocumentInfoRecord</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_DocInfoRecord</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>DocumentInfoRecord</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DocumentInfoRecord fetchDocInfoRecord()
    {
        return fetchFieldAsSingle("to_DocInfoRecord", DocumentInfoRecord.class);
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DocInfoRecord</b>.
     * <p>
     * If the navigation property <b>to_DocInfoRecord</b> of a queried <b>DocumentInfoRecordDesc</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>DocumentInfoRecord</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public DocumentInfoRecord getDocInfoRecordOrFetch()
    {
        if( toDocInfoRecord == null ) {
            toDocInfoRecord = fetchDocInfoRecord();
        }
        return toDocInfoRecord;
    }

    /**
     * Retrieval of associated <b>DocumentInfoRecord</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_DocInfoRecord</b>.
     * <p>
     * If the navigation property for an entity <b>DocumentInfoRecordDesc</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_DocInfoRecord</b> is already loaded, the result will
     *         contain the <b>DocumentInfoRecord</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<DocumentInfoRecord> getDocInfoRecordIfPresent()
    {
        return Option.of(toDocInfoRecord);
    }

    /**
     * Overwrites the associated <b>DocumentInfoRecord</b> entity for the loaded navigation property
     * <b>to_DocInfoRecord</b>.
     *
     * @param value
     *            New <b>DocumentInfoRecord</b> entity.
     */
    public void setDocInfoRecord( final DocumentInfoRecord value )
    {
        toDocInfoRecord = value;
    }

    /**
     * Helper class to allow for fluent creation of DocumentInfoRecordDesc instances.
     *
     */
    public final static class DocumentInfoRecordDescBuilder
    {

        private DocumentInfoRecord toDocInfoRecord;

        private DocumentInfoRecordDesc.DocumentInfoRecordDescBuilder toDocInfoRecord( final DocumentInfoRecord value )
        {
            toDocInfoRecord = value;
            return this;
        }

        /**
         * Navigation property <b>to_DocInfoRecord</b> for <b>DocumentInfoRecordDesc</b> to single
         * <b>DocumentInfoRecord</b>.
         *
         * @param value
         *            The DocumentInfoRecord to build this DocumentInfoRecordDesc with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public DocumentInfoRecordDesc.DocumentInfoRecordDescBuilder docInfoRecord( final DocumentInfoRecord value )
        {
            return toDocInfoRecord(value);
        }

    }

}
