/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordDocStsVHField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable.DocumentInfoRecordDocStsVHSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Document Status Value Help
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_DocumentInfoRecordDocStsVHType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class DocumentInfoRecordDocStsVH extends VdmEntity<DocumentInfoRecordDocStsVH>
{

    /**
     * Selector for all available fields of DocumentInfoRecordDocStsVH.
     *
     */
    public final static DocumentInfoRecordDocStsVHSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @return Document Type
     */
    @Key
    @SerializedName( "DocumentInfoRecordDocType" )
    @JsonProperty( "DocumentInfoRecordDocType" )
    @Nullable
    @ODataField( odataName = "DocumentInfoRecordDocType" )
    private String documentInfoRecordDocType;
    /**
     * Use with available fluent helpers to apply the <b>DocumentInfoRecordDocType</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDocStsVHField<String> DOCUMENT_INFO_RECORD_DOC_TYPE =
        new DocumentInfoRecordDocStsVHField<String>("DocumentInfoRecordDocType");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDocStsVHField<String> LANGUAGE =
        new DocumentInfoRecordDocStsVHField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentStatus</b>
     * </p>
     *
     * @return Status of a document (language-dependent)
     */
    @Key
    @SerializedName( "ExternalDocumentStatus" )
    @JsonProperty( "ExternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "ExternalDocumentStatus" )
    private String externalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>ExternalDocumentStatus</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDocStsVHField<String> EXTERNAL_DOCUMENT_STATUS =
        new DocumentInfoRecordDocStsVHField<String>("ExternalDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @return Document Status
     */
    @SerializedName( "InternalDocumentStatus" )
    @JsonProperty( "InternalDocumentStatus" )
    @Nullable
    @ODataField( odataName = "InternalDocumentStatus" )
    private String internalDocumentStatus;
    /**
     * Use with available fluent helpers to apply the <b>InternalDocumentStatus</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDocStsVHField<String> INTERNAL_DOCUMENT_STATUS =
        new DocumentInfoRecordDocStsVHField<String>("InternalDocumentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentStatusName</b>
     * </p>
     *
     * @return Description of document status
     */
    @SerializedName( "DocumentStatusName" )
    @JsonProperty( "DocumentStatusName" )
    @Nullable
    @ODataField( odataName = "DocumentStatusName" )
    private String documentStatusName;
    /**
     * Use with available fluent helpers to apply the <b>DocumentStatusName</b> field to query operations.
     *
     */
    public final static DocumentInfoRecordDocStsVHField<String> DOCUMENT_STATUS_NAME =
        new DocumentInfoRecordDocStsVHField<String>("DocumentStatusName");

    @Nonnull
    @Override
    public Class<DocumentInfoRecordDocStsVH> getType()
    {
        return DocumentInfoRecordDocStsVH.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>DocumentInfoRecordDocType</b>
     * </p>
     *
     * @param documentInfoRecordDocType
     *            Document Type
     */
    public void setDocumentInfoRecordDocType( @Nullable final String documentInfoRecordDocType )
    {
        rememberChangedField("DocumentInfoRecordDocType", this.documentInfoRecordDocType);
        this.documentInfoRecordDocType = documentInfoRecordDocType;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ExternalDocumentStatus</b>
     * </p>
     *
     * @param externalDocumentStatus
     *            Status of a document (language-dependent)
     */
    public void setExternalDocumentStatus( @Nullable final String externalDocumentStatus )
    {
        rememberChangedField("ExternalDocumentStatus", this.externalDocumentStatus);
        this.externalDocumentStatus = externalDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>InternalDocumentStatus</b>
     * </p>
     *
     * @param internalDocumentStatus
     *            Document Status
     */
    public void setInternalDocumentStatus( @Nullable final String internalDocumentStatus )
    {
        rememberChangedField("InternalDocumentStatus", this.internalDocumentStatus);
        this.internalDocumentStatus = internalDocumentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>DocumentStatusName</b>
     * </p>
     *
     * @param documentStatusName
     *            Description of document status
     */
    public void setDocumentStatusName( @Nullable final String documentStatusName )
    {
        rememberChangedField("DocumentStatusName", this.documentStatusName);
        this.documentStatusName = documentStatusName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_DocumentInfoRecordDocStsVH";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        result.put("Language", getLanguage());
        result.put("ExternalDocumentStatus", getExternalDocumentStatus());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("DocumentInfoRecordDocType", getDocumentInfoRecordDocType());
        values.put("Language", getLanguage());
        values.put("ExternalDocumentStatus", getExternalDocumentStatus());
        values.put("InternalDocumentStatus", getInternalDocumentStatus());
        values.put("DocumentStatusName", getDocumentStatusName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("DocumentInfoRecordDocType") ) {
                final Object value = values.remove("DocumentInfoRecordDocType");
                if( (value == null) || (!value.equals(getDocumentInfoRecordDocType())) ) {
                    setDocumentInfoRecordDocType(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ExternalDocumentStatus") ) {
                final Object value = values.remove("ExternalDocumentStatus");
                if( (value == null) || (!value.equals(getExternalDocumentStatus())) ) {
                    setExternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("InternalDocumentStatus") ) {
                final Object value = values.remove("InternalDocumentStatus");
                if( (value == null) || (!value.equals(getInternalDocumentStatus())) ) {
                    setInternalDocumentStatus(((String) value));
                }
            }
            if( values.containsKey("DocumentStatusName") ) {
                final Object value = values.remove("DocumentStatusName");
                if( (value == null) || (!value.equals(getDocumentStatusName())) ) {
                    setDocumentStatusName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> DocumentInfoRecordDocStsVHField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new DocumentInfoRecordDocStsVHField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> DocumentInfoRecordDocStsVHField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new DocumentInfoRecordDocStsVHField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService.DEFAULT_SERVICE_PATH);
    }

}
