/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link DocumentManagementServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService DocumentManagementService},
 * allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultDocumentManagementServiceBatch
    extends
    BatchFluentHelperBasic<DocumentManagementServiceBatch, DocumentManagementServiceBatchChangeSet>
    implements
    DocumentManagementServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultDocumentManagementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDocumentManagementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService service )
    {
        this(service, com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultDocumentManagementServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultDocumentManagementServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultDocumentManagementServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultDocumentManagementServiceBatchChangeSet(this, service);
    }

}
