/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc;

/**
 * Implementation of the {@link DocumentManagementServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService DocumentManagementService}.
 *
 */
public class DefaultDocumentManagementServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<DocumentManagementServiceBatch, DocumentManagementServiceBatchChangeSet>
    implements
    DocumentManagementServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService service;

    @SuppressWarnings( "deprecation" )
    DefaultDocumentManagementServiceBatchChangeSet(
        @Nonnull final DefaultDocumentManagementServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultDocumentManagementServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet createDocInfoRecdObjLinkProduct(
        @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct )
    {
        return addRequestCreate(service::createDocInfoRecdObjLinkProduct, docInfoRecdObjLinkProduct);
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet deleteDocInfoRecdObjLinkProduct(
        @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct )
    {
        return addRequestDelete(service::deleteDocInfoRecdObjLinkProduct, docInfoRecdObjLinkProduct);
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet createDocumentInfoRecord(
        @Nonnull final DocumentInfoRecord documentInfoRecord )
    {
        return addRequestCreate(service::createDocumentInfoRecord, documentInfoRecord);
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet updateDocumentInfoRecord(
        @Nonnull final DocumentInfoRecord documentInfoRecord )
    {
        return addRequestUpdate(service::updateDocumentInfoRecord, documentInfoRecord);
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet createDocumentInfoRecordDesc(
        @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc )
    {
        return addRequestCreate(service::createDocumentInfoRecordDesc, documentInfoRecordDesc);
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet updateDocumentInfoRecordDesc(
        @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc )
    {
        return addRequestUpdate(service::updateDocumentInfoRecordDesc, documentInfoRecordDesc);
    }

    @Nonnull
    @Override
    public DocumentManagementServiceBatchChangeSet deleteDocumentInfoRecordDesc(
        @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc )
    {
        return addRequestDelete(service::deleteDocumentInfoRecordDesc, documentInfoRecordDesc);
    }

}
