/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.DocumentManagementService
 * DocumentManagementService}.
 *
 */
public interface DocumentManagementServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<DocumentManagementServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<DocumentManagementServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     * DocInfoRecdObjLinkProduct} entity and save it to the S/4HANA system.
     *
     * @param docInfoRecdObjLinkProduct
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *            DocInfoRecdObjLinkProduct} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DocumentManagementServiceBatchChangeSet
        createDocInfoRecdObjLinkProduct( @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     * DocInfoRecdObjLinkProduct} entity in the S/4HANA system.
     *
     * @param docInfoRecdObjLinkProduct
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkProduct
     *            DocInfoRecdObjLinkProduct} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DocumentManagementServiceBatchChangeSet
        deleteDocInfoRecdObjLinkProduct( @Nonnull final DocInfoRecdObjLinkProduct docInfoRecdObjLinkProduct );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     * DocumentInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *            DocumentInfoRecord} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DocumentManagementServiceBatchChangeSet
        createDocumentInfoRecord( @Nonnull final DocumentInfoRecord documentInfoRecord );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     * DocumentInfoRecord} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecord
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecord
     *            DocumentInfoRecord} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DocumentManagementServiceBatchChangeSet
        updateDocumentInfoRecord( @Nonnull final DocumentInfoRecord documentInfoRecord );

    /**
     * Create a new {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecordDesc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *            DocumentInfoRecordDesc} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DocumentManagementServiceBatchChangeSet
        createDocumentInfoRecordDesc( @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entity and save it to the S/4HANA system.
     *
     * @param documentInfoRecordDesc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *            DocumentInfoRecordDesc} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DocumentManagementServiceBatchChangeSet
        updateDocumentInfoRecordDesc( @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     * DocumentInfoRecordDesc} entity in the S/4HANA system.
     *
     * @param documentInfoRecordDesc
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDesc
     *            DocumentInfoRecordDesc} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    DocumentManagementServiceBatchChangeSet
        deleteDocumentInfoRecordDesc( @Nonnull final DocumentInfoRecordDesc documentInfoRecordDesc );

}
