/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd
 * DocInfoRecdObjLinkChgRecd}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocInfoRecdObjLinkChgRecdField
 * DocInfoRecdObjLinkChgRecdField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.link.DocInfoRecdObjLinkChgRecdLink
 * DocInfoRecdObjLinkChgRecdLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#DOCUMENT_INFO_RECORD_DOC_NUMBER
 * DOCUMENT_INFO_RECORD_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#DOCUMENT_INFO_RECORD_DOC_VERSION
 * DOCUMENT_INFO_RECORD_DOC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#DOCUMENT_INFO_RECORD_DOC_PART
 * DOCUMENT_INFO_RECORD_DOC_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#LINKED_SAP_OBJECT
 * LINKED_SAP_OBJECT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#LINKED_SAP_OBJECT_KEY
 * LINKED_SAP_OBJECT_KEY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#DOC_OBJECT_LINK_COUNTER
 * DOC_OBJECT_LINK_COUNTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocInfoRecdObjLinkChgRecd#TO_DOC_INFO_RECORD
 * TO_DOC_INFO_RECORD}</li>
 * </ul>
 *
 */
public interface DocInfoRecdObjLinkChgRecdSelectable extends EntitySelectable<DocInfoRecdObjLinkChgRecd>
{

}
