/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue
 * DocumentInfoRecordCharcValue}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordCharcValueField
 * DocumentInfoRecordCharcValueField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.link.DocumentInfoRecordCharcValueLink
 * DocumentInfoRecordCharcValueLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#DOCUMENT_INFO_RECORD_DOC_NUMBER
 * DOCUMENT_INFO_RECORD_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#DOCUMENT_INFO_RECORD_DOC_VERSION
 * DOCUMENT_INFO_RECORD_DOC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#DOCUMENT_INFO_RECORD_DOC_PART
 * DOCUMENT_INFO_RECORD_DOC_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_INTERNAL_ID
 * CHARC_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_VALUE_POSITION_NUMBER
 * CHARC_VALUE_POSITION_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_VALUE_DEPENDENCY
 * CHARC_VALUE_DEPENDENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_VALUE
 * CHARC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_FROM_NUMERIC_VALUE
 * CHARC_FROM_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_FROM_NUMERIC_VALUE_UNIT
 * CHARC_FROM_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_TO_NUMERIC_VALUE
 * CHARC_TO_NUMERIC_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_TO_NUMERIC_VALUE_UNIT
 * CHARC_TO_NUMERIC_VALUE_UNIT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_FROM_DECIMAL_VALUE
 * CHARC_FROM_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_TO_DECIMAL_VALUE
 * CHARC_TO_DECIMAL_VALUE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_FROM_AMOUNT
 * CHARC_FROM_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_TO_AMOUNT
 * CHARC_TO_AMOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CURRENCY
 * CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_FROM_DATE
 * CHARC_FROM_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_TO_DATE
 * CHARC_TO_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_FROM_TIME
 * CHARC_FROM_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_TO_TIME
 * CHARC_TO_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARACTERISTIC_AUTHOR
 * CHARACTERISTIC_AUTHOR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordCharcValue#CHARC_MAINT_AUTH_GRP
 * CHARC_MAINT_AUTH_GRP}</li>
 * </ul>
 *
 */
public interface DocumentInfoRecordCharcValueSelectable extends EntitySelectable<DocumentInfoRecordCharcValue>
{

}
