/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass
 * DocumentInfoRecordClass}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordClassField
 * DocumentInfoRecordClassField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.link.DocumentInfoRecordClassLink
 * DocumentInfoRecordClassLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#DOCUMENT_INFO_RECORD_DOC_NUMBER
 * DOCUMENT_INFO_RECORD_DOC_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#DOCUMENT_INFO_RECORD_DOC_VERSION
 * DOCUMENT_INFO_RECORD_DOC_VERSION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#DOCUMENT_INFO_RECORD_DOC_PART
 * DOCUMENT_INFO_RECORD_DOC_PART}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#CLASS_INTERNAL_ID
 * CLASS_INTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#KEY_DATE
 * KEY_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#CLASS_TYPE
 * CLASS_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordClass#TO_CHARACTERISTICS
 * TO_CHARACTERISTICS}</li>
 * </ul>
 *
 */
public interface DocumentInfoRecordClassSelectable extends EntitySelectable<DocumentInfoRecordClass>
{

}
