/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH
 * DocumentInfoRecordDocStsVH}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.field.DocumentInfoRecordDocStsVHField
 * DocumentInfoRecordDocStsVHField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.link.DocumentInfoRecordDocStsVHLink
 * DocumentInfoRecordDocStsVHLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH#DOCUMENT_INFO_RECORD_DOC_TYPE
 * DOCUMENT_INFO_RECORD_DOC_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH#LANGUAGE
 * LANGUAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH#EXTERNAL_DOCUMENT_STATUS
 * EXTERNAL_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH#INTERNAL_DOCUMENT_STATUS
 * INTERNAL_DOCUMENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.documentmanagement.DocumentInfoRecordDocStsVH#DOCUMENT_STATUS_NAME
 * DOCUMENT_STATUS_NAME}</li>
 * </ul>
 *
 */
public interface DocumentInfoRecordDocStsVHSelectable extends EntitySelectable<DocumentInfoRecordDocStsVH>
{

}
