/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.field.EarmarkedFundsDocumentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.link.EarmarkedFundsDocumentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.selectable.EarmarkedFundsDocumentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Remote Interface Earmarked Funds
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EarmarkedFundsDocument_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EarmarkedFundsDocument extends VdmEntity<EarmarkedFundsDocument>
{

    /**
     * Selector for all available fields of EarmarkedFundsDocument.
     *
     */
    public final static EarmarkedFundsDocumentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document number for earmarked funds
     */
    @Key
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EARMARKED_FUNDS_DOCUMENT =
        new EarmarkedFundsDocumentField<String>("EarmarkedFundsDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsExtDocumentNumber</b>
     * </p>
     *
     * @return External Document Number for Earmarked Funds
     */
    @SerializedName( "EmrkdFndsExtDocumentNumber" )
    @JsonProperty( "EmrkdFndsExtDocumentNumber" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsExtDocumentNumber" )
    private String emrkdFndsExtDocumentNumber;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsExtDocumentNumber</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EMRKD_FNDS_EXT_DOCUMENT_NUMBER =
        new EarmarkedFundsDocumentField<String>("EmrkdFndsExtDocumentNumber");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsIntegrationScenario</b>
     * </p>
     *
     * @return Scenario
     */
    @SerializedName( "EmrkdFndsIntegrationScenario" )
    @JsonProperty( "EmrkdFndsIntegrationScenario" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsIntegrationScenario" )
    private String emrkdFndsIntegrationScenario;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsIntegrationScenario</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EMRKD_FNDS_INTEGRATION_SCENARIO =
        new EarmarkedFundsDocumentField<String>("EmrkdFndsIntegrationScenario");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsIntegScenarioVariant</b>
     * </p>
     *
     * @return Scenario Variant
     */
    @SerializedName( "EmrkdFndsIntegScenarioVariant" )
    @JsonProperty( "EmrkdFndsIntegScenarioVariant" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsIntegScenarioVariant" )
    private String emrkdFndsIntegScenarioVariant;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsIntegScenarioVariant</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EMRKD_FNDS_INTEG_SCENARIO_VARIANT =
        new EarmarkedFundsDocumentField<String>("EmrkdFndsIntegScenarioVariant");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentCategory</b>
     * </p>
     *
     * @return Document Category of an Earmarked Funds Document
     */
    @SerializedName( "EarmarkedFundsDocumentCategory" )
    @JsonProperty( "EarmarkedFundsDocumentCategory" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocumentCategory" )
    private String earmarkedFundsDocumentCategory;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocumentCategory</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EARMARKED_FUNDS_DOCUMENT_CATEGORY =
        new EarmarkedFundsDocumentField<String>("EarmarkedFundsDocumentCategory");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentType</b>
     * </p>
     *
     * @return Earmarked fund document type
     */
    @SerializedName( "EarmarkedFundsDocumentType" )
    @JsonProperty( "EarmarkedFundsDocumentType" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocumentType" )
    private String earmarkedFundsDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocumentType</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EARMARKED_FUNDS_DOCUMENT_TYPE =
        new EarmarkedFundsDocumentField<String>("EarmarkedFundsDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> COMPANY_CODE =
        new EarmarkedFundsDocumentField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> TRANSACTION_CURRENCY =
        new EarmarkedFundsDocumentField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Local currency key
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> COMPANY_CODE_CURRENCY =
        new EarmarkedFundsDocumentField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocReference</b>
     * </p>
     *
     * @return Reference Document Number
     */
    @SerializedName( "EarmarkedFundsDocReference" )
    @JsonProperty( "EarmarkedFundsDocReference" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocReference" )
    private String earmarkedFundsDocReference;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocReference</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EARMARKED_FUNDS_DOC_REFERENCE =
        new EarmarkedFundsDocumentField<String>("EarmarkedFundsDocReference");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsHeaderText</b>
     * </p>
     *
     * @return Doc.header text
     */
    @SerializedName( "EarmarkedFundsHeaderText" )
    @JsonProperty( "EarmarkedFundsHeaderText" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsHeaderText" )
    private String earmarkedFundsHeaderText;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsHeaderText</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EARMARKED_FUNDS_HEADER_TEXT =
        new EarmarkedFundsDocumentField<String>("EarmarkedFundsHeaderText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<LocalDateTime> POSTING_DATE =
        new EarmarkedFundsDocumentField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @return Document Date in Document
     */
    @SerializedName( "DocumentDate" )
    @JsonProperty( "DocumentDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DocumentDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime documentDate;
    /**
     * Use with available fluent helpers to apply the <b>DocumentDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<LocalDateTime> DOCUMENT_DATE =
        new EarmarkedFundsDocumentField<LocalDateTime>("DocumentDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @return Translation Date
     */
    @SerializedName( "ExchangeRateDate" )
    @JsonProperty( "ExchangeRateDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ExchangeRateDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime exchangeRateDate;
    /**
     * Use with available fluent helpers to apply the <b>ExchangeRateDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<LocalDateTime> EXCHANGE_RATE_DATE =
        new EarmarkedFundsDocumentField<LocalDateTime>("ExchangeRateDate");
    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsoluteExchangeRate</b>
     * </p>
     *
     * @return Absolute Exchange Rate
     */
    @SerializedName( "AbsoluteExchangeRate" )
    @JsonProperty( "AbsoluteExchangeRate" )
    @Nullable
    @ODataField( odataName = "AbsoluteExchangeRate" )
    private BigDecimal absoluteExchangeRate;
    /**
     * Use with available fluent helpers to apply the <b>AbsoluteExchangeRate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<BigDecimal> ABSOLUTE_EXCHANGE_RATE =
        new EarmarkedFundsDocumentField<BigDecimal>("AbsoluteExchangeRate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchRateIsIndirectQuotation</b>
     * </p>
     *
     * @return Exchange Rate Is Indirect Quotation
     */
    @SerializedName( "ExchRateIsIndirectQuotation" )
    @JsonProperty( "ExchRateIsIndirectQuotation" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "ExchRateIsIndirectQuotation" )
    private Boolean exchRateIsIndirectQuotation;
    /**
     * Use with available fluent helpers to apply the <b>ExchRateIsIndirectQuotation</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<Boolean> EXCH_RATE_IS_INDIRECT_QUOTATION =
        new EarmarkedFundsDocumentField<Boolean>("ExchRateIsIndirectQuotation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocCreatedByUser</b>
     * </p>
     *
     * @return Created by
     */
    @SerializedName( "EmrkdFndsDocCreatedByUser" )
    @JsonProperty( "EmrkdFndsDocCreatedByUser" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsDocCreatedByUser" )
    private String emrkdFndsDocCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocCreatedByUser</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EMRKD_FNDS_DOC_CREATED_BY_USER =
        new EarmarkedFundsDocumentField<String>("EmrkdFndsDocCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocCreationDate</b>
     * </p>
     *
     * @return Entry date
     */
    @SerializedName( "EmrkdFndsDocCreationDate" )
    @JsonProperty( "EmrkdFndsDocCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EmrkdFndsDocCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime emrkdFndsDocCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocCreationDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<LocalDateTime> EMRKD_FNDS_DOC_CREATION_DATE =
        new EarmarkedFundsDocumentField<LocalDateTime>("EmrkdFndsDocCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocLastChangedByUser</b>
     * </p>
     *
     * @return Last changed by
     */
    @SerializedName( "EmrkdFndsDocLastChangedByUser" )
    @JsonProperty( "EmrkdFndsDocLastChangedByUser" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsDocLastChangedByUser" )
    private String emrkdFndsDocLastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocLastChangedByUser</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EMRKD_FNDS_DOC_LAST_CHANGED_BY_USER =
        new EarmarkedFundsDocumentField<String>("EmrkdFndsDocLastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocLastChangeDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "EmrkdFndsDocLastChangeDate" )
    @JsonProperty( "EmrkdFndsDocLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EmrkdFndsDocLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime emrkdFndsDocLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocLastChangeDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<LocalDateTime> EMRKD_FNDS_DOC_LAST_CHANGE_DATE =
        new EarmarkedFundsDocumentField<LocalDateTime>("EmrkdFndsDocLastChangeDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocLastChangeDateTime</b>
     * </p>
     *
     * @return Change Date and Time
     */
    @SerializedName( "EmrkdFndsDocLastChangeDateTime" )
    @JsonProperty( "EmrkdFndsDocLastChangeDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "EmrkdFndsDocLastChangeDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime emrkdFndsDocLastChangeDateTime;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocLastChangeDateTime</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<ZonedDateTime> EMRKD_FNDS_DOC_LAST_CHANGE_DATE_TIME =
        new EarmarkedFundsDocumentField<ZonedDateTime>("EmrkdFndsDocLastChangeDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @return Reference Transaction
     */
    @SerializedName( "ReferenceDocumentType" )
    @JsonProperty( "ReferenceDocumentType" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentType" )
    private String referenceDocumentType;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentType</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> REFERENCE_DOCUMENT_TYPE =
        new EarmarkedFundsDocumentField<String>("ReferenceDocumentType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @return Reference document number
     */
    @SerializedName( "ReferenceDocument" )
    @JsonProperty( "ReferenceDocument" )
    @Nullable
    @ODataField( odataName = "ReferenceDocument" )
    private String referenceDocument;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocument</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> REFERENCE_DOCUMENT =
        new EarmarkedFundsDocumentField<String>("ReferenceDocument");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @return Reference Organizational Units
     */
    @SerializedName( "ReferenceDocumentContext" )
    @JsonProperty( "ReferenceDocumentContext" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentContext" )
    private String referenceDocumentContext;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentContext</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> REFERENCE_DOCUMENT_CONTEXT =
        new EarmarkedFundsDocumentField<String>("ReferenceDocumentContext");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @return Logical system of source document
     */
    @SerializedName( "ReferenceDocumentLogicalSystem" )
    @JsonProperty( "ReferenceDocumentLogicalSystem" )
    @Nullable
    @ODataField( odataName = "ReferenceDocumentLogicalSystem" )
    private String referenceDocumentLogicalSystem;
    /**
     * Use with available fluent helpers to apply the <b>ReferenceDocumentLogicalSystem</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> REFERENCE_DOCUMENT_LOGICAL_SYSTEM =
        new EarmarkedFundsDocumentField<String>("ReferenceDocumentLogicalSystem");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsManualEditBlock</b>
     * </p>
     *
     * @return Funds precommitment document block
     */
    @SerializedName( "EarmarkedFundsManualEditBlock" )
    @JsonProperty( "EarmarkedFundsManualEditBlock" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsManualEditBlock" )
    private String earmarkedFundsManualEditBlock;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsManualEditBlock</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentField<String> EARMARKED_FUNDS_MANUAL_EDIT_BLOCK =
        new EarmarkedFundsDocumentField<String>("EarmarkedFundsManualEditBlock");
    /**
     * Navigation property <b>to_EarmarkedFundsDocumentItem</b> for <b>EarmarkedFundsDocument</b> to multiple
     * <b>EarmarkedFundsDocumentItem</b>.
     *
     */
    @SerializedName( "to_EarmarkedFundsDocumentItem" )
    @JsonProperty( "to_EarmarkedFundsDocumentItem" )
    @ODataField( odataName = "to_EarmarkedFundsDocumentItem" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EarmarkedFundsDocumentItem> toEarmarkedFundsDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>to_EarmarkedFundsDocumentItem</b> navigation property to query
     * operations.
     *
     */
    public final static EarmarkedFundsDocumentLink<EarmarkedFundsDocumentItem> TO_EARMARKED_FUNDS_DOCUMENT_ITEM =
        new EarmarkedFundsDocumentLink<EarmarkedFundsDocumentItem>("to_EarmarkedFundsDocumentItem");

    @Nonnull
    @Override
    public Class<EarmarkedFundsDocument> getType()
    {
        return EarmarkedFundsDocument.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document number for earmarked funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsExtDocumentNumber</b>
     * </p>
     *
     * @param emrkdFndsExtDocumentNumber
     *            External Document Number for Earmarked Funds
     */
    public void setEmrkdFndsExtDocumentNumber( @Nullable final String emrkdFndsExtDocumentNumber )
    {
        rememberChangedField("EmrkdFndsExtDocumentNumber", this.emrkdFndsExtDocumentNumber);
        this.emrkdFndsExtDocumentNumber = emrkdFndsExtDocumentNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsIntegrationScenario</b>
     * </p>
     *
     * @param emrkdFndsIntegrationScenario
     *            Scenario
     */
    public void setEmrkdFndsIntegrationScenario( @Nullable final String emrkdFndsIntegrationScenario )
    {
        rememberChangedField("EmrkdFndsIntegrationScenario", this.emrkdFndsIntegrationScenario);
        this.emrkdFndsIntegrationScenario = emrkdFndsIntegrationScenario;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsIntegScenarioVariant</b>
     * </p>
     *
     * @param emrkdFndsIntegScenarioVariant
     *            Scenario Variant
     */
    public void setEmrkdFndsIntegScenarioVariant( @Nullable final String emrkdFndsIntegScenarioVariant )
    {
        rememberChangedField("EmrkdFndsIntegScenarioVariant", this.emrkdFndsIntegScenarioVariant);
        this.emrkdFndsIntegScenarioVariant = emrkdFndsIntegScenarioVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentCategory</b>
     * </p>
     *
     * @param earmarkedFundsDocumentCategory
     *            Document Category of an Earmarked Funds Document
     */
    public void setEarmarkedFundsDocumentCategory( @Nullable final String earmarkedFundsDocumentCategory )
    {
        rememberChangedField("EarmarkedFundsDocumentCategory", this.earmarkedFundsDocumentCategory);
        this.earmarkedFundsDocumentCategory = earmarkedFundsDocumentCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentType</b>
     * </p>
     *
     * @param earmarkedFundsDocumentType
     *            Earmarked fund document type
     */
    public void setEarmarkedFundsDocumentType( @Nullable final String earmarkedFundsDocumentType )
    {
        rememberChangedField("EarmarkedFundsDocumentType", this.earmarkedFundsDocumentType);
        this.earmarkedFundsDocumentType = earmarkedFundsDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Local currency key
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocReference</b>
     * </p>
     *
     * @param earmarkedFundsDocReference
     *            Reference Document Number
     */
    public void setEarmarkedFundsDocReference( @Nullable final String earmarkedFundsDocReference )
    {
        rememberChangedField("EarmarkedFundsDocReference", this.earmarkedFundsDocReference);
        this.earmarkedFundsDocReference = earmarkedFundsDocReference;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsHeaderText</b>
     * </p>
     *
     * @param earmarkedFundsHeaderText
     *            Doc.header text
     */
    public void setEarmarkedFundsHeaderText( @Nullable final String earmarkedFundsHeaderText )
    {
        rememberChangedField("EarmarkedFundsHeaderText", this.earmarkedFundsHeaderText);
        this.earmarkedFundsHeaderText = earmarkedFundsHeaderText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DocumentDate</b>
     * </p>
     *
     * @param documentDate
     *            Document Date in Document
     */
    public void setDocumentDate( @Nullable final LocalDateTime documentDate )
    {
        rememberChangedField("DocumentDate", this.documentDate);
        this.documentDate = documentDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ExchangeRateDate</b>
     * </p>
     *
     * @param exchangeRateDate
     *            Translation Date
     */
    public void setExchangeRateDate( @Nullable final LocalDateTime exchangeRateDate )
    {
        rememberChangedField("ExchangeRateDate", this.exchangeRateDate);
        this.exchangeRateDate = exchangeRateDate;
    }

    /**
     * Constraints: Not nullable, Precision: 9, Scale: 5
     * <p>
     * Original property name from the Odata EDM: <b>AbsoluteExchangeRate</b>
     * </p>
     *
     * @param absoluteExchangeRate
     *            Absolute Exchange Rate
     */
    public void setAbsoluteExchangeRate( @Nullable final BigDecimal absoluteExchangeRate )
    {
        rememberChangedField("AbsoluteExchangeRate", this.absoluteExchangeRate);
        this.absoluteExchangeRate = absoluteExchangeRate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ExchRateIsIndirectQuotation</b>
     * </p>
     *
     * @param exchRateIsIndirectQuotation
     *            Exchange Rate Is Indirect Quotation
     */
    public void setExchRateIsIndirectQuotation( @Nullable final Boolean exchRateIsIndirectQuotation )
    {
        rememberChangedField("ExchRateIsIndirectQuotation", this.exchRateIsIndirectQuotation);
        this.exchRateIsIndirectQuotation = exchRateIsIndirectQuotation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocCreatedByUser</b>
     * </p>
     *
     * @param emrkdFndsDocCreatedByUser
     *            Created by
     */
    public void setEmrkdFndsDocCreatedByUser( @Nullable final String emrkdFndsDocCreatedByUser )
    {
        rememberChangedField("EmrkdFndsDocCreatedByUser", this.emrkdFndsDocCreatedByUser);
        this.emrkdFndsDocCreatedByUser = emrkdFndsDocCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocCreationDate</b>
     * </p>
     *
     * @param emrkdFndsDocCreationDate
     *            Entry date
     */
    public void setEmrkdFndsDocCreationDate( @Nullable final LocalDateTime emrkdFndsDocCreationDate )
    {
        rememberChangedField("EmrkdFndsDocCreationDate", this.emrkdFndsDocCreationDate);
        this.emrkdFndsDocCreationDate = emrkdFndsDocCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocLastChangedByUser</b>
     * </p>
     *
     * @param emrkdFndsDocLastChangedByUser
     *            Last changed by
     */
    public void setEmrkdFndsDocLastChangedByUser( @Nullable final String emrkdFndsDocLastChangedByUser )
    {
        rememberChangedField("EmrkdFndsDocLastChangedByUser", this.emrkdFndsDocLastChangedByUser);
        this.emrkdFndsDocLastChangedByUser = emrkdFndsDocLastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocLastChangeDate</b>
     * </p>
     *
     * @param emrkdFndsDocLastChangeDate
     *            Date of Last Change
     */
    public void setEmrkdFndsDocLastChangeDate( @Nullable final LocalDateTime emrkdFndsDocLastChangeDate )
    {
        rememberChangedField("EmrkdFndsDocLastChangeDate", this.emrkdFndsDocLastChangeDate);
        this.emrkdFndsDocLastChangeDate = emrkdFndsDocLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocLastChangeDateTime</b>
     * </p>
     *
     * @param emrkdFndsDocLastChangeDateTime
     *            Change Date and Time
     */
    public void setEmrkdFndsDocLastChangeDateTime( @Nullable final ZonedDateTime emrkdFndsDocLastChangeDateTime )
    {
        rememberChangedField("EmrkdFndsDocLastChangeDateTime", this.emrkdFndsDocLastChangeDateTime);
        this.emrkdFndsDocLastChangeDateTime = emrkdFndsDocLastChangeDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentType</b>
     * </p>
     *
     * @param referenceDocumentType
     *            Reference Transaction
     */
    public void setReferenceDocumentType( @Nullable final String referenceDocumentType )
    {
        rememberChangedField("ReferenceDocumentType", this.referenceDocumentType);
        this.referenceDocumentType = referenceDocumentType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocument</b>
     * </p>
     *
     * @param referenceDocument
     *            Reference document number
     */
    public void setReferenceDocument( @Nullable final String referenceDocument )
    {
        rememberChangedField("ReferenceDocument", this.referenceDocument);
        this.referenceDocument = referenceDocument;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentContext</b>
     * </p>
     *
     * @param referenceDocumentContext
     *            Reference Organizational Units
     */
    public void setReferenceDocumentContext( @Nullable final String referenceDocumentContext )
    {
        rememberChangedField("ReferenceDocumentContext", this.referenceDocumentContext);
        this.referenceDocumentContext = referenceDocumentContext;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ReferenceDocumentLogicalSystem</b>
     * </p>
     *
     * @param referenceDocumentLogicalSystem
     *            Logical system of source document
     */
    public void setReferenceDocumentLogicalSystem( @Nullable final String referenceDocumentLogicalSystem )
    {
        rememberChangedField("ReferenceDocumentLogicalSystem", this.referenceDocumentLogicalSystem);
        this.referenceDocumentLogicalSystem = referenceDocumentLogicalSystem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsManualEditBlock</b>
     * </p>
     *
     * @param earmarkedFundsManualEditBlock
     *            Funds precommitment document block
     */
    public void setEarmarkedFundsManualEditBlock( @Nullable final String earmarkedFundsManualEditBlock )
    {
        rememberChangedField("EarmarkedFundsManualEditBlock", this.earmarkedFundsManualEditBlock);
        this.earmarkedFundsManualEditBlock = earmarkedFundsManualEditBlock;
    }

    @Override
    protected String getEntityCollection()
    {
        return "EarmarkedFundsDocument";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("EmrkdFndsExtDocumentNumber", getEmrkdFndsExtDocumentNumber());
        values.put("EmrkdFndsIntegrationScenario", getEmrkdFndsIntegrationScenario());
        values.put("EmrkdFndsIntegScenarioVariant", getEmrkdFndsIntegScenarioVariant());
        values.put("EarmarkedFundsDocumentCategory", getEarmarkedFundsDocumentCategory());
        values.put("EarmarkedFundsDocumentType", getEarmarkedFundsDocumentType());
        values.put("CompanyCode", getCompanyCode());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("EarmarkedFundsDocReference", getEarmarkedFundsDocReference());
        values.put("EarmarkedFundsHeaderText", getEarmarkedFundsHeaderText());
        values.put("PostingDate", getPostingDate());
        values.put("DocumentDate", getDocumentDate());
        values.put("ExchangeRateDate", getExchangeRateDate());
        values.put("AbsoluteExchangeRate", getAbsoluteExchangeRate());
        values.put("ExchRateIsIndirectQuotation", getExchRateIsIndirectQuotation());
        values.put("EmrkdFndsDocCreatedByUser", getEmrkdFndsDocCreatedByUser());
        values.put("EmrkdFndsDocCreationDate", getEmrkdFndsDocCreationDate());
        values.put("EmrkdFndsDocLastChangedByUser", getEmrkdFndsDocLastChangedByUser());
        values.put("EmrkdFndsDocLastChangeDate", getEmrkdFndsDocLastChangeDate());
        values.put("EmrkdFndsDocLastChangeDateTime", getEmrkdFndsDocLastChangeDateTime());
        values.put("ReferenceDocumentType", getReferenceDocumentType());
        values.put("ReferenceDocument", getReferenceDocument());
        values.put("ReferenceDocumentContext", getReferenceDocumentContext());
        values.put("ReferenceDocumentLogicalSystem", getReferenceDocumentLogicalSystem());
        values.put("EarmarkedFundsManualEditBlock", getEarmarkedFundsManualEditBlock());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsExtDocumentNumber") ) {
                final Object value = values.remove("EmrkdFndsExtDocumentNumber");
                if( (value == null) || (!value.equals(getEmrkdFndsExtDocumentNumber())) ) {
                    setEmrkdFndsExtDocumentNumber(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsIntegrationScenario") ) {
                final Object value = values.remove("EmrkdFndsIntegrationScenario");
                if( (value == null) || (!value.equals(getEmrkdFndsIntegrationScenario())) ) {
                    setEmrkdFndsIntegrationScenario(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsIntegScenarioVariant") ) {
                final Object value = values.remove("EmrkdFndsIntegScenarioVariant");
                if( (value == null) || (!value.equals(getEmrkdFndsIntegScenarioVariant())) ) {
                    setEmrkdFndsIntegScenarioVariant(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocumentCategory") ) {
                final Object value = values.remove("EarmarkedFundsDocumentCategory");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocumentCategory())) ) {
                    setEarmarkedFundsDocumentCategory(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocumentType") ) {
                final Object value = values.remove("EarmarkedFundsDocumentType");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocumentType())) ) {
                    setEarmarkedFundsDocumentType(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocReference") ) {
                final Object value = values.remove("EarmarkedFundsDocReference");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocReference())) ) {
                    setEarmarkedFundsDocReference(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsHeaderText") ) {
                final Object value = values.remove("EarmarkedFundsHeaderText");
                if( (value == null) || (!value.equals(getEarmarkedFundsHeaderText())) ) {
                    setEarmarkedFundsHeaderText(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("DocumentDate") ) {
                final Object value = values.remove("DocumentDate");
                if( (value == null) || (!value.equals(getDocumentDate())) ) {
                    setDocumentDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ExchangeRateDate") ) {
                final Object value = values.remove("ExchangeRateDate");
                if( (value == null) || (!value.equals(getExchangeRateDate())) ) {
                    setExchangeRateDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("AbsoluteExchangeRate") ) {
                final Object value = values.remove("AbsoluteExchangeRate");
                if( (value == null) || (!value.equals(getAbsoluteExchangeRate())) ) {
                    setAbsoluteExchangeRate(((BigDecimal) value));
                }
            }
            if( values.containsKey("ExchRateIsIndirectQuotation") ) {
                final Object value = values.remove("ExchRateIsIndirectQuotation");
                if( (value == null) || (!value.equals(getExchRateIsIndirectQuotation())) ) {
                    setExchRateIsIndirectQuotation(((Boolean) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocCreatedByUser") ) {
                final Object value = values.remove("EmrkdFndsDocCreatedByUser");
                if( (value == null) || (!value.equals(getEmrkdFndsDocCreatedByUser())) ) {
                    setEmrkdFndsDocCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocCreationDate") ) {
                final Object value = values.remove("EmrkdFndsDocCreationDate");
                if( (value == null) || (!value.equals(getEmrkdFndsDocCreationDate())) ) {
                    setEmrkdFndsDocCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocLastChangedByUser") ) {
                final Object value = values.remove("EmrkdFndsDocLastChangedByUser");
                if( (value == null) || (!value.equals(getEmrkdFndsDocLastChangedByUser())) ) {
                    setEmrkdFndsDocLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocLastChangeDate") ) {
                final Object value = values.remove("EmrkdFndsDocLastChangeDate");
                if( (value == null) || (!value.equals(getEmrkdFndsDocLastChangeDate())) ) {
                    setEmrkdFndsDocLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocLastChangeDateTime") ) {
                final Object value = values.remove("EmrkdFndsDocLastChangeDateTime");
                if( (value == null) || (!value.equals(getEmrkdFndsDocLastChangeDateTime())) ) {
                    setEmrkdFndsDocLastChangeDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("ReferenceDocumentType") ) {
                final Object value = values.remove("ReferenceDocumentType");
                if( (value == null) || (!value.equals(getReferenceDocumentType())) ) {
                    setReferenceDocumentType(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocument") ) {
                final Object value = values.remove("ReferenceDocument");
                if( (value == null) || (!value.equals(getReferenceDocument())) ) {
                    setReferenceDocument(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentContext") ) {
                final Object value = values.remove("ReferenceDocumentContext");
                if( (value == null) || (!value.equals(getReferenceDocumentContext())) ) {
                    setReferenceDocumentContext(((String) value));
                }
            }
            if( values.containsKey("ReferenceDocumentLogicalSystem") ) {
                final Object value = values.remove("ReferenceDocumentLogicalSystem");
                if( (value == null) || (!value.equals(getReferenceDocumentLogicalSystem())) ) {
                    setReferenceDocumentLogicalSystem(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsManualEditBlock") ) {
                final Object value = values.remove("EarmarkedFundsManualEditBlock");
                if( (value == null) || (!value.equals(getEarmarkedFundsManualEditBlock())) ) {
                    setEarmarkedFundsManualEditBlock(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EarmarkedFundsDocumentItem") ) {
                final Object value = (values).remove("to_EarmarkedFundsDocumentItem");
                if( value instanceof Iterable ) {
                    if( toEarmarkedFundsDocumentItem == null ) {
                        toEarmarkedFundsDocumentItem = Lists.newArrayList();
                    } else {
                        toEarmarkedFundsDocumentItem = Lists.newArrayList(toEarmarkedFundsDocumentItem);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EarmarkedFundsDocumentItem entity;
                        if( toEarmarkedFundsDocumentItem.size() > i ) {
                            entity = toEarmarkedFundsDocumentItem.get(i);
                        } else {
                            entity = new EarmarkedFundsDocumentItem();
                            toEarmarkedFundsDocumentItem.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EarmarkedFundsDocumentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EarmarkedFundsDocumentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EarmarkedFundsDocumentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EarmarkedFundsDocumentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEarmarkedFundsDocumentItem != null ) {
            (values).put("to_EarmarkedFundsDocumentItem", toEarmarkedFundsDocumentItem);
        }
        return values;
    }

    /**
     * Fetches the <b>EarmarkedFundsDocumentItem</b> entities (one to many) associated with this entity. This
     * corresponds to the OData navigation property <b>to_EarmarkedFundsDocumentItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EarmarkedFundsDocumentItem</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EarmarkedFundsDocumentItem> fetchEarmarkedFundsDocumentItem()
    {
        return fetchFieldAsList("to_EarmarkedFundsDocumentItem", EarmarkedFundsDocumentItem.class);
    }

    /**
     * Retrieval of associated <b>EarmarkedFundsDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EarmarkedFundsDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_EarmarkedFundsDocumentItem</b> of a queried <b>EarmarkedFundsDocument</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EarmarkedFundsDocumentItem</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EarmarkedFundsDocumentItem> getEarmarkedFundsDocumentItemOrFetch()
    {
        if( toEarmarkedFundsDocumentItem == null ) {
            toEarmarkedFundsDocumentItem = fetchEarmarkedFundsDocumentItem();
        }
        return toEarmarkedFundsDocumentItem;
    }

    /**
     * Retrieval of associated <b>EarmarkedFundsDocumentItem</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_EarmarkedFundsDocumentItem</b>.
     * <p>
     * If the navigation property for an entity <b>EarmarkedFundsDocument</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EarmarkedFundsDocumentItem</b> is already loaded, the
     *         result will contain the <b>EarmarkedFundsDocumentItem</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EarmarkedFundsDocumentItem>> getEarmarkedFundsDocumentItemIfPresent()
    {
        return Option.of(toEarmarkedFundsDocumentItem);
    }

    /**
     * Overwrites the list of associated <b>EarmarkedFundsDocumentItem</b> entities for the loaded navigation property
     * <b>to_EarmarkedFundsDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_EarmarkedFundsDocumentItem</b> of a queried <b>EarmarkedFundsDocument</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EarmarkedFundsDocumentItem</b> entities.
     */
    public void setEarmarkedFundsDocumentItem( @Nonnull final List<EarmarkedFundsDocumentItem> value )
    {
        if( toEarmarkedFundsDocumentItem == null ) {
            toEarmarkedFundsDocumentItem = Lists.newArrayList();
        }
        toEarmarkedFundsDocumentItem.clear();
        toEarmarkedFundsDocumentItem.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EarmarkedFundsDocumentItem</b> entities. This corresponds to the OData
     * navigation property <b>to_EarmarkedFundsDocumentItem</b>.
     * <p>
     * If the navigation property <b>to_EarmarkedFundsDocumentItem</b> of a queried <b>EarmarkedFundsDocument</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EarmarkedFundsDocumentItem</b> entities.
     */
    public void addEarmarkedFundsDocumentItem( EarmarkedFundsDocumentItem... entity )
    {
        if( toEarmarkedFundsDocumentItem == null ) {
            toEarmarkedFundsDocumentItem = Lists.newArrayList();
        }
        toEarmarkedFundsDocumentItem.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EarmarkedFundsDocument instances.
     *
     */
    public final static class EarmarkedFundsDocumentBuilder
    {

        private List<EarmarkedFundsDocumentItem> toEarmarkedFundsDocumentItem = Lists.newArrayList();

        private EarmarkedFundsDocument.EarmarkedFundsDocumentBuilder toEarmarkedFundsDocumentItem(
            final List<EarmarkedFundsDocumentItem> value )
        {
            toEarmarkedFundsDocumentItem.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_EarmarkedFundsDocumentItem</b> for <b>EarmarkedFundsDocument</b> to multiple
         * <b>EarmarkedFundsDocumentItem</b>.
         *
         * @param value
         *            The EarmarkedFundsDocumentItems to build this EarmarkedFundsDocument with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EarmarkedFundsDocument.EarmarkedFundsDocumentBuilder earmarkedFundsDocumentItem(
            EarmarkedFundsDocumentItem... value )
        {
            return toEarmarkedFundsDocumentItem(Lists.newArrayList(value));
        }

    }

}
