/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.selectable.EarmarkedFundsDocumentSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
 * EarmarkedFundsDocument} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class EarmarkedFundsDocumentByKeyFluentHelper
    extends
    FluentHelperByKey<EarmarkedFundsDocumentByKeyFluentHelper, EarmarkedFundsDocument, EarmarkedFundsDocumentSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     * EarmarkedFundsDocument} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code EarmarkedFundsDocument}
     * @param servicePath
     *            Service path to be used to fetch a single {@code EarmarkedFundsDocument}
     * @param earmarkedFundsDocument
     *            Document number for earmarked funds
     *            <p>
     *            Constraints: Not nullable, Maximum length: 10
     *            </p>
     */
    public EarmarkedFundsDocumentByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String earmarkedFundsDocument )
    {
        super(servicePath, entityCollection);
        this.key.put("EarmarkedFundsDocument", earmarkedFundsDocument);
    }

    @Override
    @Nonnull
    protected Class<EarmarkedFundsDocument> getEntityClass()
    {
        return EarmarkedFundsDocument.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
