/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.field.EarmarkedFundsDocumentItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.link.EarmarkedFundsDocumentItemOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.selectable.EarmarkedFundsDocumentItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Remote Interface Earmarked Funds Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>EarmarkedFundsDocumentItem_Type</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EarmarkedFundsDocumentItem extends VdmEntity<EarmarkedFundsDocumentItem>
{

    /**
     * Selector for all available fields of EarmarkedFundsDocumentItem.
     *
     */
    public final static EarmarkedFundsDocumentItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @return Document number for earmarked funds
     */
    @Key
    @SerializedName( "EarmarkedFundsDocument" )
    @JsonProperty( "EarmarkedFundsDocument" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocument" )
    private String earmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocument</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> EARMARKED_FUNDS_DOCUMENT =
        new EarmarkedFundsDocumentItemField<String>("EarmarkedFundsDocument");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentItem</b>
     * </p>
     *
     * @return Earmarked Funds: Document Item
     */
    @Key
    @SerializedName( "EarmarkedFundsDocumentItem" )
    @JsonProperty( "EarmarkedFundsDocumentItem" )
    @Nullable
    @ODataField( odataName = "EarmarkedFundsDocumentItem" )
    private String earmarkedFundsDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>EarmarkedFundsDocumentItem</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> EARMARKED_FUNDS_DOCUMENT_ITEM =
        new EarmarkedFundsDocumentItemField<String>("EarmarkedFundsDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> COMPANY_CODE =
        new EarmarkedFundsDocumentItemField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @return Transaction Currency
     */
    @SerializedName( "TransactionCurrency" )
    @JsonProperty( "TransactionCurrency" )
    @Nullable
    @ODataField( odataName = "TransactionCurrency" )
    private String transactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrency</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> TRANSACTION_CURRENCY =
        new EarmarkedFundsDocumentItemField<String>("TransactionCurrency");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @return Local currency key
     */
    @SerializedName( "CompanyCodeCurrency" )
    @JsonProperty( "CompanyCodeCurrency" )
    @Nullable
    @ODataField( odataName = "CompanyCodeCurrency" )
    private String companyCodeCurrency;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeCurrency</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> COMPANY_CODE_CURRENCY =
        new EarmarkedFundsDocumentItemField<String>("CompanyCodeCurrency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @return Posting Date in the Document
     */
    @SerializedName( "PostingDate" )
    @JsonProperty( "PostingDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "PostingDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime postingDate;
    /**
     * Use with available fluent helpers to apply the <b>PostingDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<LocalDateTime> POSTING_DATE =
        new EarmarkedFundsDocumentItemField<LocalDateTime>("PostingDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmCreatedByUser</b>
     * </p>
     *
     * @return Created by
     */
    @SerializedName( "EmrkdFndsDocItmCreatedByUser" )
    @JsonProperty( "EmrkdFndsDocItmCreatedByUser" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsDocItmCreatedByUser" )
    private String emrkdFndsDocItmCreatedByUser;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocItmCreatedByUser</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> EMRKD_FNDS_DOC_ITM_CREATED_BY_USER =
        new EarmarkedFundsDocumentItemField<String>("EmrkdFndsDocItmCreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmCreationDate</b>
     * </p>
     *
     * @return Entry date
     */
    @SerializedName( "EmrkdFndsDocItmCreationDate" )
    @JsonProperty( "EmrkdFndsDocItmCreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EmrkdFndsDocItmCreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime emrkdFndsDocItmCreationDate;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocItmCreationDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<LocalDateTime> EMRKD_FNDS_DOC_ITM_CREATION_DATE =
        new EarmarkedFundsDocumentItemField<LocalDateTime>("EmrkdFndsDocItmCreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmLastChgdByUsr</b>
     * </p>
     *
     * @return Last changed by
     */
    @SerializedName( "EmrkdFndsDocItmLastChgdByUsr" )
    @JsonProperty( "EmrkdFndsDocItmLastChgdByUsr" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsDocItmLastChgdByUsr" )
    private String emrkdFndsDocItmLastChgdByUsr;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocItmLastChgdByUsr</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> EMRKD_FNDS_DOC_ITM_LAST_CHGD_BY_USR =
        new EarmarkedFundsDocumentItemField<String>("EmrkdFndsDocItmLastChgdByUsr");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmLastChangeDate</b>
     * </p>
     *
     * @return Date of Last Change
     */
    @SerializedName( "EmrkdFndsDocItmLastChangeDate" )
    @JsonProperty( "EmrkdFndsDocItmLastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EmrkdFndsDocItmLastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime emrkdFndsDocItmLastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsDocItmLastChangeDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<LocalDateTime> EMRKD_FNDS_DOC_ITM_LAST_CHANGE_DATE =
        new EarmarkedFundsDocumentItemField<LocalDateTime>("EmrkdFndsDocItmLastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsReferenceDocumentItem</b>
     * </p>
     *
     * @return Reference line item
     */
    @SerializedName( "EmrkdFndsReferenceDocumentItem" )
    @JsonProperty( "EmrkdFndsReferenceDocumentItem" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsReferenceDocumentItem" )
    private String emrkdFndsReferenceDocumentItem;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsReferenceDocumentItem</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> EMRKD_FNDS_REFERENCE_DOCUMENT_ITEM =
        new EarmarkedFundsDocumentItemField<String>("EmrkdFndsReferenceDocumentItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @return G/L Account Number
     */
    @SerializedName( "GLAccount" )
    @JsonProperty( "GLAccount" )
    @Nullable
    @ODataField( odataName = "GLAccount" )
    private String gLAccount;
    /**
     * Use with available fluent helpers to apply the <b>GLAccount</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> GL_ACCOUNT =
        new EarmarkedFundsDocumentItemField<String>("GLAccount");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> COST_CENTER =
        new EarmarkedFundsDocumentItemField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element) Edited
     */
    @SerializedName( "WBSElementExternalID" )
    @JsonProperty( "WBSElementExternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementExternalID" )
    private String wBSElementExternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementExternalID</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> WBS_ELEMENT_EXTERNAL_ID =
        new EarmarkedFundsDocumentItemField<String>("WBSElementExternalID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @return Fund
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> FUND =
        new EarmarkedFundsDocumentItemField<String>("Fund");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @return Budget Period
     */
    @SerializedName( "BudgetPeriod" )
    @JsonProperty( "BudgetPeriod" )
    @Nullable
    @ODataField( odataName = "BudgetPeriod" )
    private String budgetPeriod;
    /**
     * Use with available fluent helpers to apply the <b>BudgetPeriod</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> BUDGET_PERIOD =
        new EarmarkedFundsDocumentItemField<String>("BudgetPeriod");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @return Commitment Item
     */
    @SerializedName( "CommitmentItem" )
    @JsonProperty( "CommitmentItem" )
    @Nullable
    @ODataField( odataName = "CommitmentItem" )
    private String commitmentItem;
    /**
     * Use with available fluent helpers to apply the <b>CommitmentItem</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> COMMITMENT_ITEM =
        new EarmarkedFundsDocumentItemField<String>("CommitmentItem");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @return Funds Center
     */
    @SerializedName( "FundsCenter" )
    @JsonProperty( "FundsCenter" )
    @Nullable
    @ODataField( odataName = "FundsCenter" )
    private String fundsCenter;
    /**
     * Use with available fluent helpers to apply the <b>FundsCenter</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> FUNDS_CENTER =
        new EarmarkedFundsDocumentItemField<String>("FundsCenter");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FundedProgram</b>
     * </p>
     *
     * @return Funded Program
     */
    @SerializedName( "FundedProgram" )
    @JsonProperty( "FundedProgram" )
    @Nullable
    @ODataField( odataName = "FundedProgram" )
    private String fundedProgram;
    /**
     * Use with available fluent helpers to apply the <b>FundedProgram</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> FUNDED_PROGRAM =
        new EarmarkedFundsDocumentItemField<String>("FundedProgram");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> FUNCTIONAL_AREA =
        new EarmarkedFundsDocumentItemField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @return Grant
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> GRANT_ID =
        new EarmarkedFundsDocumentItemField<String>("GrantID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Account Number of Supplier
     */
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> SUPPLIER =
        new EarmarkedFundsDocumentItemField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @return Item Text
     */
    @SerializedName( "DocumentItemText" )
    @JsonProperty( "DocumentItemText" )
    @Nullable
    @ODataField( odataName = "DocumentItemText" )
    private String documentItemText;
    /**
     * Use with available fluent helpers to apply the <b>DocumentItemText</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> DOCUMENT_ITEM_TEXT =
        new EarmarkedFundsDocumentItemField<String>("DocumentItemText");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueDate</b>
     * </p>
     *
     * @return Costs due on
     */
    @SerializedName( "DueDate" )
    @JsonProperty( "DueDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "DueDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime dueDate;
    /**
     * Use with available fluent helpers to apply the <b>DueDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<LocalDateTime> DUE_DATE =
        new EarmarkedFundsDocumentItemField<LocalDateTime>("DueDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> PROFIT_CENTER =
        new EarmarkedFundsDocumentItemField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsReservationDoc</b>
     * </p>
     *
     * @return Referenced Funds Reservation
     */
    @SerializedName( "PrdcssrFundsReservationDoc" )
    @JsonProperty( "PrdcssrFundsReservationDoc" )
    @Nullable
    @ODataField( odataName = "PrdcssrFundsReservationDoc" )
    private String prdcssrFundsReservationDoc;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrFundsReservationDoc</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> PRDCSSR_FUNDS_RESERVATION_DOC =
        new EarmarkedFundsDocumentItemField<String>("PrdcssrFundsReservationDoc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsReservationDocItem</b>
     * </p>
     *
     * @return Item in Referenced Funds Reservation
     */
    @SerializedName( "PrdcssrFundsReservationDocItem" )
    @JsonProperty( "PrdcssrFundsReservationDocItem" )
    @Nullable
    @ODataField( odataName = "PrdcssrFundsReservationDocItem" )
    private String prdcssrFundsReservationDocItem;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrFundsReservationDocItem</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> PRDCSSR_FUNDS_RESERVATION_DOC_ITEM =
        new EarmarkedFundsDocumentItemField<String>("PrdcssrFundsReservationDocItem");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsPreCmtmtDoc</b>
     * </p>
     *
     * @return Referenced Funds Precommitment
     */
    @SerializedName( "PrdcssrFundsPreCmtmtDoc" )
    @JsonProperty( "PrdcssrFundsPreCmtmtDoc" )
    @Nullable
    @ODataField( odataName = "PrdcssrFundsPreCmtmtDoc" )
    private String prdcssrFundsPreCmtmtDoc;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrFundsPreCmtmtDoc</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> PRDCSSR_FUNDS_PRE_CMTMT_DOC =
        new EarmarkedFundsDocumentItemField<String>("PrdcssrFundsPreCmtmtDoc");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsPreCmtmtDocItem</b>
     * </p>
     *
     * @return Item in Referenced Funds Precommitment
     */
    @SerializedName( "PrdcssrFundsPreCmtmtDocItem" )
    @JsonProperty( "PrdcssrFundsPreCmtmtDocItem" )
    @Nullable
    @ODataField( odataName = "PrdcssrFundsPreCmtmtDocItem" )
    private String prdcssrFundsPreCmtmtDocItem;
    /**
     * Use with available fluent helpers to apply the <b>PrdcssrFundsPreCmtmtDocItem</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> PRDCSSR_FUNDS_PRE_CMTMT_DOC_ITEM =
        new EarmarkedFundsDocumentItemField<String>("PrdcssrFundsPreCmtmtDocItem");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmPrdcssrCompleted</b>
     * </p>
     *
     * @return Used earmarked funds are set to "Completed".
     */
    @SerializedName( "EmrkdFndsItmPrdcssrCompleted" )
    @JsonProperty( "EmrkdFndsItmPrdcssrCompleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EmrkdFndsItmPrdcssrCompleted" )
    private Boolean emrkdFndsItmPrdcssrCompleted;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsItmPrdcssrCompleted</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<Boolean> EMRKD_FNDS_ITM_PRDCSSR_COMPLETED =
        new EarmarkedFundsDocumentItemField<Boolean>("EmrkdFndsItmPrdcssrCompleted");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmCompletionDate</b>
     * </p>
     *
     * @return Completion date
     */
    @SerializedName( "EmrkdFndsItmCompletionDate" )
    @JsonProperty( "EmrkdFndsItmCompletionDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "EmrkdFndsItmCompletionDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime emrkdFndsItmCompletionDate;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsItmCompletionDate</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<LocalDateTime> EMRKD_FNDS_ITM_COMPLETION_DATE =
        new EarmarkedFundsDocumentItemField<LocalDateTime>("EmrkdFndsItmCompletionDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmIsCompleted</b>
     * </p>
     *
     * @return Completion indicator for earmarked funds document item
     */
    @SerializedName( "EmrkdFndsItmIsCompleted" )
    @JsonProperty( "EmrkdFndsItmIsCompleted" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EmrkdFndsItmIsCompleted" )
    private Boolean emrkdFndsItmIsCompleted;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsItmIsCompleted</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<Boolean> EMRKD_FNDS_ITM_IS_COMPLETED =
        new EarmarkedFundsDocumentItemField<Boolean>("EmrkdFndsItmIsCompleted");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmManualEditBlock</b>
     * </p>
     *
     * @return Item Block to Prevent Manual Processing
     */
    @SerializedName( "EmrkdFndsItmManualEditBlock" )
    @JsonProperty( "EmrkdFndsItmManualEditBlock" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsItmManualEditBlock" )
    private String emrkdFndsItmManualEditBlock;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsItmManualEditBlock</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<String> EMRKD_FNDS_ITM_MANUAL_EDIT_BLOCK =
        new EarmarkedFundsDocumentItemField<String>("EmrkdFndsItmManualEditBlock");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmIsBlkdAgainstUsage</b>
     * </p>
     *
     * @return Blocking Indicator (Item)
     */
    @SerializedName( "EmrkdFndsItmIsBlkdAgainstUsage" )
    @JsonProperty( "EmrkdFndsItmIsBlkdAgainstUsage" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EmrkdFndsItmIsBlkdAgainstUsage" )
    private Boolean emrkdFndsItmIsBlkdAgainstUsage;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsItmIsBlkdAgainstUsage</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<Boolean> EMRKD_FNDS_ITM_IS_BLKD_AGAINST_USAGE =
        new EarmarkedFundsDocumentItemField<Boolean>("EmrkdFndsItmIsBlkdAgainstUsage");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmIsApproved</b>
     * </p>
     *
     * @return Earmarked Funds Item Is Approved
     */
    @SerializedName( "EmrkdFndsItmIsApproved" )
    @JsonProperty( "EmrkdFndsItmIsApproved" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EmrkdFndsItmIsApproved" )
    private Boolean emrkdFndsItmIsApproved;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsItmIsApproved</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<Boolean> EMRKD_FNDS_ITM_IS_APPROVED =
        new EarmarkedFundsDocumentItemField<Boolean>("EmrkdFndsItmIsApproved");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsAcctAssgmtChangeable</b>
     * </p>
     *
     * @return Account Assignment Can Be Changed in Follow-On Document
     */
    @SerializedName( "EmrkdFndsAcctAssgmtChangeable" )
    @JsonProperty( "EmrkdFndsAcctAssgmtChangeable" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EmrkdFndsAcctAssgmtChangeable" )
    private Boolean emrkdFndsAcctAssgmtChangeable;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsAcctAssgmtChangeable</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<Boolean> EMRKD_FNDS_ACCT_ASSGMT_CHANGEABLE =
        new EarmarkedFundsDocumentItemField<Boolean>("EmrkdFndsAcctAssgmtChangeable");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsAmountInTransCrcy</b>
     * </p>
     *
     * @return Total reserved amount in transaction currency
     */
    @SerializedName( "EmrkdFndsAmountInTransCrcy" )
    @JsonProperty( "EmrkdFndsAmountInTransCrcy" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsAmountInTransCrcy" )
    private BigDecimal emrkdFndsAmountInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsAmountInTransCrcy</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<BigDecimal> EMRKD_FNDS_AMOUNT_IN_TRANS_CRCY =
        new EarmarkedFundsDocumentItemField<BigDecimal>("EmrkdFndsAmountInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsOpenAmtInTransCrcy</b>
     * </p>
     *
     * @return Open Amount in Transaction Currency
     */
    @SerializedName( "EmrkdFndsOpenAmtInTransCrcy" )
    @JsonProperty( "EmrkdFndsOpenAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsOpenAmtInTransCrcy" )
    private BigDecimal emrkdFndsOpenAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsOpenAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<BigDecimal> EMRKD_FNDS_OPEN_AMT_IN_TRANS_CRCY =
        new EarmarkedFundsDocumentItemField<BigDecimal>("EmrkdFndsOpenAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsCnsmdAmtInTransCrcy</b>
     * </p>
     *
     * @return Funds reservation amount reduced
     */
    @SerializedName( "EmrkdFndsCnsmdAmtInTransCrcy" )
    @JsonProperty( "EmrkdFndsCnsmdAmtInTransCrcy" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsCnsmdAmtInTransCrcy" )
    private BigDecimal emrkdFndsCnsmdAmtInTransCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsCnsmdAmtInTransCrcy</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<BigDecimal> EMRKD_FNDS_CNSMD_AMT_IN_TRANS_CRCY =
        new EarmarkedFundsDocumentItemField<BigDecimal>("EmrkdFndsCnsmdAmtInTransCrcy");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsAmountInCCCrcy</b>
     * </p>
     *
     * @return Total Reserved Amount in Local Currency
     */
    @SerializedName( "EmrkdFndsAmountInCCCrcy" )
    @JsonProperty( "EmrkdFndsAmountInCCCrcy" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsAmountInCCCrcy" )
    private BigDecimal emrkdFndsAmountInCCCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsAmountInCCCrcy</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<BigDecimal> EMRKD_FNDS_AMOUNT_IN_CC_CRCY =
        new EarmarkedFundsDocumentItemField<BigDecimal>("EmrkdFndsAmountInCCCrcy");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsOpenAmtInCCCrcy</b>
     * </p>
     *
     * @return Open Amount in Local Currency
     */
    @SerializedName( "EmrkdFndsOpenAmtInCCCrcy" )
    @JsonProperty( "EmrkdFndsOpenAmtInCCCrcy" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsOpenAmtInCCCrcy" )
    private BigDecimal emrkdFndsOpenAmtInCCCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsOpenAmtInCCCrcy</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<BigDecimal> EMRKD_FNDS_OPEN_AMT_IN_CC_CRCY =
        new EarmarkedFundsDocumentItemField<BigDecimal>("EmrkdFndsOpenAmtInCCCrcy");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsCnsmdAmtInCCCrcy</b>
     * </p>
     *
     * @return Funds reservation amount reduced
     */
    @SerializedName( "EmrkdFndsCnsmdAmtInCCCrcy" )
    @JsonProperty( "EmrkdFndsCnsmdAmtInCCCrcy" )
    @Nullable
    @ODataField( odataName = "EmrkdFndsCnsmdAmtInCCCrcy" )
    private BigDecimal emrkdFndsCnsmdAmtInCCCrcy;
    /**
     * Use with available fluent helpers to apply the <b>EmrkdFndsCnsmdAmtInCCCrcy</b> field to query operations.
     *
     */
    public final static EarmarkedFundsDocumentItemField<BigDecimal> EMRKD_FNDS_CNSMD_AMT_IN_CC_CRCY =
        new EarmarkedFundsDocumentItemField<BigDecimal>("EmrkdFndsCnsmdAmtInCCCrcy");
    /**
     * Navigation property <b>to_EarmarkedFundsDocument</b> for <b>EarmarkedFundsDocumentItem</b> to single
     * <b>EarmarkedFundsDocument</b>.
     *
     */
    @SerializedName( "to_EarmarkedFundsDocument" )
    @JsonProperty( "to_EarmarkedFundsDocument" )
    @ODataField( odataName = "to_EarmarkedFundsDocument" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EarmarkedFundsDocument toEarmarkedFundsDocument;
    /**
     * Use with available fluent helpers to apply the <b>to_EarmarkedFundsDocument</b> navigation property to query
     * operations.
     *
     */
    public final static EarmarkedFundsDocumentItemOneToOneLink<EarmarkedFundsDocument> TO_EARMARKED_FUNDS_DOCUMENT =
        new EarmarkedFundsDocumentItemOneToOneLink<EarmarkedFundsDocument>("to_EarmarkedFundsDocument");

    @Nonnull
    @Override
    public Class<EarmarkedFundsDocumentItem> getType()
    {
        return EarmarkedFundsDocumentItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
     * </p>
     *
     * @param earmarkedFundsDocument
     *            Document number for earmarked funds
     */
    public void setEarmarkedFundsDocument( @Nullable final String earmarkedFundsDocument )
    {
        rememberChangedField("EarmarkedFundsDocument", this.earmarkedFundsDocument);
        this.earmarkedFundsDocument = earmarkedFundsDocument;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>EarmarkedFundsDocumentItem</b>
     * </p>
     *
     * @param earmarkedFundsDocumentItem
     *            Earmarked Funds: Document Item
     */
    public void setEarmarkedFundsDocumentItem( @Nullable final String earmarkedFundsDocumentItem )
    {
        rememberChangedField("EarmarkedFundsDocumentItem", this.earmarkedFundsDocumentItem);
        this.earmarkedFundsDocumentItem = earmarkedFundsDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrency</b>
     * </p>
     *
     * @param transactionCurrency
     *            Transaction Currency
     */
    public void setTransactionCurrency( @Nullable final String transactionCurrency )
    {
        rememberChangedField("TransactionCurrency", this.transactionCurrency);
        this.transactionCurrency = transactionCurrency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeCurrency</b>
     * </p>
     *
     * @param companyCodeCurrency
     *            Local currency key
     */
    public void setCompanyCodeCurrency( @Nullable final String companyCodeCurrency )
    {
        rememberChangedField("CompanyCodeCurrency", this.companyCodeCurrency);
        this.companyCodeCurrency = companyCodeCurrency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>PostingDate</b>
     * </p>
     *
     * @param postingDate
     *            Posting Date in the Document
     */
    public void setPostingDate( @Nullable final LocalDateTime postingDate )
    {
        rememberChangedField("PostingDate", this.postingDate);
        this.postingDate = postingDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmCreatedByUser</b>
     * </p>
     *
     * @param emrkdFndsDocItmCreatedByUser
     *            Created by
     */
    public void setEmrkdFndsDocItmCreatedByUser( @Nullable final String emrkdFndsDocItmCreatedByUser )
    {
        rememberChangedField("EmrkdFndsDocItmCreatedByUser", this.emrkdFndsDocItmCreatedByUser);
        this.emrkdFndsDocItmCreatedByUser = emrkdFndsDocItmCreatedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmCreationDate</b>
     * </p>
     *
     * @param emrkdFndsDocItmCreationDate
     *            Entry date
     */
    public void setEmrkdFndsDocItmCreationDate( @Nullable final LocalDateTime emrkdFndsDocItmCreationDate )
    {
        rememberChangedField("EmrkdFndsDocItmCreationDate", this.emrkdFndsDocItmCreationDate);
        this.emrkdFndsDocItmCreationDate = emrkdFndsDocItmCreationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmLastChgdByUsr</b>
     * </p>
     *
     * @param emrkdFndsDocItmLastChgdByUsr
     *            Last changed by
     */
    public void setEmrkdFndsDocItmLastChgdByUsr( @Nullable final String emrkdFndsDocItmLastChgdByUsr )
    {
        rememberChangedField("EmrkdFndsDocItmLastChgdByUsr", this.emrkdFndsDocItmLastChgdByUsr);
        this.emrkdFndsDocItmLastChgdByUsr = emrkdFndsDocItmLastChgdByUsr;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsDocItmLastChangeDate</b>
     * </p>
     *
     * @param emrkdFndsDocItmLastChangeDate
     *            Date of Last Change
     */
    public void setEmrkdFndsDocItmLastChangeDate( @Nullable final LocalDateTime emrkdFndsDocItmLastChangeDate )
    {
        rememberChangedField("EmrkdFndsDocItmLastChangeDate", this.emrkdFndsDocItmLastChangeDate);
        this.emrkdFndsDocItmLastChangeDate = emrkdFndsDocItmLastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsReferenceDocumentItem</b>
     * </p>
     *
     * @param emrkdFndsReferenceDocumentItem
     *            Reference line item
     */
    public void setEmrkdFndsReferenceDocumentItem( @Nullable final String emrkdFndsReferenceDocumentItem )
    {
        rememberChangedField("EmrkdFndsReferenceDocumentItem", this.emrkdFndsReferenceDocumentItem);
        this.emrkdFndsReferenceDocumentItem = emrkdFndsReferenceDocumentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>GLAccount</b>
     * </p>
     *
     * @param gLAccount
     *            G/L Account Number
     */
    public void setGLAccount( @Nullable final String gLAccount )
    {
        rememberChangedField("GLAccount", this.gLAccount);
        this.gLAccount = gLAccount;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementExternalID</b>
     * </p>
     *
     * @param wBSElementExternalID
     *            Work Breakdown Structure Element (WBS Element) Edited
     */
    public void setWBSElementExternalID( @Nullable final String wBSElementExternalID )
    {
        rememberChangedField("WBSElementExternalID", this.wBSElementExternalID);
        this.wBSElementExternalID = wBSElementExternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     *
     * @param fund
     *            Fund
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BudgetPeriod</b>
     * </p>
     *
     * @param budgetPeriod
     *            Budget Period
     */
    public void setBudgetPeriod( @Nullable final String budgetPeriod )
    {
        rememberChangedField("BudgetPeriod", this.budgetPeriod);
        this.budgetPeriod = budgetPeriod;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>CommitmentItem</b>
     * </p>
     *
     * @param commitmentItem
     *            Commitment Item
     */
    public void setCommitmentItem( @Nullable final String commitmentItem )
    {
        rememberChangedField("CommitmentItem", this.commitmentItem);
        this.commitmentItem = commitmentItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FundsCenter</b>
     * </p>
     *
     * @param fundsCenter
     *            Funds Center
     */
    public void setFundsCenter( @Nullable final String fundsCenter )
    {
        rememberChangedField("FundsCenter", this.fundsCenter);
        this.fundsCenter = fundsCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>FundedProgram</b>
     * </p>
     *
     * @param fundedProgram
     *            Funded Program
     */
    public void setFundedProgram( @Nullable final String fundedProgram )
    {
        rememberChangedField("FundedProgram", this.fundedProgram);
        this.fundedProgram = fundedProgram;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     *
     * @param grantID
     *            Grant
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Account Number of Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>DocumentItemText</b>
     * </p>
     *
     * @param documentItemText
     *            Item Text
     */
    public void setDocumentItemText( @Nullable final String documentItemText )
    {
        rememberChangedField("DocumentItemText", this.documentItemText);
        this.documentItemText = documentItemText;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>DueDate</b>
     * </p>
     *
     * @param dueDate
     *            Costs due on
     */
    public void setDueDate( @Nullable final LocalDateTime dueDate )
    {
        rememberChangedField("DueDate", this.dueDate);
        this.dueDate = dueDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsReservationDoc</b>
     * </p>
     *
     * @param prdcssrFundsReservationDoc
     *            Referenced Funds Reservation
     */
    public void setPrdcssrFundsReservationDoc( @Nullable final String prdcssrFundsReservationDoc )
    {
        rememberChangedField("PrdcssrFundsReservationDoc", this.prdcssrFundsReservationDoc);
        this.prdcssrFundsReservationDoc = prdcssrFundsReservationDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsReservationDocItem</b>
     * </p>
     *
     * @param prdcssrFundsReservationDocItem
     *            Item in Referenced Funds Reservation
     */
    public void setPrdcssrFundsReservationDocItem( @Nullable final String prdcssrFundsReservationDocItem )
    {
        rememberChangedField("PrdcssrFundsReservationDocItem", this.prdcssrFundsReservationDocItem);
        this.prdcssrFundsReservationDocItem = prdcssrFundsReservationDocItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsPreCmtmtDoc</b>
     * </p>
     *
     * @param prdcssrFundsPreCmtmtDoc
     *            Referenced Funds Precommitment
     */
    public void setPrdcssrFundsPreCmtmtDoc( @Nullable final String prdcssrFundsPreCmtmtDoc )
    {
        rememberChangedField("PrdcssrFundsPreCmtmtDoc", this.prdcssrFundsPreCmtmtDoc);
        this.prdcssrFundsPreCmtmtDoc = prdcssrFundsPreCmtmtDoc;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>PrdcssrFundsPreCmtmtDocItem</b>
     * </p>
     *
     * @param prdcssrFundsPreCmtmtDocItem
     *            Item in Referenced Funds Precommitment
     */
    public void setPrdcssrFundsPreCmtmtDocItem( @Nullable final String prdcssrFundsPreCmtmtDocItem )
    {
        rememberChangedField("PrdcssrFundsPreCmtmtDocItem", this.prdcssrFundsPreCmtmtDocItem);
        this.prdcssrFundsPreCmtmtDocItem = prdcssrFundsPreCmtmtDocItem;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmPrdcssrCompleted</b>
     * </p>
     *
     * @param emrkdFndsItmPrdcssrCompleted
     *            Used earmarked funds are set to "Completed".
     */
    public void setEmrkdFndsItmPrdcssrCompleted( @Nullable final Boolean emrkdFndsItmPrdcssrCompleted )
    {
        rememberChangedField("EmrkdFndsItmPrdcssrCompleted", this.emrkdFndsItmPrdcssrCompleted);
        this.emrkdFndsItmPrdcssrCompleted = emrkdFndsItmPrdcssrCompleted;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmCompletionDate</b>
     * </p>
     *
     * @param emrkdFndsItmCompletionDate
     *            Completion date
     */
    public void setEmrkdFndsItmCompletionDate( @Nullable final LocalDateTime emrkdFndsItmCompletionDate )
    {
        rememberChangedField("EmrkdFndsItmCompletionDate", this.emrkdFndsItmCompletionDate);
        this.emrkdFndsItmCompletionDate = emrkdFndsItmCompletionDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmIsCompleted</b>
     * </p>
     *
     * @param emrkdFndsItmIsCompleted
     *            Completion indicator for earmarked funds document item
     */
    public void setEmrkdFndsItmIsCompleted( @Nullable final Boolean emrkdFndsItmIsCompleted )
    {
        rememberChangedField("EmrkdFndsItmIsCompleted", this.emrkdFndsItmIsCompleted);
        this.emrkdFndsItmIsCompleted = emrkdFndsItmIsCompleted;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmManualEditBlock</b>
     * </p>
     *
     * @param emrkdFndsItmManualEditBlock
     *            Item Block to Prevent Manual Processing
     */
    public void setEmrkdFndsItmManualEditBlock( @Nullable final String emrkdFndsItmManualEditBlock )
    {
        rememberChangedField("EmrkdFndsItmManualEditBlock", this.emrkdFndsItmManualEditBlock);
        this.emrkdFndsItmManualEditBlock = emrkdFndsItmManualEditBlock;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmIsBlkdAgainstUsage</b>
     * </p>
     *
     * @param emrkdFndsItmIsBlkdAgainstUsage
     *            Blocking Indicator (Item)
     */
    public void setEmrkdFndsItmIsBlkdAgainstUsage( @Nullable final Boolean emrkdFndsItmIsBlkdAgainstUsage )
    {
        rememberChangedField("EmrkdFndsItmIsBlkdAgainstUsage", this.emrkdFndsItmIsBlkdAgainstUsage);
        this.emrkdFndsItmIsBlkdAgainstUsage = emrkdFndsItmIsBlkdAgainstUsage;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsItmIsApproved</b>
     * </p>
     *
     * @param emrkdFndsItmIsApproved
     *            Earmarked Funds Item Is Approved
     */
    public void setEmrkdFndsItmIsApproved( @Nullable final Boolean emrkdFndsItmIsApproved )
    {
        rememberChangedField("EmrkdFndsItmIsApproved", this.emrkdFndsItmIsApproved);
        this.emrkdFndsItmIsApproved = emrkdFndsItmIsApproved;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsAcctAssgmtChangeable</b>
     * </p>
     *
     * @param emrkdFndsAcctAssgmtChangeable
     *            Account Assignment Can Be Changed in Follow-On Document
     */
    public void setEmrkdFndsAcctAssgmtChangeable( @Nullable final Boolean emrkdFndsAcctAssgmtChangeable )
    {
        rememberChangedField("EmrkdFndsAcctAssgmtChangeable", this.emrkdFndsAcctAssgmtChangeable);
        this.emrkdFndsAcctAssgmtChangeable = emrkdFndsAcctAssgmtChangeable;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsAmountInTransCrcy</b>
     * </p>
     *
     * @param emrkdFndsAmountInTransCrcy
     *            Total reserved amount in transaction currency
     */
    public void setEmrkdFndsAmountInTransCrcy( @Nullable final BigDecimal emrkdFndsAmountInTransCrcy )
    {
        rememberChangedField("EmrkdFndsAmountInTransCrcy", this.emrkdFndsAmountInTransCrcy);
        this.emrkdFndsAmountInTransCrcy = emrkdFndsAmountInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsOpenAmtInTransCrcy</b>
     * </p>
     *
     * @param emrkdFndsOpenAmtInTransCrcy
     *            Open Amount in Transaction Currency
     */
    public void setEmrkdFndsOpenAmtInTransCrcy( @Nullable final BigDecimal emrkdFndsOpenAmtInTransCrcy )
    {
        rememberChangedField("EmrkdFndsOpenAmtInTransCrcy", this.emrkdFndsOpenAmtInTransCrcy);
        this.emrkdFndsOpenAmtInTransCrcy = emrkdFndsOpenAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsCnsmdAmtInTransCrcy</b>
     * </p>
     *
     * @param emrkdFndsCnsmdAmtInTransCrcy
     *            Funds reservation amount reduced
     */
    public void setEmrkdFndsCnsmdAmtInTransCrcy( @Nullable final BigDecimal emrkdFndsCnsmdAmtInTransCrcy )
    {
        rememberChangedField("EmrkdFndsCnsmdAmtInTransCrcy", this.emrkdFndsCnsmdAmtInTransCrcy);
        this.emrkdFndsCnsmdAmtInTransCrcy = emrkdFndsCnsmdAmtInTransCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsAmountInCCCrcy</b>
     * </p>
     *
     * @param emrkdFndsAmountInCCCrcy
     *            Total Reserved Amount in Local Currency
     */
    public void setEmrkdFndsAmountInCCCrcy( @Nullable final BigDecimal emrkdFndsAmountInCCCrcy )
    {
        rememberChangedField("EmrkdFndsAmountInCCCrcy", this.emrkdFndsAmountInCCCrcy);
        this.emrkdFndsAmountInCCCrcy = emrkdFndsAmountInCCCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsOpenAmtInCCCrcy</b>
     * </p>
     *
     * @param emrkdFndsOpenAmtInCCCrcy
     *            Open Amount in Local Currency
     */
    public void setEmrkdFndsOpenAmtInCCCrcy( @Nullable final BigDecimal emrkdFndsOpenAmtInCCCrcy )
    {
        rememberChangedField("EmrkdFndsOpenAmtInCCCrcy", this.emrkdFndsOpenAmtInCCCrcy);
        this.emrkdFndsOpenAmtInCCCrcy = emrkdFndsOpenAmtInCCCrcy;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>EmrkdFndsCnsmdAmtInCCCrcy</b>
     * </p>
     *
     * @param emrkdFndsCnsmdAmtInCCCrcy
     *            Funds reservation amount reduced
     */
    public void setEmrkdFndsCnsmdAmtInCCCrcy( @Nullable final BigDecimal emrkdFndsCnsmdAmtInCCCrcy )
    {
        rememberChangedField("EmrkdFndsCnsmdAmtInCCCrcy", this.emrkdFndsCnsmdAmtInCCCrcy);
        this.emrkdFndsCnsmdAmtInCCCrcy = emrkdFndsCnsmdAmtInCCCrcy;
    }

    @Override
    protected String getEntityCollection()
    {
        return "EarmarkedFundsDocumentItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        result.put("EarmarkedFundsDocumentItem", getEarmarkedFundsDocumentItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EarmarkedFundsDocument", getEarmarkedFundsDocument());
        values.put("EarmarkedFundsDocumentItem", getEarmarkedFundsDocumentItem());
        values.put("CompanyCode", getCompanyCode());
        values.put("TransactionCurrency", getTransactionCurrency());
        values.put("CompanyCodeCurrency", getCompanyCodeCurrency());
        values.put("PostingDate", getPostingDate());
        values.put("EmrkdFndsDocItmCreatedByUser", getEmrkdFndsDocItmCreatedByUser());
        values.put("EmrkdFndsDocItmCreationDate", getEmrkdFndsDocItmCreationDate());
        values.put("EmrkdFndsDocItmLastChgdByUsr", getEmrkdFndsDocItmLastChgdByUsr());
        values.put("EmrkdFndsDocItmLastChangeDate", getEmrkdFndsDocItmLastChangeDate());
        values.put("EmrkdFndsReferenceDocumentItem", getEmrkdFndsReferenceDocumentItem());
        values.put("GLAccount", getGLAccount());
        values.put("CostCenter", getCostCenter());
        values.put("WBSElementExternalID", getWBSElementExternalID());
        values.put("Fund", getFund());
        values.put("BudgetPeriod", getBudgetPeriod());
        values.put("CommitmentItem", getCommitmentItem());
        values.put("FundsCenter", getFundsCenter());
        values.put("FundedProgram", getFundedProgram());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("GrantID", getGrantID());
        values.put("Supplier", getSupplier());
        values.put("DocumentItemText", getDocumentItemText());
        values.put("DueDate", getDueDate());
        values.put("ProfitCenter", getProfitCenter());
        values.put("PrdcssrFundsReservationDoc", getPrdcssrFundsReservationDoc());
        values.put("PrdcssrFundsReservationDocItem", getPrdcssrFundsReservationDocItem());
        values.put("PrdcssrFundsPreCmtmtDoc", getPrdcssrFundsPreCmtmtDoc());
        values.put("PrdcssrFundsPreCmtmtDocItem", getPrdcssrFundsPreCmtmtDocItem());
        values.put("EmrkdFndsItmPrdcssrCompleted", getEmrkdFndsItmPrdcssrCompleted());
        values.put("EmrkdFndsItmCompletionDate", getEmrkdFndsItmCompletionDate());
        values.put("EmrkdFndsItmIsCompleted", getEmrkdFndsItmIsCompleted());
        values.put("EmrkdFndsItmManualEditBlock", getEmrkdFndsItmManualEditBlock());
        values.put("EmrkdFndsItmIsBlkdAgainstUsage", getEmrkdFndsItmIsBlkdAgainstUsage());
        values.put("EmrkdFndsItmIsApproved", getEmrkdFndsItmIsApproved());
        values.put("EmrkdFndsAcctAssgmtChangeable", getEmrkdFndsAcctAssgmtChangeable());
        values.put("EmrkdFndsAmountInTransCrcy", getEmrkdFndsAmountInTransCrcy());
        values.put("EmrkdFndsOpenAmtInTransCrcy", getEmrkdFndsOpenAmtInTransCrcy());
        values.put("EmrkdFndsCnsmdAmtInTransCrcy", getEmrkdFndsCnsmdAmtInTransCrcy());
        values.put("EmrkdFndsAmountInCCCrcy", getEmrkdFndsAmountInCCCrcy());
        values.put("EmrkdFndsOpenAmtInCCCrcy", getEmrkdFndsOpenAmtInCCCrcy());
        values.put("EmrkdFndsCnsmdAmtInCCCrcy", getEmrkdFndsCnsmdAmtInCCCrcy());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EarmarkedFundsDocument") ) {
                final Object value = values.remove("EarmarkedFundsDocument");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocument())) ) {
                    setEarmarkedFundsDocument(((String) value));
                }
            }
            if( values.containsKey("EarmarkedFundsDocumentItem") ) {
                final Object value = values.remove("EarmarkedFundsDocumentItem");
                if( (value == null) || (!value.equals(getEarmarkedFundsDocumentItem())) ) {
                    setEarmarkedFundsDocumentItem(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrency") ) {
                final Object value = values.remove("TransactionCurrency");
                if( (value == null) || (!value.equals(getTransactionCurrency())) ) {
                    setTransactionCurrency(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeCurrency") ) {
                final Object value = values.remove("CompanyCodeCurrency");
                if( (value == null) || (!value.equals(getCompanyCodeCurrency())) ) {
                    setCompanyCodeCurrency(((String) value));
                }
            }
            if( values.containsKey("PostingDate") ) {
                final Object value = values.remove("PostingDate");
                if( (value == null) || (!value.equals(getPostingDate())) ) {
                    setPostingDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocItmCreatedByUser") ) {
                final Object value = values.remove("EmrkdFndsDocItmCreatedByUser");
                if( (value == null) || (!value.equals(getEmrkdFndsDocItmCreatedByUser())) ) {
                    setEmrkdFndsDocItmCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocItmCreationDate") ) {
                final Object value = values.remove("EmrkdFndsDocItmCreationDate");
                if( (value == null) || (!value.equals(getEmrkdFndsDocItmCreationDate())) ) {
                    setEmrkdFndsDocItmCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocItmLastChgdByUsr") ) {
                final Object value = values.remove("EmrkdFndsDocItmLastChgdByUsr");
                if( (value == null) || (!value.equals(getEmrkdFndsDocItmLastChgdByUsr())) ) {
                    setEmrkdFndsDocItmLastChgdByUsr(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsDocItmLastChangeDate") ) {
                final Object value = values.remove("EmrkdFndsDocItmLastChangeDate");
                if( (value == null) || (!value.equals(getEmrkdFndsDocItmLastChangeDate())) ) {
                    setEmrkdFndsDocItmLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EmrkdFndsReferenceDocumentItem") ) {
                final Object value = values.remove("EmrkdFndsReferenceDocumentItem");
                if( (value == null) || (!value.equals(getEmrkdFndsReferenceDocumentItem())) ) {
                    setEmrkdFndsReferenceDocumentItem(((String) value));
                }
            }
            if( values.containsKey("GLAccount") ) {
                final Object value = values.remove("GLAccount");
                if( (value == null) || (!value.equals(getGLAccount())) ) {
                    setGLAccount(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("WBSElementExternalID") ) {
                final Object value = values.remove("WBSElementExternalID");
                if( (value == null) || (!value.equals(getWBSElementExternalID())) ) {
                    setWBSElementExternalID(((String) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("BudgetPeriod") ) {
                final Object value = values.remove("BudgetPeriod");
                if( (value == null) || (!value.equals(getBudgetPeriod())) ) {
                    setBudgetPeriod(((String) value));
                }
            }
            if( values.containsKey("CommitmentItem") ) {
                final Object value = values.remove("CommitmentItem");
                if( (value == null) || (!value.equals(getCommitmentItem())) ) {
                    setCommitmentItem(((String) value));
                }
            }
            if( values.containsKey("FundsCenter") ) {
                final Object value = values.remove("FundsCenter");
                if( (value == null) || (!value.equals(getFundsCenter())) ) {
                    setFundsCenter(((String) value));
                }
            }
            if( values.containsKey("FundedProgram") ) {
                final Object value = values.remove("FundedProgram");
                if( (value == null) || (!value.equals(getFundedProgram())) ) {
                    setFundedProgram(((String) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("DocumentItemText") ) {
                final Object value = values.remove("DocumentItemText");
                if( (value == null) || (!value.equals(getDocumentItemText())) ) {
                    setDocumentItemText(((String) value));
                }
            }
            if( values.containsKey("DueDate") ) {
                final Object value = values.remove("DueDate");
                if( (value == null) || (!value.equals(getDueDate())) ) {
                    setDueDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("PrdcssrFundsReservationDoc") ) {
                final Object value = values.remove("PrdcssrFundsReservationDoc");
                if( (value == null) || (!value.equals(getPrdcssrFundsReservationDoc())) ) {
                    setPrdcssrFundsReservationDoc(((String) value));
                }
            }
            if( values.containsKey("PrdcssrFundsReservationDocItem") ) {
                final Object value = values.remove("PrdcssrFundsReservationDocItem");
                if( (value == null) || (!value.equals(getPrdcssrFundsReservationDocItem())) ) {
                    setPrdcssrFundsReservationDocItem(((String) value));
                }
            }
            if( values.containsKey("PrdcssrFundsPreCmtmtDoc") ) {
                final Object value = values.remove("PrdcssrFundsPreCmtmtDoc");
                if( (value == null) || (!value.equals(getPrdcssrFundsPreCmtmtDoc())) ) {
                    setPrdcssrFundsPreCmtmtDoc(((String) value));
                }
            }
            if( values.containsKey("PrdcssrFundsPreCmtmtDocItem") ) {
                final Object value = values.remove("PrdcssrFundsPreCmtmtDocItem");
                if( (value == null) || (!value.equals(getPrdcssrFundsPreCmtmtDocItem())) ) {
                    setPrdcssrFundsPreCmtmtDocItem(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsItmPrdcssrCompleted") ) {
                final Object value = values.remove("EmrkdFndsItmPrdcssrCompleted");
                if( (value == null) || (!value.equals(getEmrkdFndsItmPrdcssrCompleted())) ) {
                    setEmrkdFndsItmPrdcssrCompleted(((Boolean) value));
                }
            }
            if( values.containsKey("EmrkdFndsItmCompletionDate") ) {
                final Object value = values.remove("EmrkdFndsItmCompletionDate");
                if( (value == null) || (!value.equals(getEmrkdFndsItmCompletionDate())) ) {
                    setEmrkdFndsItmCompletionDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("EmrkdFndsItmIsCompleted") ) {
                final Object value = values.remove("EmrkdFndsItmIsCompleted");
                if( (value == null) || (!value.equals(getEmrkdFndsItmIsCompleted())) ) {
                    setEmrkdFndsItmIsCompleted(((Boolean) value));
                }
            }
            if( values.containsKey("EmrkdFndsItmManualEditBlock") ) {
                final Object value = values.remove("EmrkdFndsItmManualEditBlock");
                if( (value == null) || (!value.equals(getEmrkdFndsItmManualEditBlock())) ) {
                    setEmrkdFndsItmManualEditBlock(((String) value));
                }
            }
            if( values.containsKey("EmrkdFndsItmIsBlkdAgainstUsage") ) {
                final Object value = values.remove("EmrkdFndsItmIsBlkdAgainstUsage");
                if( (value == null) || (!value.equals(getEmrkdFndsItmIsBlkdAgainstUsage())) ) {
                    setEmrkdFndsItmIsBlkdAgainstUsage(((Boolean) value));
                }
            }
            if( values.containsKey("EmrkdFndsItmIsApproved") ) {
                final Object value = values.remove("EmrkdFndsItmIsApproved");
                if( (value == null) || (!value.equals(getEmrkdFndsItmIsApproved())) ) {
                    setEmrkdFndsItmIsApproved(((Boolean) value));
                }
            }
            if( values.containsKey("EmrkdFndsAcctAssgmtChangeable") ) {
                final Object value = values.remove("EmrkdFndsAcctAssgmtChangeable");
                if( (value == null) || (!value.equals(getEmrkdFndsAcctAssgmtChangeable())) ) {
                    setEmrkdFndsAcctAssgmtChangeable(((Boolean) value));
                }
            }
            if( values.containsKey("EmrkdFndsAmountInTransCrcy") ) {
                final Object value = values.remove("EmrkdFndsAmountInTransCrcy");
                if( (value == null) || (!value.equals(getEmrkdFndsAmountInTransCrcy())) ) {
                    setEmrkdFndsAmountInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EmrkdFndsOpenAmtInTransCrcy") ) {
                final Object value = values.remove("EmrkdFndsOpenAmtInTransCrcy");
                if( (value == null) || (!value.equals(getEmrkdFndsOpenAmtInTransCrcy())) ) {
                    setEmrkdFndsOpenAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EmrkdFndsCnsmdAmtInTransCrcy") ) {
                final Object value = values.remove("EmrkdFndsCnsmdAmtInTransCrcy");
                if( (value == null) || (!value.equals(getEmrkdFndsCnsmdAmtInTransCrcy())) ) {
                    setEmrkdFndsCnsmdAmtInTransCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EmrkdFndsAmountInCCCrcy") ) {
                final Object value = values.remove("EmrkdFndsAmountInCCCrcy");
                if( (value == null) || (!value.equals(getEmrkdFndsAmountInCCCrcy())) ) {
                    setEmrkdFndsAmountInCCCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EmrkdFndsOpenAmtInCCCrcy") ) {
                final Object value = values.remove("EmrkdFndsOpenAmtInCCCrcy");
                if( (value == null) || (!value.equals(getEmrkdFndsOpenAmtInCCCrcy())) ) {
                    setEmrkdFndsOpenAmtInCCCrcy(((BigDecimal) value));
                }
            }
            if( values.containsKey("EmrkdFndsCnsmdAmtInCCCrcy") ) {
                final Object value = values.remove("EmrkdFndsCnsmdAmtInCCCrcy");
                if( (value == null) || (!value.equals(getEmrkdFndsCnsmdAmtInCCCrcy())) ) {
                    setEmrkdFndsCnsmdAmtInCCCrcy(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EarmarkedFundsDocument") ) {
                final Object value = (values).remove("to_EarmarkedFundsDocument");
                if( value instanceof Map ) {
                    if( toEarmarkedFundsDocument == null ) {
                        toEarmarkedFundsDocument = new EarmarkedFundsDocument();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEarmarkedFundsDocument.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> EarmarkedFundsDocumentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new EarmarkedFundsDocumentItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EarmarkedFundsDocumentItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EarmarkedFundsDocumentItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEarmarkedFundsDocument != null ) {
            (values).put("to_EarmarkedFundsDocument", toEarmarkedFundsDocument);
        }
        return values;
    }

    /**
     * Fetches the <b>EarmarkedFundsDocument</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EarmarkedFundsDocument</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EarmarkedFundsDocument</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EarmarkedFundsDocument fetchEarmarkedFundsDocument()
    {
        return fetchFieldAsSingle("to_EarmarkedFundsDocument", EarmarkedFundsDocument.class);
    }

    /**
     * Retrieval of associated <b>EarmarkedFundsDocument</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EarmarkedFundsDocument</b>.
     * <p>
     * If the navigation property <b>to_EarmarkedFundsDocument</b> of a queried <b>EarmarkedFundsDocumentItem</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EarmarkedFundsDocument</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EarmarkedFundsDocument getEarmarkedFundsDocumentOrFetch()
    {
        if( toEarmarkedFundsDocument == null ) {
            toEarmarkedFundsDocument = fetchEarmarkedFundsDocument();
        }
        return toEarmarkedFundsDocument;
    }

    /**
     * Retrieval of associated <b>EarmarkedFundsDocument</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EarmarkedFundsDocument</b>.
     * <p>
     * If the navigation property for an entity <b>EarmarkedFundsDocumentItem</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EarmarkedFundsDocument</b> is already loaded, the result
     *         will contain the <b>EarmarkedFundsDocument</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EarmarkedFundsDocument> getEarmarkedFundsDocumentIfPresent()
    {
        return Option.of(toEarmarkedFundsDocument);
    }

    /**
     * Overwrites the associated <b>EarmarkedFundsDocument</b> entity for the loaded navigation property
     * <b>to_EarmarkedFundsDocument</b>.
     *
     * @param value
     *            New <b>EarmarkedFundsDocument</b> entity.
     */
    public void setEarmarkedFundsDocument( final EarmarkedFundsDocument value )
    {
        toEarmarkedFundsDocument = value;
    }

    /**
     * Helper class to allow for fluent creation of EarmarkedFundsDocumentItem instances.
     *
     */
    public final static class EarmarkedFundsDocumentItemBuilder
    {

        private EarmarkedFundsDocument toEarmarkedFundsDocument;
        private String earmarkedFundsDocument = null;

        private EarmarkedFundsDocumentItem.EarmarkedFundsDocumentItemBuilder toEarmarkedFundsDocument(
            final EarmarkedFundsDocument value )
        {
            toEarmarkedFundsDocument = value;
            return this;
        }

        /**
         * Navigation property <b>to_EarmarkedFundsDocument</b> for <b>EarmarkedFundsDocumentItem</b> to single
         * <b>EarmarkedFundsDocument</b>.
         *
         * @param value
         *            The EarmarkedFundsDocument to build this EarmarkedFundsDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EarmarkedFundsDocumentItem.EarmarkedFundsDocumentItemBuilder earmarkedFundsDocument(
            final EarmarkedFundsDocument value )
        {
            return toEarmarkedFundsDocument(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 10
         * <p>
         * Original property name from the Odata EDM: <b>EarmarkedFundsDocument</b>
         * </p>
         *
         * @param value
         *            The earmarkedFundsDocument to build this EarmarkedFundsDocumentItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EarmarkedFundsDocumentItem.EarmarkedFundsDocumentItemBuilder earmarkedFundsDocument( final String value )
        {
            earmarkedFundsDocument = value;
            return this;
        }

    }

}
