/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchFluentHelperBasic;

/**
 * Default implementation of the {@link EarmarkedFundsDocumentServiceBatch} interface exposed in the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService
 * EarmarkedFundsDocumentService}, allowing you to create multiple changesets and finally execute the batch request.
 *
 */
public class DefaultEarmarkedFundsDocumentServiceBatch
    extends
    BatchFluentHelperBasic<EarmarkedFundsDocumentServiceBatch, EarmarkedFundsDocumentServiceBatchChangeSet>
    implements
    EarmarkedFundsDocumentServiceBatch
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService service;
    @Nonnull
    private final String servicePath;

    /**
     * Creates a new instance of this DefaultEarmarkedFundsDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEarmarkedFundsDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService service )
    {
        this(
            service,
            com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService.DEFAULT_SERVICE_PATH);
    }

    /**
     * Creates a new instance of this DefaultEarmarkedFundsDocumentServiceBatch.
     *
     * @param service
     *            The service to execute all operations in this changeset on.
     * @param servicePath
     *            The custom service path to operate on.
     */
    @SuppressWarnings( "deprecation" )
    public DefaultEarmarkedFundsDocumentServiceBatch(
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService service,
        @Nonnull final String servicePath )
    {
        this.service = service;
        this.servicePath = servicePath;
    }

    @Nonnull
    @Override
    protected String getServicePathForBatchRequest()
    {
        return servicePath;
    }

    @Nonnull
    @Override
    protected DefaultEarmarkedFundsDocumentServiceBatch getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EarmarkedFundsDocumentServiceBatchChangeSet beginChangeSet()
    {
        return new DefaultEarmarkedFundsDocumentServiceBatchChangeSet(this, service);
    }

}
