/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem;

/**
 * Implementation of the {@link EarmarkedFundsDocumentServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService
 * EarmarkedFundsDocumentService}.
 *
 */
public class DefaultEarmarkedFundsDocumentServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<EarmarkedFundsDocumentServiceBatch, EarmarkedFundsDocumentServiceBatchChangeSet>
    implements
    EarmarkedFundsDocumentServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService service;

    @SuppressWarnings( "deprecation" )
    DefaultEarmarkedFundsDocumentServiceBatchChangeSet(
        @Nonnull final DefaultEarmarkedFundsDocumentServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultEarmarkedFundsDocumentServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EarmarkedFundsDocumentServiceBatchChangeSet createEarmarkedFundsDocument(
        @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument )
    {
        return addRequestCreate(service::createEarmarkedFundsDocument, earmarkedFundsDocument);
    }

    @Nonnull
    @Override
    public EarmarkedFundsDocumentServiceBatchChangeSet updateEarmarkedFundsDocument(
        @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument )
    {
        return addRequestUpdate(service::updateEarmarkedFundsDocument, earmarkedFundsDocument);
    }

    @Nonnull
    @Override
    public EarmarkedFundsDocumentServiceBatchChangeSet updateEarmarkedFundsDocumentItem(
        @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem )
    {
        return addRequestUpdate(service::updateEarmarkedFundsDocumentItem, earmarkedFundsDocumentItem);
    }

    @Nonnull
    @Override
    public EarmarkedFundsDocumentServiceBatchChangeSet deleteEarmarkedFundsDocumentItem(
        @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem )
    {
        return addRequestDelete(service::deleteEarmarkedFundsDocumentItem, earmarkedFundsDocumentItem);
    }

}
