/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchChangeSet;
import com.sap.cloud.sdk.datamodel.odata.helper.batch.FluentHelperBatchEndChangeSet;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem;

/**
 * This interface enables you to combine multiple operations into one change set. For further information have a look
 * into the {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EarmarkedFundsDocumentService
 * EarmarkedFundsDocumentService}.
 *
 */
public interface EarmarkedFundsDocumentServiceBatchChangeSet
    extends
    FluentHelperBatchChangeSet<EarmarkedFundsDocumentServiceBatchChangeSet>,
    FluentHelperBatchEndChangeSet<EarmarkedFundsDocumentServiceBatch>
{

    /**
     * Create a new
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     * EarmarkedFundsDocument} entity and save it to the S/4HANA system.
     *
     * @param earmarkedFundsDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *            EarmarkedFundsDocument} entity object that will be created in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentServiceBatchChangeSet
        createEarmarkedFundsDocument( @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     * EarmarkedFundsDocument} entity and save it to the S/4HANA system.
     *
     * @param earmarkedFundsDocument
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
     *            EarmarkedFundsDocument} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentServiceBatchChangeSet
        updateEarmarkedFundsDocument( @Nonnull final EarmarkedFundsDocument earmarkedFundsDocument );

    /**
     * Update an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     * EarmarkedFundsDocumentItem} entity and save it to the S/4HANA system.
     *
     * @param earmarkedFundsDocumentItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *            EarmarkedFundsDocumentItem} entity object that will be updated in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentServiceBatchChangeSet
        updateEarmarkedFundsDocumentItem( @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem );

    /**
     * Deletes an existing
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     * EarmarkedFundsDocumentItem} entity in the S/4HANA system.
     *
     * @param earmarkedFundsDocumentItem
     *            {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
     *            EarmarkedFundsDocumentItem} entity object that will be deleted in the S/4HANA system.
     * @return This fluent helper to continue adding operations to the change set. To finalize the current change set
     *         call {@link #endChangeSet endChangeSet} on the returned fluent helper object.
     */
    @Nonnull
    EarmarkedFundsDocumentServiceBatchChangeSet
        deleteEarmarkedFundsDocumentItem( @Nonnull final EarmarkedFundsDocumentItem earmarkedFundsDocumentItem );

}
