/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem
 * EarmarkedFundsDocumentItem}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.field.EarmarkedFundsDocumentItemField
 * EarmarkedFundsDocumentItemField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.link.EarmarkedFundsDocumentItemLink
 * EarmarkedFundsDocumentItemLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EARMARKED_FUNDS_DOCUMENT
 * EARMARKED_FUNDS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EARMARKED_FUNDS_DOCUMENT_ITEM
 * EARMARKED_FUNDS_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_DOC_ITM_CREATED_BY_USER
 * EMRKD_FNDS_DOC_ITM_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_DOC_ITM_CREATION_DATE
 * EMRKD_FNDS_DOC_ITM_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_DOC_ITM_LAST_CHGD_BY_USR
 * EMRKD_FNDS_DOC_ITM_LAST_CHGD_BY_USR}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_DOC_ITM_LAST_CHANGE_DATE
 * EMRKD_FNDS_DOC_ITM_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_REFERENCE_DOCUMENT_ITEM
 * EMRKD_FNDS_REFERENCE_DOCUMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#GL_ACCOUNT
 * GL_ACCOUNT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#WBS_ELEMENT_EXTERNAL_ID
 * WBS_ELEMENT_EXTERNAL_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#FUND
 * FUND}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#BUDGET_PERIOD
 * BUDGET_PERIOD}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#COMMITMENT_ITEM
 * COMMITMENT_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#FUNDS_CENTER
 * FUNDS_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#FUNDED_PROGRAM
 * FUNDED_PROGRAM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#FUNCTIONAL_AREA
 * FUNCTIONAL_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#GRANT_ID
 * GRANT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#SUPPLIER
 * SUPPLIER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#DOCUMENT_ITEM_TEXT
 * DOCUMENT_ITEM_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#DUE_DATE
 * DUE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#PROFIT_CENTER
 * PROFIT_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#PRDCSSR_FUNDS_RESERVATION_DOC
 * PRDCSSR_FUNDS_RESERVATION_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#PRDCSSR_FUNDS_RESERVATION_DOC_ITEM
 * PRDCSSR_FUNDS_RESERVATION_DOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#PRDCSSR_FUNDS_PRE_CMTMT_DOC
 * PRDCSSR_FUNDS_PRE_CMTMT_DOC}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#PRDCSSR_FUNDS_PRE_CMTMT_DOC_ITEM
 * PRDCSSR_FUNDS_PRE_CMTMT_DOC_ITEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_ITM_PRDCSSR_COMPLETED
 * EMRKD_FNDS_ITM_PRDCSSR_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_ITM_COMPLETION_DATE
 * EMRKD_FNDS_ITM_COMPLETION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_ITM_IS_COMPLETED
 * EMRKD_FNDS_ITM_IS_COMPLETED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_ITM_MANUAL_EDIT_BLOCK
 * EMRKD_FNDS_ITM_MANUAL_EDIT_BLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_ITM_IS_BLKD_AGAINST_USAGE
 * EMRKD_FNDS_ITM_IS_BLKD_AGAINST_USAGE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_ITM_IS_APPROVED
 * EMRKD_FNDS_ITM_IS_APPROVED}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_ACCT_ASSGMT_CHANGEABLE
 * EMRKD_FNDS_ACCT_ASSGMT_CHANGEABLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_AMOUNT_IN_TRANS_CRCY
 * EMRKD_FNDS_AMOUNT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_OPEN_AMT_IN_TRANS_CRCY
 * EMRKD_FNDS_OPEN_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_CNSMD_AMT_IN_TRANS_CRCY
 * EMRKD_FNDS_CNSMD_AMT_IN_TRANS_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_AMOUNT_IN_CC_CRCY
 * EMRKD_FNDS_AMOUNT_IN_CC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_OPEN_AMT_IN_CC_CRCY
 * EMRKD_FNDS_OPEN_AMT_IN_CC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#EMRKD_FNDS_CNSMD_AMT_IN_CC_CRCY
 * EMRKD_FNDS_CNSMD_AMT_IN_CC_CRCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocumentItem#TO_EARMARKED_FUNDS_DOCUMENT
 * TO_EARMARKED_FUNDS_DOCUMENT}</li>
 * </ul>
 *
 */
public interface EarmarkedFundsDocumentItemSelectable extends EntitySelectable<EarmarkedFundsDocumentItem>
{

}
