/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument
 * EarmarkedFundsDocument}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.field.EarmarkedFundsDocumentField
 * EarmarkedFundsDocumentField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.link.EarmarkedFundsDocumentLink
 * EarmarkedFundsDocumentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EARMARKED_FUNDS_DOCUMENT
 * EARMARKED_FUNDS_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_EXT_DOCUMENT_NUMBER
 * EMRKD_FNDS_EXT_DOCUMENT_NUMBER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_INTEGRATION_SCENARIO
 * EMRKD_FNDS_INTEGRATION_SCENARIO}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_INTEG_SCENARIO_VARIANT
 * EMRKD_FNDS_INTEG_SCENARIO_VARIANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EARMARKED_FUNDS_DOCUMENT_CATEGORY
 * EARMARKED_FUNDS_DOCUMENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EARMARKED_FUNDS_DOCUMENT_TYPE
 * EARMARKED_FUNDS_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#TRANSACTION_CURRENCY
 * TRANSACTION_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#COMPANY_CODE_CURRENCY
 * COMPANY_CODE_CURRENCY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EARMARKED_FUNDS_DOC_REFERENCE
 * EARMARKED_FUNDS_DOC_REFERENCE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EARMARKED_FUNDS_HEADER_TEXT
 * EARMARKED_FUNDS_HEADER_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#POSTING_DATE
 * POSTING_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#DOCUMENT_DATE
 * DOCUMENT_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EXCHANGE_RATE_DATE
 * EXCHANGE_RATE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#ABSOLUTE_EXCHANGE_RATE
 * ABSOLUTE_EXCHANGE_RATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EXCH_RATE_IS_INDIRECT_QUOTATION
 * EXCH_RATE_IS_INDIRECT_QUOTATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_DOC_CREATED_BY_USER
 * EMRKD_FNDS_DOC_CREATED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_DOC_CREATION_DATE
 * EMRKD_FNDS_DOC_CREATION_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_DOC_LAST_CHANGED_BY_USER
 * EMRKD_FNDS_DOC_LAST_CHANGED_BY_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_DOC_LAST_CHANGE_DATE
 * EMRKD_FNDS_DOC_LAST_CHANGE_DATE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EMRKD_FNDS_DOC_LAST_CHANGE_DATE_TIME
 * EMRKD_FNDS_DOC_LAST_CHANGE_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#REFERENCE_DOCUMENT_TYPE
 * REFERENCE_DOCUMENT_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#REFERENCE_DOCUMENT
 * REFERENCE_DOCUMENT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#REFERENCE_DOCUMENT_CONTEXT
 * REFERENCE_DOCUMENT_CONTEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#REFERENCE_DOCUMENT_LOGICAL_SYSTEM
 * REFERENCE_DOCUMENT_LOGICAL_SYSTEM}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#EARMARKED_FUNDS_MANUAL_EDIT_BLOCK
 * EARMARKED_FUNDS_MANUAL_EDIT_BLOCK}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.earmarkedfundsdocument.EarmarkedFundsDocument#TO_EARMARKED_FUNDS_DOCUMENT_ITEM
 * TO_EARMARKED_FUNDS_DOCUMENT_ITEM}</li>
 * </ul>
 *
 */
public interface EarmarkedFundsDocumentSelectable extends EntitySelectable<EarmarkedFundsDocument>
{

}
