/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmMediaEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.AttachmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.AttachmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Attachment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Attachment</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Attachment extends VdmMediaEntity<Attachment>
{

    /**
     * Selector for all available fields of Attachment.
     *
     */
    public final static AttachmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentDocumentUUID</b>
     * </p>
     *
     * @return Attachment Global Identification
     */
    @Key
    @SerializedName( "AttachmentDocumentUUID" )
    @JsonProperty( "AttachmentDocumentUUID" )
    @Nullable
    @ODataField( odataName = "AttachmentDocumentUUID" )
    private UUID attachmentDocumentUUID;
    /**
     * Use with available fluent helpers to apply the <b>AttachmentDocumentUUID</b> field to query operations.
     *
     */
    public final static AttachmentField<UUID> ATTACHMENT_DOCUMENT_UUID =
        new AttachmentField<UUID>("AttachmentDocumentUUID");
    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     *
     * @return Attachment MIME Type
     */
    @SerializedName( "MimeType" )
    @JsonProperty( "MimeType" )
    @Nullable
    @ODataField( odataName = "MimeType" )
    private String mimeType;
    /**
     * Use with available fluent helpers to apply the <b>MimeType</b> field to query operations.
     *
     */
    public final static AttachmentField<String> MIME_TYPE = new AttachmentField<String>("MimeType");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @return Attachment File Name
     */
    @SerializedName( "FileName" )
    @JsonProperty( "FileName" )
    @Nullable
    @ODataField( odataName = "FileName" )
    private String fileName;
    /**
     * Use with available fluent helpers to apply the <b>FileName</b> field to query operations.
     *
     */
    public final static AttachmentField<String> FILE_NAME = new AttachmentField<String>("FileName");

    @Nonnull
    @Override
    public Class<Attachment> getType()
    {
        return Attachment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>AttachmentDocumentUUID</b>
     * </p>
     *
     * @param attachmentDocumentUUID
     *            Attachment Global Identification
     */
    public void setAttachmentDocumentUUID( @Nullable final UUID attachmentDocumentUUID )
    {
        rememberChangedField("AttachmentDocumentUUID", this.attachmentDocumentUUID);
        this.attachmentDocumentUUID = attachmentDocumentUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 128
     * <p>
     * Original property name from the Odata EDM: <b>MimeType</b>
     * </p>
     *
     * @param mimeType
     *            Attachment MIME Type
     */
    public void setMimeType( @Nullable final String mimeType )
    {
        rememberChangedField("MimeType", this.mimeType);
        this.mimeType = mimeType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>FileName</b>
     * </p>
     *
     * @param fileName
     *            Attachment File Name
     */
    public void setFileName( @Nullable final String fileName )
    {
        rememberChangedField("FileName", this.fileName);
        this.fileName = fileName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Attachment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AttachmentDocumentUUID", getAttachmentDocumentUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AttachmentDocumentUUID", getAttachmentDocumentUUID());
        values.put("MimeType", getMimeType());
        values.put("FileName", getFileName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AttachmentDocumentUUID") ) {
                final Object value = values.remove("AttachmentDocumentUUID");
                if( (value == null) || (!value.equals(getAttachmentDocumentUUID())) ) {
                    setAttachmentDocumentUUID(((UUID) value));
                }
            }
            if( values.containsKey("MimeType") ) {
                final Object value = values.remove("MimeType");
                if( (value == null) || (!value.equals(getMimeType())) ) {
                    setMimeType(((String) value));
                }
            }
            if( values.containsKey("FileName") ) {
                final Object value = values.remove("FileName");
                if( (value == null) || (!value.equals(getFileName())) ) {
                    setFileName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> AttachmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new AttachmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> AttachmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new AttachmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
