/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.CurEHSLocationInclRootHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.CurEHSLocationInclRootHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Hierarchy for current rev. of EHS Loc.
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>C_CurEHSLocationInclRootHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class CurEHSLocationInclRootHier extends VdmEntity<CurEHSLocationInclRootHier>
{

    /**
     * Selector for all available fields of CurEHSLocationInclRootHier.
     *
     */
    public final static CurEHSLocationInclRootHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @return Location
     */
    @Key
    @SerializedName( "EHSLocationUUID" )
    @JsonProperty( "EHSLocationUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocationUUID" )
    private UUID eHSLocationUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationUUID</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<UUID> EHS_LOCATION_UUID =
        new CurEHSLocationInclRootHierField<UUID>("EHSLocationUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationName</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "EHSLocationName" )
    @JsonProperty( "EHSLocationName" )
    @Nullable
    @ODataField( odataName = "EHSLocationName" )
    private String eHSLocationName;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationName</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_NAME =
        new CurEHSLocationInclRootHierField<String>("EHSLocationName");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationIDAndName</b>
     * </p>
     *
     * @return Text (length 132)
     */
    @SerializedName( "EHSLocationIDAndName" )
    @JsonProperty( "EHSLocationIDAndName" )
    @Nullable
    @ODataField( odataName = "EHSLocationIDAndName" )
    private String eHSLocationIDAndName;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationIDAndName</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_ID_AND_NAME =
        new CurEHSLocationInclRootHierField<String>("EHSLocationIDAndName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationID</b>
     * </p>
     *
     * @return Location ID
     */
    @SerializedName( "EHSLocationID" )
    @JsonProperty( "EHSLocationID" )
    @Nullable
    @ODataField( odataName = "EHSLocationID" )
    private String eHSLocationID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationID</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_ID =
        new CurEHSLocationInclRootHierField<String>("EHSLocationID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationTypeText</b>
     * </p>
     *
     * @return Location Type Description
     */
    @SerializedName( "EHSLocationTypeText" )
    @JsonProperty( "EHSLocationTypeText" )
    @Nullable
    @ODataField( odataName = "EHSLocationTypeText" )
    private String eHSLocationTypeText;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationTypeText</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_TYPE_TEXT =
        new CurEHSLocationInclRootHierField<String>("EHSLocationTypeText");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationStatus</b>
     * </p>
     *
     * @return Location Status
     */
    @SerializedName( "EHSLocationStatus" )
    @JsonProperty( "EHSLocationStatus" )
    @Nullable
    @ODataField( odataName = "EHSLocationStatus" )
    private String eHSLocationStatus;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationStatus</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_STATUS =
        new CurEHSLocationInclRootHierField<String>("EHSLocationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant ID
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> PLANT =
        new CurEHSLocationInclRootHierField<String>("Plant");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MyEHSLocationUUID</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "MyEHSLocationUUID" )
    @JsonProperty( "MyEHSLocationUUID" )
    @Nullable
    @ODataField( odataName = "MyEHSLocationUUID" )
    private UUID myEHSLocationUUID;
    /**
     * Use with available fluent helpers to apply the <b>MyEHSLocationUUID</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<UUID> MY_EHS_LOCATION_UUID =
        new CurEHSLocationInclRootHierField<UUID>("MyEHSLocationUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSParentLocationUUID</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "EHSParentLocationUUID" )
    @JsonProperty( "EHSParentLocationUUID" )
    @Nullable
    @ODataField( odataName = "EHSParentLocationUUID" )
    private UUID eHSParentLocationUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSParentLocationUUID</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<UUID> EHS_PARENT_LOCATION_UUID =
        new CurEHSLocationInclRootHierField<UUID>("EHSParentLocationUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationDrillStateString</b>
     * </p>
     *
     * @return Text (10 Characters)
     */
    @SerializedName( "EHSLocationDrillStateString" )
    @JsonProperty( "EHSLocationDrillStateString" )
    @Nullable
    @ODataField( odataName = "EHSLocationDrillStateString" )
    private String eHSLocationDrillStateString;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationDrillStateString</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_DRILL_STATE_STRING =
        new CurEHSLocationInclRootHierField<String>("EHSLocationDrillStateString");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType</b>
     * </p>
     *
     * @return Location Type
     */
    @SerializedName( "EHSLocationType" )
    @JsonProperty( "EHSLocationType" )
    @Nullable
    @ODataField( odataName = "EHSLocationType" )
    private String eHSLocationType;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationType</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_TYPE =
        new CurEHSLocationInclRootHierField<String>("EHSLocationType");
    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationAuthorizationGroup</b>
     * </p>
     *
     * @return Location Authorization Group
     */
    @SerializedName( "EHSLocationAuthorizationGroup" )
    @JsonProperty( "EHSLocationAuthorizationGroup" )
    @Nullable
    @ODataField( odataName = "EHSLocationAuthorizationGroup" )
    private String eHSLocationAuthorizationGroup;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationAuthorizationGroup</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOCATION_AUTHORIZATION_GROUP =
        new CurEHSLocationInclRootHierField<String>("EHSLocationAuthorizationGroup");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost Center
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> COST_CENTER =
        new CurEHSLocationInclRootHierField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> COMPANY_CODE =
        new CurEHSLocationInclRootHierField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> BUSINESS_AREA =
        new CurEHSLocationInclRootHierField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifiersText</b>
     * </p>
     *
     * @return List of Classifiers (Comma Separated) - short
     */
    @SerializedName( "EHSLocClassifiersText" )
    @JsonProperty( "EHSLocClassifiersText" )
    @Nullable
    @ODataField( odataName = "EHSLocClassifiersText" )
    private String eHSLocClassifiersText;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocClassifiersText</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<String> EHS_LOC_CLASSIFIERS_TEXT =
        new CurEHSLocationInclRootHierField<String>("EHSLocClassifiersText");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocHierarchyNodeUUID</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "EHSLocHierarchyNodeUUID" )
    @JsonProperty( "EHSLocHierarchyNodeUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocHierarchyNodeUUID" )
    private UUID eHSLocHierarchyNodeUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocHierarchyNodeUUID</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<UUID> EHS_LOC_HIERARCHY_NODE_UUID =
        new CurEHSLocationInclRootHierField<UUID>("EHSLocHierarchyNodeUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocHierarchyParentNodeUUID</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "EHSLocHierarchyParentNodeUUID" )
    @JsonProperty( "EHSLocHierarchyParentNodeUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocHierarchyParentNodeUUID" )
    private UUID eHSLocHierarchyParentNodeUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocHierarchyParentNodeUUID</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<UUID> EHS_LOC_HIERARCHY_PARENT_NODE_UUID =
        new CurEHSLocationInclRootHierField<UUID>("EHSLocHierarchyParentNodeUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyLevel</b>
     * </p>
     *
     * @return The hierarchyLevel contained in this entity.
     */
    @SerializedName( "HierarchyLevel" )
    @JsonProperty( "HierarchyLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyLevel" )
    private Integer hierarchyLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyLevel</b> field to query operations.
     *
     */
    public final static CurEHSLocationInclRootHierField<Integer> HIERARCHY_LEVEL =
        new CurEHSLocationInclRootHierField<Integer>("HierarchyLevel");

    @Nonnull
    @Override
    public Class<CurEHSLocationInclRootHier> getType()
    {
        return CurEHSLocationInclRootHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @param eHSLocationUUID
     *            Location
     */
    public void setEHSLocationUUID( @Nullable final UUID eHSLocationUUID )
    {
        rememberChangedField("EHSLocationUUID", this.eHSLocationUUID);
        this.eHSLocationUUID = eHSLocationUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationName</b>
     * </p>
     *
     * @param eHSLocationName
     *            Location
     */
    public void setEHSLocationName( @Nullable final String eHSLocationName )
    {
        rememberChangedField("EHSLocationName", this.eHSLocationName);
        this.eHSLocationName = eHSLocationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationIDAndName</b>
     * </p>
     *
     * @param eHSLocationIDAndName
     *            Text (length 132)
     */
    public void setEHSLocationIDAndName( @Nullable final String eHSLocationIDAndName )
    {
        rememberChangedField("EHSLocationIDAndName", this.eHSLocationIDAndName);
        this.eHSLocationIDAndName = eHSLocationIDAndName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationID</b>
     * </p>
     *
     * @param eHSLocationID
     *            Location ID
     */
    public void setEHSLocationID( @Nullable final String eHSLocationID )
    {
        rememberChangedField("EHSLocationID", this.eHSLocationID);
        this.eHSLocationID = eHSLocationID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationTypeText</b>
     * </p>
     *
     * @param eHSLocationTypeText
     *            Location Type Description
     */
    public void setEHSLocationTypeText( @Nullable final String eHSLocationTypeText )
    {
        rememberChangedField("EHSLocationTypeText", this.eHSLocationTypeText);
        this.eHSLocationTypeText = eHSLocationTypeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationStatus</b>
     * </p>
     *
     * @param eHSLocationStatus
     *            Location Status
     */
    public void setEHSLocationStatus( @Nullable final String eHSLocationStatus )
    {
        rememberChangedField("EHSLocationStatus", this.eHSLocationStatus);
        this.eHSLocationStatus = eHSLocationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant ID
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>MyEHSLocationUUID</b>
     * </p>
     *
     * @param myEHSLocationUUID
     *            Location
     */
    public void setMyEHSLocationUUID( @Nullable final UUID myEHSLocationUUID )
    {
        rememberChangedField("MyEHSLocationUUID", this.myEHSLocationUUID);
        this.myEHSLocationUUID = myEHSLocationUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSParentLocationUUID</b>
     * </p>
     *
     * @param eHSParentLocationUUID
     *            Location
     */
    public void setEHSParentLocationUUID( @Nullable final UUID eHSParentLocationUUID )
    {
        rememberChangedField("EHSParentLocationUUID", this.eHSParentLocationUUID);
        this.eHSParentLocationUUID = eHSParentLocationUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationDrillStateString</b>
     * </p>
     *
     * @param eHSLocationDrillStateString
     *            Text (10 Characters)
     */
    public void setEHSLocationDrillStateString( @Nullable final String eHSLocationDrillStateString )
    {
        rememberChangedField("EHSLocationDrillStateString", this.eHSLocationDrillStateString);
        this.eHSLocationDrillStateString = eHSLocationDrillStateString;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType</b>
     * </p>
     *
     * @param eHSLocationType
     *            Location Type
     */
    public void setEHSLocationType( @Nullable final String eHSLocationType )
    {
        rememberChangedField("EHSLocationType", this.eHSLocationType);
        this.eHSLocationType = eHSLocationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationAuthorizationGroup</b>
     * </p>
     *
     * @param eHSLocationAuthorizationGroup
     *            Location Authorization Group
     */
    public void setEHSLocationAuthorizationGroup( @Nullable final String eHSLocationAuthorizationGroup )
    {
        rememberChangedField("EHSLocationAuthorizationGroup", this.eHSLocationAuthorizationGroup);
        this.eHSLocationAuthorizationGroup = eHSLocationAuthorizationGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost Center
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifiersText</b>
     * </p>
     *
     * @param eHSLocClassifiersText
     *            List of Classifiers (Comma Separated) - short
     */
    public void setEHSLocClassifiersText( @Nullable final String eHSLocClassifiersText )
    {
        rememberChangedField("EHSLocClassifiersText", this.eHSLocClassifiersText);
        this.eHSLocClassifiersText = eHSLocClassifiersText;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocHierarchyNodeUUID</b>
     * </p>
     *
     * @param eHSLocHierarchyNodeUUID
     *            Location
     */
    public void setEHSLocHierarchyNodeUUID( @Nullable final UUID eHSLocHierarchyNodeUUID )
    {
        rememberChangedField("EHSLocHierarchyNodeUUID", this.eHSLocHierarchyNodeUUID);
        this.eHSLocHierarchyNodeUUID = eHSLocHierarchyNodeUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocHierarchyParentNodeUUID</b>
     * </p>
     *
     * @param eHSLocHierarchyParentNodeUUID
     *            Location
     */
    public void setEHSLocHierarchyParentNodeUUID( @Nullable final UUID eHSLocHierarchyParentNodeUUID )
    {
        rememberChangedField("EHSLocHierarchyParentNodeUUID", this.eHSLocHierarchyParentNodeUUID);
        this.eHSLocHierarchyParentNodeUUID = eHSLocHierarchyParentNodeUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyLevel</b>
     * </p>
     *
     * @param hierarchyLevel
     *            The hierarchyLevel to set.
     */
    public void setHierarchyLevel( @Nullable final Integer hierarchyLevel )
    {
        rememberChangedField("HierarchyLevel", this.hierarchyLevel);
        this.hierarchyLevel = hierarchyLevel;
    }

    @Override
    protected String getEntityCollection()
    {
        return "C_CurEHSLocationInclRootHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EHSLocationUUID", getEHSLocationUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EHSLocationUUID", getEHSLocationUUID());
        values.put("EHSLocationName", getEHSLocationName());
        values.put("EHSLocationIDAndName", getEHSLocationIDAndName());
        values.put("EHSLocationID", getEHSLocationID());
        values.put("EHSLocationTypeText", getEHSLocationTypeText());
        values.put("EHSLocationStatus", getEHSLocationStatus());
        values.put("Plant", getPlant());
        values.put("MyEHSLocationUUID", getMyEHSLocationUUID());
        values.put("EHSParentLocationUUID", getEHSParentLocationUUID());
        values.put("EHSLocationDrillStateString", getEHSLocationDrillStateString());
        values.put("EHSLocationType", getEHSLocationType());
        values.put("EHSLocationAuthorizationGroup", getEHSLocationAuthorizationGroup());
        values.put("CostCenter", getCostCenter());
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("EHSLocClassifiersText", getEHSLocClassifiersText());
        values.put("EHSLocHierarchyNodeUUID", getEHSLocHierarchyNodeUUID());
        values.put("EHSLocHierarchyParentNodeUUID", getEHSLocHierarchyParentNodeUUID());
        values.put("HierarchyLevel", getHierarchyLevel());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EHSLocationUUID") ) {
                final Object value = values.remove("EHSLocationUUID");
                if( (value == null) || (!value.equals(getEHSLocationUUID())) ) {
                    setEHSLocationUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSLocationName") ) {
                final Object value = values.remove("EHSLocationName");
                if( (value == null) || (!value.equals(getEHSLocationName())) ) {
                    setEHSLocationName(((String) value));
                }
            }
            if( values.containsKey("EHSLocationIDAndName") ) {
                final Object value = values.remove("EHSLocationIDAndName");
                if( (value == null) || (!value.equals(getEHSLocationIDAndName())) ) {
                    setEHSLocationIDAndName(((String) value));
                }
            }
            if( values.containsKey("EHSLocationID") ) {
                final Object value = values.remove("EHSLocationID");
                if( (value == null) || (!value.equals(getEHSLocationID())) ) {
                    setEHSLocationID(((String) value));
                }
            }
            if( values.containsKey("EHSLocationTypeText") ) {
                final Object value = values.remove("EHSLocationTypeText");
                if( (value == null) || (!value.equals(getEHSLocationTypeText())) ) {
                    setEHSLocationTypeText(((String) value));
                }
            }
            if( values.containsKey("EHSLocationStatus") ) {
                final Object value = values.remove("EHSLocationStatus");
                if( (value == null) || (!value.equals(getEHSLocationStatus())) ) {
                    setEHSLocationStatus(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("MyEHSLocationUUID") ) {
                final Object value = values.remove("MyEHSLocationUUID");
                if( (value == null) || (!value.equals(getMyEHSLocationUUID())) ) {
                    setMyEHSLocationUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSParentLocationUUID") ) {
                final Object value = values.remove("EHSParentLocationUUID");
                if( (value == null) || (!value.equals(getEHSParentLocationUUID())) ) {
                    setEHSParentLocationUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSLocationDrillStateString") ) {
                final Object value = values.remove("EHSLocationDrillStateString");
                if( (value == null) || (!value.equals(getEHSLocationDrillStateString())) ) {
                    setEHSLocationDrillStateString(((String) value));
                }
            }
            if( values.containsKey("EHSLocationType") ) {
                final Object value = values.remove("EHSLocationType");
                if( (value == null) || (!value.equals(getEHSLocationType())) ) {
                    setEHSLocationType(((String) value));
                }
            }
            if( values.containsKey("EHSLocationAuthorizationGroup") ) {
                final Object value = values.remove("EHSLocationAuthorizationGroup");
                if( (value == null) || (!value.equals(getEHSLocationAuthorizationGroup())) ) {
                    setEHSLocationAuthorizationGroup(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("EHSLocClassifiersText") ) {
                final Object value = values.remove("EHSLocClassifiersText");
                if( (value == null) || (!value.equals(getEHSLocClassifiersText())) ) {
                    setEHSLocClassifiersText(((String) value));
                }
            }
            if( values.containsKey("EHSLocHierarchyNodeUUID") ) {
                final Object value = values.remove("EHSLocHierarchyNodeUUID");
                if( (value == null) || (!value.equals(getEHSLocHierarchyNodeUUID())) ) {
                    setEHSLocHierarchyNodeUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSLocHierarchyParentNodeUUID") ) {
                final Object value = values.remove("EHSLocHierarchyParentNodeUUID");
                if( (value == null) || (!value.equals(getEHSLocHierarchyParentNodeUUID())) ) {
                    setEHSLocHierarchyParentNodeUUID(((UUID) value));
                }
            }
            if( values.containsKey("HierarchyLevel") ) {
                final Object value = values.remove("HierarchyLevel");
                if( (value == null) || (!value.equals(getHierarchyLevel())) ) {
                    setHierarchyLevel(((Integer) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> CurEHSLocationInclRootHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new CurEHSLocationInclRootHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> CurEHSLocationInclRootHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new CurEHSLocationInclRootHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
