/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSLocClassifierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.EHSLocClassifierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Location classifier text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>I_EHSLocClassifierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EHSLocClassifierText extends VdmEntity<EHSLocClassifierText>
{

    /**
     * Selector for all available fields of EHSLocClassifierText.
     *
     */
    public final static EHSLocClassifierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "EHSLocationUUID" )
    @JsonProperty( "EHSLocationUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocationUUID" )
    private UUID eHSLocationUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationUUID</b> field to query operations.
     *
     */
    public final static EHSLocClassifierTextField<UUID> EHS_LOCATION_UUID =
        new EHSLocClassifierTextField<UUID>("EHSLocationUUID");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "EHSLocClassifierUUID" )
    @JsonProperty( "EHSLocClassifierUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocClassifierUUID" )
    private UUID eHSLocClassifierUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocClassifierUUID</b> field to query operations.
     *
     */
    public final static EHSLocClassifierTextField<UUID> EHS_LOC_CLASSIFIER_UUID =
        new EHSLocClassifierTextField<UUID>("EHSLocClassifierUUID");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierRefUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "EHSLocClassifierRefUUID" )
    @JsonProperty( "EHSLocClassifierRefUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocClassifierRefUUID" )
    private UUID eHSLocClassifierRefUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocClassifierRefUUID</b> field to query operations.
     *
     */
    public final static EHSLocClassifierTextField<UUID> EHS_LOC_CLASSIFIER_REF_UUID =
        new EHSLocClassifierTextField<UUID>("EHSLocClassifierRefUUID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierID</b>
     * </p>
     *
     * @return BCO ID
     */
    @SerializedName( "EHSLocClassifierID" )
    @JsonProperty( "EHSLocClassifierID" )
    @Nullable
    @ODataField( odataName = "EHSLocClassifierID" )
    private String eHSLocClassifierID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocClassifierID</b> field to query operations.
     *
     */
    public final static EHSLocClassifierTextField<String> EHS_LOC_CLASSIFIER_ID =
        new EHSLocClassifierTextField<String>("EHSLocClassifierID");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierText</b>
     * </p>
     *
     * @return Translatable Long Text (255 char)
     */
    @SerializedName( "EHSLocClassifierText" )
    @JsonProperty( "EHSLocClassifierText" )
    @Nullable
    @ODataField( odataName = "EHSLocClassifierText" )
    private String eHSLocClassifierText;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocClassifierText</b> field to query operations.
     *
     */
    public final static EHSLocClassifierTextField<String> EHS_LOC_CLASSIFIER_TEXT =
        new EHSLocClassifierTextField<String>("EHSLocClassifierText");

    @Nonnull
    @Override
    public Class<EHSLocClassifierText> getType()
    {
        return EHSLocClassifierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @param eHSLocationUUID
     *            NodeID
     */
    public void setEHSLocationUUID( @Nullable final UUID eHSLocationUUID )
    {
        rememberChangedField("EHSLocationUUID", this.eHSLocationUUID);
        this.eHSLocationUUID = eHSLocationUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierUUID</b>
     * </p>
     *
     * @param eHSLocClassifierUUID
     *            NodeID
     */
    public void setEHSLocClassifierUUID( @Nullable final UUID eHSLocClassifierUUID )
    {
        rememberChangedField("EHSLocClassifierUUID", this.eHSLocClassifierUUID);
        this.eHSLocClassifierUUID = eHSLocClassifierUUID;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierRefUUID</b>
     * </p>
     *
     * @param eHSLocClassifierRefUUID
     *            NodeID
     */
    public void setEHSLocClassifierRefUUID( @Nullable final UUID eHSLocClassifierRefUUID )
    {
        rememberChangedField("EHSLocClassifierRefUUID", this.eHSLocClassifierRefUUID);
        this.eHSLocClassifierRefUUID = eHSLocClassifierRefUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierID</b>
     * </p>
     *
     * @param eHSLocClassifierID
     *            BCO ID
     */
    public void setEHSLocClassifierID( @Nullable final String eHSLocClassifierID )
    {
        rememberChangedField("EHSLocClassifierID", this.eHSLocClassifierID);
        this.eHSLocClassifierID = eHSLocClassifierID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierText</b>
     * </p>
     *
     * @param eHSLocClassifierText
     *            Translatable Long Text (255 char)
     */
    public void setEHSLocClassifierText( @Nullable final String eHSLocClassifierText )
    {
        rememberChangedField("EHSLocClassifierText", this.eHSLocClassifierText);
        this.eHSLocClassifierText = eHSLocClassifierText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "I_EHSLocClassifierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EHSLocationUUID", getEHSLocationUUID());
        result.put("EHSLocClassifierUUID", getEHSLocClassifierUUID());
        result.put("EHSLocClassifierRefUUID", getEHSLocClassifierRefUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EHSLocationUUID", getEHSLocationUUID());
        values.put("EHSLocClassifierUUID", getEHSLocClassifierUUID());
        values.put("EHSLocClassifierRefUUID", getEHSLocClassifierRefUUID());
        values.put("EHSLocClassifierID", getEHSLocClassifierID());
        values.put("EHSLocClassifierText", getEHSLocClassifierText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EHSLocationUUID") ) {
                final Object value = values.remove("EHSLocationUUID");
                if( (value == null) || (!value.equals(getEHSLocationUUID())) ) {
                    setEHSLocationUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSLocClassifierUUID") ) {
                final Object value = values.remove("EHSLocClassifierUUID");
                if( (value == null) || (!value.equals(getEHSLocClassifierUUID())) ) {
                    setEHSLocClassifierUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSLocClassifierRefUUID") ) {
                final Object value = values.remove("EHSLocClassifierRefUUID");
                if( (value == null) || (!value.equals(getEHSLocClassifierRefUUID())) ) {
                    setEHSLocClassifierRefUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSLocClassifierID") ) {
                final Object value = values.remove("EHSLocClassifierID");
                if( (value == null) || (!value.equals(getEHSLocClassifierID())) ) {
                    setEHSLocClassifierID(((String) value));
                }
            }
            if( values.containsKey("EHSLocClassifierText") ) {
                final Object value = values.remove("EHSLocClassifierText");
                if( (value == null) || (!value.equals(getEHSLocClassifierText())) ) {
                    setEHSLocClassifierText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EHSLocClassifierTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EHSLocClassifierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EHSLocClassifierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EHSLocClassifierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
