/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.EHSLocClassifierTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText
 * EHSLocClassifierText} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class EHSLocClassifierTextByKeyFluentHelper
    extends
    FluentHelperByKey<EHSLocClassifierTextByKeyFluentHelper, EHSLocClassifierText, EHSLocClassifierTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText
     * EHSLocClassifierText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code EHSLocClassifierText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code EHSLocClassifierText}
     * @param eHSLocClassifierRefUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param eHSLocClassifierUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     * @param eHSLocationUUID
     *            NodeID
     *            <p>
     *            Constraints: Not nullable
     *            </p>
     */
    public EHSLocClassifierTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final UUID eHSLocationUUID,
        final UUID eHSLocClassifierUUID,
        final UUID eHSLocClassifierRefUUID )
    {
        super(servicePath, entityCollection);
        this.key.put("EHSLocationUUID", eHSLocationUUID);
        this.key.put("EHSLocClassifierUUID", eHSLocClassifierUUID);
        this.key.put("EHSLocClassifierRefUUID", eHSLocClassifierRefUUID);
    }

    @Override
    @Nonnull
    protected Class<EHSLocClassifierText> getEntityClass()
    {
        return EHSLocClassifierText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
