/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSLocClassifierVHField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.EHSLocClassifierVHSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Location Classifier
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>C_EHSLocClassifierVHType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EHSLocClassifierVH extends VdmEntity<EHSLocClassifierVH>
{

    /**
     * Selector for all available fields of EHSLocClassifierVH.
     *
     */
    public final static EHSLocClassifierVHSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierUUID</b>
     * </p>
     *
     * @return NodeID
     */
    @Key
    @SerializedName( "EHSClassifierUUID" )
    @JsonProperty( "EHSClassifierUUID" )
    @Nullable
    @ODataField( odataName = "EHSClassifierUUID" )
    private UUID eHSClassifierUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSClassifierUUID</b> field to query operations.
     *
     */
    public final static EHSLocClassifierVHField<UUID> EHS_CLASSIFIER_UUID =
        new EHSLocClassifierVHField<UUID>("EHSClassifierUUID");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierNameFreeSearch</b>
     * </p>
     *
     * @return Translatable Long Text (255 char)
     */
    @SerializedName( "EHSClassifierNameFreeSearch" )
    @JsonProperty( "EHSClassifierNameFreeSearch" )
    @Nullable
    @ODataField( odataName = "EHSClassifierNameFreeSearch" )
    private String eHSClassifierNameFreeSearch;
    /**
     * Use with available fluent helpers to apply the <b>EHSClassifierNameFreeSearch</b> field to query operations.
     *
     */
    public final static EHSLocClassifierVHField<String> EHS_CLASSIFIER_NAME_FREE_SEARCH =
        new EHSLocClassifierVHField<String>("EHSClassifierNameFreeSearch");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierName</b>
     * </p>
     *
     * @return Translatable Long Text (255 char)
     */
    @SerializedName( "EHSClassifierName" )
    @JsonProperty( "EHSClassifierName" )
    @Nullable
    @ODataField( odataName = "EHSClassifierName" )
    private String eHSClassifierName;
    /**
     * Use with available fluent helpers to apply the <b>EHSClassifierName</b> field to query operations.
     *
     */
    public final static EHSLocClassifierVHField<String> EHS_CLASSIFIER_NAME =
        new EHSLocClassifierVHField<String>("EHSClassifierName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierID</b>
     * </p>
     *
     * @return ID
     */
    @SerializedName( "EHSLocClassifierID" )
    @JsonProperty( "EHSLocClassifierID" )
    @Nullable
    @ODataField( odataName = "EHSLocClassifierID" )
    private String eHSLocClassifierID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocClassifierID</b> field to query operations.
     *
     */
    public final static EHSLocClassifierVHField<String> EHS_LOC_CLASSIFIER_ID =
        new EHSLocClassifierVHField<String>("EHSLocClassifierID");

    @Nonnull
    @Override
    public Class<EHSLocClassifierVH> getType()
    {
        return EHSLocClassifierVH.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierUUID</b>
     * </p>
     *
     * @param eHSClassifierUUID
     *            NodeID
     */
    public void setEHSClassifierUUID( @Nullable final UUID eHSClassifierUUID )
    {
        rememberChangedField("EHSClassifierUUID", this.eHSClassifierUUID);
        this.eHSClassifierUUID = eHSClassifierUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierNameFreeSearch</b>
     * </p>
     *
     * @param eHSClassifierNameFreeSearch
     *            Translatable Long Text (255 char)
     */
    public void setEHSClassifierNameFreeSearch( @Nullable final String eHSClassifierNameFreeSearch )
    {
        rememberChangedField("EHSClassifierNameFreeSearch", this.eHSClassifierNameFreeSearch);
        this.eHSClassifierNameFreeSearch = eHSClassifierNameFreeSearch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierName</b>
     * </p>
     *
     * @param eHSClassifierName
     *            Translatable Long Text (255 char)
     */
    public void setEHSClassifierName( @Nullable final String eHSClassifierName )
    {
        rememberChangedField("EHSClassifierName", this.eHSClassifierName);
        this.eHSClassifierName = eHSClassifierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifierID</b>
     * </p>
     *
     * @param eHSLocClassifierID
     *            ID
     */
    public void setEHSLocClassifierID( @Nullable final String eHSLocClassifierID )
    {
        rememberChangedField("EHSLocClassifierID", this.eHSLocClassifierID);
        this.eHSLocClassifierID = eHSLocClassifierID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "C_EHSLocClassifierVH";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EHSClassifierUUID", getEHSClassifierUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EHSClassifierUUID", getEHSClassifierUUID());
        values.put("EHSClassifierNameFreeSearch", getEHSClassifierNameFreeSearch());
        values.put("EHSClassifierName", getEHSClassifierName());
        values.put("EHSLocClassifierID", getEHSLocClassifierID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EHSClassifierUUID") ) {
                final Object value = values.remove("EHSClassifierUUID");
                if( (value == null) || (!value.equals(getEHSClassifierUUID())) ) {
                    setEHSClassifierUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSClassifierNameFreeSearch") ) {
                final Object value = values.remove("EHSClassifierNameFreeSearch");
                if( (value == null) || (!value.equals(getEHSClassifierNameFreeSearch())) ) {
                    setEHSClassifierNameFreeSearch(((String) value));
                }
            }
            if( values.containsKey("EHSClassifierName") ) {
                final Object value = values.remove("EHSClassifierName");
                if( (value == null) || (!value.equals(getEHSClassifierName())) ) {
                    setEHSClassifierName(((String) value));
                }
            }
            if( values.containsKey("EHSLocClassifierID") ) {
                final Object value = values.remove("EHSLocClassifierID");
                if( (value == null) || (!value.equals(getEHSLocClassifierID())) ) {
                    setEHSLocClassifierID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EHSLocClassifierVHField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EHSLocClassifierVHField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EHSLocClassifierVHField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EHSLocClassifierVHField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
