/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSLocationTypeField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.EHSLocationTypeSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * EHS Location Type
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>I_EHSLocationTypeType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EHSLocationType extends VdmEntity<EHSLocationType>
{

    /**
     * Selector for all available fields of EHSLocationType.
     *
     */
    public final static EHSLocationTypeSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType</b>
     * </p>
     *
     * @return Location Type
     */
    @Key
    @SerializedName( "EHSLocationType" )
    @JsonProperty( "EHSLocationType" )
    @Nullable
    @ODataField( odataName = "EHSLocationType" )
    private String eHSLocationType;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationType</b> field to query operations.
     *
     */
    public final static EHSLocationTypeField<String> EHS_LOCATION_TYPE =
        new EHSLocationTypeField<String>("EHSLocationType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType_Text</b>
     * </p>
     *
     * @return Location Type Description
     */
    @SerializedName( "EHSLocationType_Text" )
    @JsonProperty( "EHSLocationType_Text" )
    @Nullable
    @ODataField( odataName = "EHSLocationType_Text" )
    private String eHSLocationType_Text;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationType_Text</b> field to query operations.
     *
     */
    public final static EHSLocationTypeField<String> EHS_LOCATION_TYPE_TEXT =
        new EHSLocationTypeField<String>("EHSLocationType_Text");

    @Nonnull
    @Override
    public Class<EHSLocationType> getType()
    {
        return EHSLocationType.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType</b>
     * </p>
     *
     * @param eHSLocationType
     *            Location Type
     */
    public void setEHSLocationType( @Nullable final String eHSLocationType )
    {
        rememberChangedField("EHSLocationType", this.eHSLocationType);
        this.eHSLocationType = eHSLocationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType_Text</b>
     * </p>
     *
     * @param eHSLocationType_Text
     *            Location Type Description
     */
    public void setEHSLocationType_Text( @Nullable final String eHSLocationType_Text )
    {
        rememberChangedField("EHSLocationType_Text", this.eHSLocationType_Text);
        this.eHSLocationType_Text = eHSLocationType_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "I_EHSLocationType";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EHSLocationType", getEHSLocationType());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EHSLocationType", getEHSLocationType());
        values.put("EHSLocationType_Text", getEHSLocationType_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EHSLocationType") ) {
                final Object value = values.remove("EHSLocationType");
                if( (value == null) || (!value.equals(getEHSLocationType())) ) {
                    setEHSLocationType(((String) value));
                }
            }
            if( values.containsKey("EHSLocationType_Text") ) {
                final Object value = values.remove("EHSLocationType_Text");
                if( (value == null) || (!value.equals(getEHSLocationType_Text())) ) {
                    setEHSLocationType_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EHSLocationTypeField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EHSLocationTypeField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EHSLocationTypeField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EHSLocationTypeField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
