/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSLocationValueHelpField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.EHSLocationValueHelpLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.EHSLocationValueHelpSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * EHS Location
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>C_EHSLocationValueHelpType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EHSLocationValueHelp extends VdmEntity<EHSLocationValueHelp>
{

    /**
     * Selector for all available fields of EHSLocationValueHelp.
     *
     */
    public final static EHSLocationValueHelpSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @return Location
     */
    @Key
    @SerializedName( "EHSLocationUUID" )
    @JsonProperty( "EHSLocationUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocationUUID" )
    private UUID eHSLocationUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationUUID</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<UUID> EHS_LOCATION_UUID =
        new EHSLocationValueHelpField<UUID>("EHSLocationUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationNameFreeSrch</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "EHSLocationNameFreeSrch" )
    @JsonProperty( "EHSLocationNameFreeSrch" )
    @Nullable
    @ODataField( odataName = "EHSLocationNameFreeSrch" )
    private String eHSLocationNameFreeSrch;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationNameFreeSrch</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_NAME_FREE_SRCH =
        new EHSLocationValueHelpField<String>("EHSLocationNameFreeSrch");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationName</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "EHSLocationName" )
    @JsonProperty( "EHSLocationName" )
    @Nullable
    @ODataField( odataName = "EHSLocationName" )
    private String eHSLocationName;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationName</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_NAME =
        new EHSLocationValueHelpField<String>("EHSLocationName");
    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationIDAndName</b>
     * </p>
     *
     * @return Text (length 132)
     */
    @SerializedName( "EHSLocationIDAndName" )
    @JsonProperty( "EHSLocationIDAndName" )
    @Nullable
    @ODataField( odataName = "EHSLocationIDAndName" )
    private String eHSLocationIDAndName;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationIDAndName</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_ID_AND_NAME =
        new EHSLocationValueHelpField<String>("EHSLocationIDAndName");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationID</b>
     * </p>
     *
     * @return ID
     */
    @SerializedName( "EHSLocationID" )
    @JsonProperty( "EHSLocationID" )
    @Nullable
    @ODataField( odataName = "EHSLocationID" )
    private String eHSLocationID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationID</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_ID =
        new EHSLocationValueHelpField<String>("EHSLocationID");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType</b>
     * </p>
     *
     * @return Location Type
     */
    @SerializedName( "EHSLocationType" )
    @JsonProperty( "EHSLocationType" )
    @Nullable
    @ODataField( odataName = "EHSLocationType" )
    private String eHSLocationType;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationType</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_TYPE =
        new EHSLocationValueHelpField<String>("EHSLocationType");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType_Text</b>
     * </p>
     *
     * @return Location Type Description
     */
    @SerializedName( "EHSLocationType_Text" )
    @JsonProperty( "EHSLocationType_Text" )
    @Nullable
    @ODataField( odataName = "EHSLocationType_Text" )
    private String eHSLocationType_Text;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationType_Text</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_TYPE_TEXT =
        new EHSLocationValueHelpField<String>("EHSLocationType_Text");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationStatus</b>
     * </p>
     *
     * @return Location Status
     */
    @SerializedName( "EHSLocationStatus" )
    @JsonProperty( "EHSLocationStatus" )
    @Nullable
    @ODataField( odataName = "EHSLocationStatus" )
    private String eHSLocationStatus;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationStatus</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_STATUS =
        new EHSLocationValueHelpField<String>("EHSLocationStatus");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationStatus_Text</b>
     * </p>
     *
     * @return Location Status Description
     */
    @SerializedName( "EHSLocationStatus_Text" )
    @JsonProperty( "EHSLocationStatus_Text" )
    @Nullable
    @ODataField( odataName = "EHSLocationStatus_Text" )
    private String eHSLocationStatus_Text;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationStatus_Text</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOCATION_STATUS_TEXT =
        new EHSLocationValueHelpField<String>("EHSLocationStatus_Text");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierName</b>
     * </p>
     *
     * @return Location Classifier Name
     */
    @SerializedName( "EHSClassifierName" )
    @JsonProperty( "EHSClassifierName" )
    @Nullable
    @ODataField( odataName = "EHSClassifierName" )
    private String eHSClassifierName;
    /**
     * Use with available fluent helpers to apply the <b>EHSClassifierName</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_CLASSIFIER_NAME =
        new EHSLocationValueHelpField<String>("EHSClassifierName");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifiersText</b>
     * </p>
     *
     * @return List of Classifiers (Comma Separated) - short
     */
    @SerializedName( "EHSLocClassifiersText" )
    @JsonProperty( "EHSLocClassifiersText" )
    @Nullable
    @ODataField( odataName = "EHSLocClassifiersText" )
    private String eHSLocClassifiersText;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocClassifiersText</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<String> EHS_LOC_CLASSIFIERS_TEXT =
        new EHSLocationValueHelpField<String>("EHSLocClassifiersText");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>GeographicalLocationLatitude</b>
     * </p>
     *
     * @return Geographic Latitude
     */
    @SerializedName( "GeographicalLocationLatitude" )
    @JsonProperty( "GeographicalLocationLatitude" )
    @Nullable
    @ODataField( odataName = "GeographicalLocationLatitude" )
    private BigDecimal geographicalLocationLatitude;
    /**
     * Use with available fluent helpers to apply the <b>GeographicalLocationLatitude</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<BigDecimal> GEOGRAPHICAL_LOCATION_LATITUDE =
        new EHSLocationValueHelpField<BigDecimal>("GeographicalLocationLatitude");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>GeographicalLocationLongitude</b>
     * </p>
     *
     * @return Geographic Longitude
     */
    @SerializedName( "GeographicalLocationLongitude" )
    @JsonProperty( "GeographicalLocationLongitude" )
    @Nullable
    @ODataField( odataName = "GeographicalLocationLongitude" )
    private BigDecimal geographicalLocationLongitude;
    /**
     * Use with available fluent helpers to apply the <b>GeographicalLocationLongitude</b> field to query operations.
     *
     */
    public final static EHSLocationValueHelpField<BigDecimal> GEOGRAPHICAL_LOCATION_LONGITUDE =
        new EHSLocationValueHelpField<BigDecimal>("GeographicalLocationLongitude");
    /**
     * Navigation property <b>to_LocClassifierText</b> for <b>EHSLocationValueHelp</b> to multiple
     * <b>EHSLocClassifierText</b>.
     *
     */
    @SerializedName( "to_LocClassifierText" )
    @JsonProperty( "to_LocClassifierText" )
    @ODataField( odataName = "to_LocClassifierText" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<EHSLocClassifierText> toLocClassifierText;
    /**
     * Use with available fluent helpers to apply the <b>to_LocClassifierText</b> navigation property to query
     * operations.
     *
     */
    public final static EHSLocationValueHelpLink<EHSLocClassifierText> TO_LOC_CLASSIFIER_TEXT =
        new EHSLocationValueHelpLink<EHSLocClassifierText>("to_LocClassifierText");

    @Nonnull
    @Override
    public Class<EHSLocationValueHelp> getType()
    {
        return EHSLocationValueHelp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @param eHSLocationUUID
     *            Location
     */
    public void setEHSLocationUUID( @Nullable final UUID eHSLocationUUID )
    {
        rememberChangedField("EHSLocationUUID", this.eHSLocationUUID);
        this.eHSLocationUUID = eHSLocationUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationNameFreeSrch</b>
     * </p>
     *
     * @param eHSLocationNameFreeSrch
     *            Location
     */
    public void setEHSLocationNameFreeSrch( @Nullable final String eHSLocationNameFreeSrch )
    {
        rememberChangedField("EHSLocationNameFreeSrch", this.eHSLocationNameFreeSrch);
        this.eHSLocationNameFreeSrch = eHSLocationNameFreeSrch;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationName</b>
     * </p>
     *
     * @param eHSLocationName
     *            Location
     */
    public void setEHSLocationName( @Nullable final String eHSLocationName )
    {
        rememberChangedField("EHSLocationName", this.eHSLocationName);
        this.eHSLocationName = eHSLocationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 132
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationIDAndName</b>
     * </p>
     *
     * @param eHSLocationIDAndName
     *            Text (length 132)
     */
    public void setEHSLocationIDAndName( @Nullable final String eHSLocationIDAndName )
    {
        rememberChangedField("EHSLocationIDAndName", this.eHSLocationIDAndName);
        this.eHSLocationIDAndName = eHSLocationIDAndName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationID</b>
     * </p>
     *
     * @param eHSLocationID
     *            ID
     */
    public void setEHSLocationID( @Nullable final String eHSLocationID )
    {
        rememberChangedField("EHSLocationID", this.eHSLocationID);
        this.eHSLocationID = eHSLocationID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType</b>
     * </p>
     *
     * @param eHSLocationType
     *            Location Type
     */
    public void setEHSLocationType( @Nullable final String eHSLocationType )
    {
        rememberChangedField("EHSLocationType", this.eHSLocationType);
        this.eHSLocationType = eHSLocationType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationType_Text</b>
     * </p>
     *
     * @param eHSLocationType_Text
     *            Location Type Description
     */
    public void setEHSLocationType_Text( @Nullable final String eHSLocationType_Text )
    {
        rememberChangedField("EHSLocationType_Text", this.eHSLocationType_Text);
        this.eHSLocationType_Text = eHSLocationType_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationStatus</b>
     * </p>
     *
     * @param eHSLocationStatus
     *            Location Status
     */
    public void setEHSLocationStatus( @Nullable final String eHSLocationStatus )
    {
        rememberChangedField("EHSLocationStatus", this.eHSLocationStatus);
        this.eHSLocationStatus = eHSLocationStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationStatus_Text</b>
     * </p>
     *
     * @param eHSLocationStatus_Text
     *            Location Status Description
     */
    public void setEHSLocationStatus_Text( @Nullable final String eHSLocationStatus_Text )
    {
        rememberChangedField("EHSLocationStatus_Text", this.eHSLocationStatus_Text);
        this.eHSLocationStatus_Text = eHSLocationStatus_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSClassifierName</b>
     * </p>
     *
     * @param eHSClassifierName
     *            Location Classifier Name
     */
    public void setEHSClassifierName( @Nullable final String eHSClassifierName )
    {
        rememberChangedField("EHSClassifierName", this.eHSClassifierName);
        this.eHSClassifierName = eHSClassifierName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocClassifiersText</b>
     * </p>
     *
     * @param eHSLocClassifiersText
     *            List of Classifiers (Comma Separated) - short
     */
    public void setEHSLocClassifiersText( @Nullable final String eHSLocClassifiersText )
    {
        rememberChangedField("EHSLocClassifiersText", this.eHSLocClassifiersText);
        this.eHSLocClassifiersText = eHSLocClassifiersText;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>GeographicalLocationLatitude</b>
     * </p>
     *
     * @param geographicalLocationLatitude
     *            Geographic Latitude
     */
    public void setGeographicalLocationLatitude( @Nullable final BigDecimal geographicalLocationLatitude )
    {
        rememberChangedField("GeographicalLocationLatitude", this.geographicalLocationLatitude);
        this.geographicalLocationLatitude = geographicalLocationLatitude;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>GeographicalLocationLongitude</b>
     * </p>
     *
     * @param geographicalLocationLongitude
     *            Geographic Longitude
     */
    public void setGeographicalLocationLongitude( @Nullable final BigDecimal geographicalLocationLongitude )
    {
        rememberChangedField("GeographicalLocationLongitude", this.geographicalLocationLongitude);
        this.geographicalLocationLongitude = geographicalLocationLongitude;
    }

    @Override
    protected String getEntityCollection()
    {
        return "C_EHSLocationValueHelp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("EHSLocationUUID", getEHSLocationUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("EHSLocationUUID", getEHSLocationUUID());
        values.put("EHSLocationNameFreeSrch", getEHSLocationNameFreeSrch());
        values.put("EHSLocationName", getEHSLocationName());
        values.put("EHSLocationIDAndName", getEHSLocationIDAndName());
        values.put("EHSLocationID", getEHSLocationID());
        values.put("EHSLocationType", getEHSLocationType());
        values.put("EHSLocationType_Text", getEHSLocationType_Text());
        values.put("EHSLocationStatus", getEHSLocationStatus());
        values.put("EHSLocationStatus_Text", getEHSLocationStatus_Text());
        values.put("EHSClassifierName", getEHSClassifierName());
        values.put("EHSLocClassifiersText", getEHSLocClassifiersText());
        values.put("GeographicalLocationLatitude", getGeographicalLocationLatitude());
        values.put("GeographicalLocationLongitude", getGeographicalLocationLongitude());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("EHSLocationUUID") ) {
                final Object value = values.remove("EHSLocationUUID");
                if( (value == null) || (!value.equals(getEHSLocationUUID())) ) {
                    setEHSLocationUUID(((UUID) value));
                }
            }
            if( values.containsKey("EHSLocationNameFreeSrch") ) {
                final Object value = values.remove("EHSLocationNameFreeSrch");
                if( (value == null) || (!value.equals(getEHSLocationNameFreeSrch())) ) {
                    setEHSLocationNameFreeSrch(((String) value));
                }
            }
            if( values.containsKey("EHSLocationName") ) {
                final Object value = values.remove("EHSLocationName");
                if( (value == null) || (!value.equals(getEHSLocationName())) ) {
                    setEHSLocationName(((String) value));
                }
            }
            if( values.containsKey("EHSLocationIDAndName") ) {
                final Object value = values.remove("EHSLocationIDAndName");
                if( (value == null) || (!value.equals(getEHSLocationIDAndName())) ) {
                    setEHSLocationIDAndName(((String) value));
                }
            }
            if( values.containsKey("EHSLocationID") ) {
                final Object value = values.remove("EHSLocationID");
                if( (value == null) || (!value.equals(getEHSLocationID())) ) {
                    setEHSLocationID(((String) value));
                }
            }
            if( values.containsKey("EHSLocationType") ) {
                final Object value = values.remove("EHSLocationType");
                if( (value == null) || (!value.equals(getEHSLocationType())) ) {
                    setEHSLocationType(((String) value));
                }
            }
            if( values.containsKey("EHSLocationType_Text") ) {
                final Object value = values.remove("EHSLocationType_Text");
                if( (value == null) || (!value.equals(getEHSLocationType_Text())) ) {
                    setEHSLocationType_Text(((String) value));
                }
            }
            if( values.containsKey("EHSLocationStatus") ) {
                final Object value = values.remove("EHSLocationStatus");
                if( (value == null) || (!value.equals(getEHSLocationStatus())) ) {
                    setEHSLocationStatus(((String) value));
                }
            }
            if( values.containsKey("EHSLocationStatus_Text") ) {
                final Object value = values.remove("EHSLocationStatus_Text");
                if( (value == null) || (!value.equals(getEHSLocationStatus_Text())) ) {
                    setEHSLocationStatus_Text(((String) value));
                }
            }
            if( values.containsKey("EHSClassifierName") ) {
                final Object value = values.remove("EHSClassifierName");
                if( (value == null) || (!value.equals(getEHSClassifierName())) ) {
                    setEHSClassifierName(((String) value));
                }
            }
            if( values.containsKey("EHSLocClassifiersText") ) {
                final Object value = values.remove("EHSLocClassifiersText");
                if( (value == null) || (!value.equals(getEHSLocClassifiersText())) ) {
                    setEHSLocClassifiersText(((String) value));
                }
            }
            if( values.containsKey("GeographicalLocationLatitude") ) {
                final Object value = values.remove("GeographicalLocationLatitude");
                if( (value == null) || (!value.equals(getGeographicalLocationLatitude())) ) {
                    setGeographicalLocationLatitude(((BigDecimal) value));
                }
            }
            if( values.containsKey("GeographicalLocationLongitude") ) {
                final Object value = values.remove("GeographicalLocationLongitude");
                if( (value == null) || (!value.equals(getGeographicalLocationLongitude())) ) {
                    setGeographicalLocationLongitude(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_LocClassifierText") ) {
                final Object value = (values).remove("to_LocClassifierText");
                if( value instanceof Iterable ) {
                    if( toLocClassifierText == null ) {
                        toLocClassifierText = Lists.newArrayList();
                    } else {
                        toLocClassifierText = Lists.newArrayList(toLocClassifierText);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        EHSLocClassifierText entity;
                        if( toLocClassifierText.size() > i ) {
                            entity = toLocClassifierText.get(i);
                        } else {
                            entity = new EHSLocClassifierText();
                            toLocClassifierText.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EHSLocationValueHelpField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EHSLocationValueHelpField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EHSLocationValueHelpField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EHSLocationValueHelpField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLocClassifierText != null ) {
            (values).put("to_LocClassifierText", toLocClassifierText);
        }
        return values;
    }

    /**
     * Fetches the <b>EHSLocClassifierText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_LocClassifierText</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>EHSLocClassifierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EHSLocClassifierText> fetchLocClassifierText()
    {
        return fetchFieldAsList("to_LocClassifierText", EHSLocClassifierText.class);
    }

    /**
     * Retrieval of associated <b>EHSLocClassifierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LocClassifierText</b>.
     * <p>
     * If the navigation property <b>to_LocClassifierText</b> of a queried <b>EHSLocationValueHelp</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EHSLocClassifierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<EHSLocClassifierText> getLocClassifierTextOrFetch()
    {
        if( toLocClassifierText == null ) {
            toLocClassifierText = fetchLocClassifierText();
        }
        return toLocClassifierText;
    }

    /**
     * Retrieval of associated <b>EHSLocClassifierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_LocClassifierText</b>.
     * <p>
     * If the navigation property for an entity <b>EHSLocationValueHelp</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_LocClassifierText</b> is already loaded, the result will
     *         contain the <b>EHSLocClassifierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<EHSLocClassifierText>> getLocClassifierTextIfPresent()
    {
        return Option.of(toLocClassifierText);
    }

    /**
     * Overwrites the list of associated <b>EHSLocClassifierText</b> entities for the loaded navigation property
     * <b>to_LocClassifierText</b>.
     * <p>
     * If the navigation property <b>to_LocClassifierText</b> of a queried <b>EHSLocationValueHelp</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>EHSLocClassifierText</b> entities.
     */
    public void setLocClassifierText( @Nonnull final List<EHSLocClassifierText> value )
    {
        if( toLocClassifierText == null ) {
            toLocClassifierText = Lists.newArrayList();
        }
        toLocClassifierText.clear();
        toLocClassifierText.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>EHSLocClassifierText</b> entities. This corresponds to the OData
     * navigation property <b>to_LocClassifierText</b>.
     * <p>
     * If the navigation property <b>to_LocClassifierText</b> of a queried <b>EHSLocationValueHelp</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>EHSLocClassifierText</b> entities.
     */
    public void addLocClassifierText( EHSLocClassifierText... entity )
    {
        if( toLocClassifierText == null ) {
            toLocClassifierText = Lists.newArrayList();
        }
        toLocClassifierText.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of EHSLocationValueHelp instances.
     *
     */
    public final static class EHSLocationValueHelpBuilder
    {

        private List<EHSLocClassifierText> toLocClassifierText = Lists.newArrayList();

        private EHSLocationValueHelp.EHSLocationValueHelpBuilder toLocClassifierText(
            final List<EHSLocClassifierText> value )
        {
            toLocClassifierText.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_LocClassifierText</b> for <b>EHSLocationValueHelp</b> to multiple
         * <b>EHSLocClassifierText</b>.
         *
         * @param value
         *            The EHSLocClassifierTexts to build this EHSLocationValueHelp with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EHSLocationValueHelp.EHSLocationValueHelpBuilder locClassifierText( EHSLocClassifierText... value )
        {
            return toLocClassifierText(Lists.newArrayList(value));
        }

    }

}
