/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSPersonValueHelpField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.EHSPersonValueHelpSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * EHS Person Value Help
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>C_EHSPersonValueHelpType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EHSPersonValueHelp extends VdmEntity<EHSPersonValueHelp>
{

    /**
     * Selector for all available fields of EHSPersonValueHelp.
     *
     */
    public final static EHSPersonValueHelpSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @return Business Partner Number
     */
    @Key
    @SerializedName( "BusinessPartner" )
    @JsonProperty( "BusinessPartner" )
    @Nullable
    @ODataField( odataName = "BusinessPartner" )
    private String businessPartner;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartner</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> BUSINESS_PARTNER =
        new EHSPersonValueHelpField<String>("BusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>EHSCombinedBusinessPartner</b>
     * </p>
     *
     * @return The eHSCombinedBusinessPartner contained in this entity.
     */
    @SerializedName( "EHSCombinedBusinessPartner" )
    @JsonProperty( "EHSCombinedBusinessPartner" )
    @Nullable
    @ODataField( odataName = "EHSCombinedBusinessPartner" )
    private String eHSCombinedBusinessPartner;
    /**
     * Use with available fluent helpers to apply the <b>EHSCombinedBusinessPartner</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> EHS_COMBINED_BUSINESS_PARTNER =
        new EHSPersonValueHelpField<String>("EHSCombinedBusinessPartner");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FirstName</b>
     * </p>
     *
     * @return First Name of Business Partner (Person)
     */
    @SerializedName( "FirstName" )
    @JsonProperty( "FirstName" )
    @Nullable
    @ODataField( odataName = "FirstName" )
    private String firstName;
    /**
     * Use with available fluent helpers to apply the <b>FirstName</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> FIRST_NAME = new EHSPersonValueHelpField<String>("FirstName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LastName</b>
     * </p>
     *
     * @return Last Name of Business Partner (Person)
     */
    @SerializedName( "LastName" )
    @JsonProperty( "LastName" )
    @Nullable
    @ODataField( odataName = "LastName" )
    private String lastName;
    /**
     * Use with available fluent helpers to apply the <b>LastName</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> LAST_NAME = new EHSPersonValueHelpField<String>("LastName");
    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @return BUSINESS PARTNER NAME
     */
    @SerializedName( "BusinessPartnerName" )
    @JsonProperty( "BusinessPartnerName" )
    @Nullable
    @ODataField( odataName = "BusinessPartnerName" )
    private String businessPartnerName;
    /**
     * Use with available fluent helpers to apply the <b>BusinessPartnerName</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> BUSINESS_PARTNER_NAME =
        new EHSPersonValueHelpField<String>("BusinessPartnerName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @return Personnel Number
     */
    @SerializedName( "PersonWorkAgreement" )
    @JsonProperty( "PersonWorkAgreement" )
    @Nullable
    @ODataField( odataName = "PersonWorkAgreement" )
    private String personWorkAgreement;
    /**
     * Use with available fluent helpers to apply the <b>PersonWorkAgreement</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> PERSON_WORK_AGREEMENT =
        new EHSPersonValueHelpField<String>("PersonWorkAgreement");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationalUnit</b>
     * </p>
     *
     * @return Organizational Unit
     */
    @SerializedName( "OrganizationalUnit" )
    @JsonProperty( "OrganizationalUnit" )
    @Nullable
    @ODataField( odataName = "OrganizationalUnit" )
    private String organizationalUnit;
    /**
     * Use with available fluent helpers to apply the <b>OrganizationalUnit</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> ORGANIZATIONAL_UNIT =
        new EHSPersonValueHelpField<String>("OrganizationalUnit");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> COMPANY_CODE =
        new EHSPersonValueHelpField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @return Name of Company Code or Company
     */
    @SerializedName( "CompanyCodeName" )
    @JsonProperty( "CompanyCodeName" )
    @Nullable
    @ODataField( odataName = "CompanyCodeName" )
    private String companyCodeName;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCodeName</b> field to query operations.
     *
     */
    public final static EHSPersonValueHelpField<String> COMPANY_CODE_NAME =
        new EHSPersonValueHelpField<String>("CompanyCodeName");

    @Nonnull
    @Override
    public Class<EHSPersonValueHelp> getType()
    {
        return EHSPersonValueHelp.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartner</b>
     * </p>
     *
     * @param businessPartner
     *            Business Partner Number
     */
    public void setBusinessPartner( @Nullable final String businessPartner )
    {
        rememberChangedField("BusinessPartner", this.businessPartner);
        this.businessPartner = businessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 13
     * <p>
     * Original property name from the Odata EDM: <b>EHSCombinedBusinessPartner</b>
     * </p>
     *
     * @param eHSCombinedBusinessPartner
     *            The eHSCombinedBusinessPartner to set.
     */
    public void setEHSCombinedBusinessPartner( @Nullable final String eHSCombinedBusinessPartner )
    {
        rememberChangedField("EHSCombinedBusinessPartner", this.eHSCombinedBusinessPartner);
        this.eHSCombinedBusinessPartner = eHSCombinedBusinessPartner;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FirstName</b>
     * </p>
     *
     * @param firstName
     *            First Name of Business Partner (Person)
     */
    public void setFirstName( @Nullable final String firstName )
    {
        rememberChangedField("FirstName", this.firstName);
        this.firstName = firstName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LastName</b>
     * </p>
     *
     * @param lastName
     *            Last Name of Business Partner (Person)
     */
    public void setLastName( @Nullable final String lastName )
    {
        rememberChangedField("LastName", this.lastName);
        this.lastName = lastName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 81
     * <p>
     * Original property name from the Odata EDM: <b>BusinessPartnerName</b>
     * </p>
     *
     * @param businessPartnerName
     *            BUSINESS PARTNER NAME
     */
    public void setBusinessPartnerName( @Nullable final String businessPartnerName )
    {
        rememberChangedField("BusinessPartnerName", this.businessPartnerName);
        this.businessPartnerName = businessPartnerName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>PersonWorkAgreement</b>
     * </p>
     *
     * @param personWorkAgreement
     *            Personnel Number
     */
    public void setPersonWorkAgreement( @Nullable final String personWorkAgreement )
    {
        rememberChangedField("PersonWorkAgreement", this.personWorkAgreement);
        this.personWorkAgreement = personWorkAgreement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>OrganizationalUnit</b>
     * </p>
     *
     * @param organizationalUnit
     *            Organizational Unit
     */
    public void setOrganizationalUnit( @Nullable final String organizationalUnit )
    {
        rememberChangedField("OrganizationalUnit", this.organizationalUnit);
        this.organizationalUnit = organizationalUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCodeName</b>
     * </p>
     *
     * @param companyCodeName
     *            Name of Company Code or Company
     */
    public void setCompanyCodeName( @Nullable final String companyCodeName )
    {
        rememberChangedField("CompanyCodeName", this.companyCodeName);
        this.companyCodeName = companyCodeName;
    }

    @Override
    protected String getEntityCollection()
    {
        return "C_EHSPersonValueHelp";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("BusinessPartner", getBusinessPartner());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("BusinessPartner", getBusinessPartner());
        values.put("EHSCombinedBusinessPartner", getEHSCombinedBusinessPartner());
        values.put("FirstName", getFirstName());
        values.put("LastName", getLastName());
        values.put("BusinessPartnerName", getBusinessPartnerName());
        values.put("PersonWorkAgreement", getPersonWorkAgreement());
        values.put("OrganizationalUnit", getOrganizationalUnit());
        values.put("CompanyCode", getCompanyCode());
        values.put("CompanyCodeName", getCompanyCodeName());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("BusinessPartner") ) {
                final Object value = values.remove("BusinessPartner");
                if( (value == null) || (!value.equals(getBusinessPartner())) ) {
                    setBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("EHSCombinedBusinessPartner") ) {
                final Object value = values.remove("EHSCombinedBusinessPartner");
                if( (value == null) || (!value.equals(getEHSCombinedBusinessPartner())) ) {
                    setEHSCombinedBusinessPartner(((String) value));
                }
            }
            if( values.containsKey("FirstName") ) {
                final Object value = values.remove("FirstName");
                if( (value == null) || (!value.equals(getFirstName())) ) {
                    setFirstName(((String) value));
                }
            }
            if( values.containsKey("LastName") ) {
                final Object value = values.remove("LastName");
                if( (value == null) || (!value.equals(getLastName())) ) {
                    setLastName(((String) value));
                }
            }
            if( values.containsKey("BusinessPartnerName") ) {
                final Object value = values.remove("BusinessPartnerName");
                if( (value == null) || (!value.equals(getBusinessPartnerName())) ) {
                    setBusinessPartnerName(((String) value));
                }
            }
            if( values.containsKey("PersonWorkAgreement") ) {
                final Object value = values.remove("PersonWorkAgreement");
                if( (value == null) || (!value.equals(getPersonWorkAgreement())) ) {
                    setPersonWorkAgreement(((String) value));
                }
            }
            if( values.containsKey("OrganizationalUnit") ) {
                final Object value = values.remove("OrganizationalUnit");
                if( (value == null) || (!value.equals(getOrganizationalUnit())) ) {
                    setOrganizationalUnit(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("CompanyCodeName") ) {
                final Object value = values.remove("CompanyCodeName");
                if( (value == null) || (!value.equals(getCompanyCodeName())) ) {
                    setCompanyCodeName(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EHSPersonValueHelpField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EHSPersonValueHelpField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EHSPersonValueHelpField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EHSPersonValueHelpField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
