/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.IncidentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.IncidentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.IncidentOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.IncidentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Incident
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Incident</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Incident extends VdmEntity<Incident>
{

    /**
     * Selector for all available fields of Incident.
     *
     */
    public final static IncidentSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncidentID</b>
     * </p>
     *
     * @return Incident ID
     */
    @SerializedName( "IncidentID" )
    @JsonProperty( "IncidentID" )
    @Nullable
    @ODataField( odataName = "IncidentID" )
    private String incidentID;
    /**
     * Use with available fluent helpers to apply the <b>IncidentID</b> field to query operations.
     *
     */
    public final static IncidentField<String> INCIDENT_ID = new IncidentField<String>("IncidentID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FilterByCurrentUser</b>
     * </p>
     *
     * @return Filter by Current User
     */
    @SerializedName( "FilterByCurrentUser" )
    @JsonProperty( "FilterByCurrentUser" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FilterByCurrentUser" )
    private Boolean filterByCurrentUser;
    /**
     * Use with available fluent helpers to apply the <b>FilterByCurrentUser</b> field to query operations.
     *
     */
    public final static IncidentField<Boolean> FILTER_BY_CURRENT_USER =
        new IncidentField<Boolean>("FilterByCurrentUser");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IncidentUUID</b>
     * </p>
     *
     * @return Incident Global Identification
     */
    @Key
    @SerializedName( "IncidentUUID" )
    @JsonProperty( "IncidentUUID" )
    @Nullable
    @ODataField( odataName = "IncidentUUID" )
    private UUID incidentUUID;
    /**
     * Use with available fluent helpers to apply the <b>IncidentUUID</b> field to query operations.
     *
     */
    public final static IncidentField<UUID> INCIDENT_UUID = new IncidentField<UUID>("IncidentUUID");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IncidentUTCDateTime</b>
     * </p>
     *
     * @return Incident Start Date/Time (UTC)
     */
    @SerializedName( "IncidentUTCDateTime" )
    @JsonProperty( "IncidentUTCDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "IncidentUTCDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime incidentUTCDateTime;
    /**
     * Use with available fluent helpers to apply the <b>IncidentUTCDateTime</b> field to query operations.
     *
     */
    public final static IncidentField<ZonedDateTime> INCIDENT_UTC_DATE_TIME =
        new IncidentField<ZonedDateTime>("IncidentUTCDateTime");
    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>IncidentTitle</b>
     * </p>
     *
     * @return Incident Title
     */
    @SerializedName( "IncidentTitle" )
    @JsonProperty( "IncidentTitle" )
    @Nullable
    @ODataField( odataName = "IncidentTitle" )
    private String incidentTitle;
    /**
     * Use with available fluent helpers to apply the <b>IncidentTitle</b> field to query operations.
     *
     */
    public final static IncidentField<String> INCIDENT_TITLE = new IncidentField<String>("IncidentTitle");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>IncidentStatus</b>
     * </p>
     *
     * @return Incident Status
     */
    @SerializedName( "IncidentStatus" )
    @JsonProperty( "IncidentStatus" )
    @Nullable
    @ODataField( odataName = "IncidentStatus" )
    private String incidentStatus;
    /**
     * Use with available fluent helpers to apply the <b>IncidentStatus</b> field to query operations.
     *
     */
    public final static IncidentField<String> INCIDENT_STATUS = new IncidentField<String>("IncidentStatus");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>IncidentLocationDescription</b>
     * </p>
     *
     * @return Additional Description of Incident Location
     */
    @SerializedName( "IncidentLocationDescription" )
    @JsonProperty( "IncidentLocationDescription" )
    @Nullable
    @ODataField( odataName = "IncidentLocationDescription" )
    private String incidentLocationDescription;
    /**
     * Use with available fluent helpers to apply the <b>IncidentLocationDescription</b> field to query operations.
     *
     */
    public final static IncidentField<String> INCIDENT_LOCATION_DESCRIPTION =
        new IncidentField<String>("IncidentLocationDescription");
    /**
     * Constraints: Not nullable, Maximum length: 999999
     * <p>
     * Original property name from the Odata EDM: <b>IncidentDescriptionOfEvents</b>
     * </p>
     *
     * @return Description
     */
    @SerializedName( "IncidentDescriptionOfEvents" )
    @JsonProperty( "IncidentDescriptionOfEvents" )
    @Nullable
    @ODataField( odataName = "IncidentDescriptionOfEvents" )
    private String incidentDescriptionOfEvents;
    /**
     * Use with available fluent helpers to apply the <b>IncidentDescriptionOfEvents</b> field to query operations.
     *
     */
    public final static IncidentField<String> INCIDENT_DESCRIPTION_OF_EVENTS =
        new IncidentField<String>("IncidentDescriptionOfEvents");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncidentCategory</b>
     * </p>
     *
     * @return Incident Category
     */
    @SerializedName( "IncidentCategory" )
    @JsonProperty( "IncidentCategory" )
    @Nullable
    @ODataField( odataName = "IncidentCategory" )
    private String incidentCategory;
    /**
     * Use with available fluent helpers to apply the <b>IncidentCategory</b> field to query operations.
     *
     */
    public final static IncidentField<String> INCIDENT_CATEGORY = new IncidentField<String>("IncidentCategory");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @return Location Global Identification
     */
    @SerializedName( "EHSLocationUUID" )
    @JsonProperty( "EHSLocationUUID" )
    @Nullable
    @ODataField( odataName = "EHSLocationUUID" )
    private UUID eHSLocationUUID;
    /**
     * Use with available fluent helpers to apply the <b>EHSLocationUUID</b> field to query operations.
     *
     */
    public final static IncidentField<UUID> EHS_LOCATION_UUID = new IncidentField<UUID>("EHSLocationUUID");
    /**
     * Navigation property <b>to_Location</b> for <b>Incident</b> to single <b>Location</b>.
     *
     */
    @SerializedName( "to_Location" )
    @JsonProperty( "to_Location" )
    @ODataField( odataName = "to_Location" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Location toLocation;
    /**
     * Navigation property <b>to_Persons</b> for <b>Incident</b> to multiple <b>Person</b>.
     *
     */
    @SerializedName( "to_Persons" )
    @JsonProperty( "to_Persons" )
    @ODataField( odataName = "to_Persons" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<Person> toPersons;
    /**
     * Navigation property <b>to_Attachments</b> for <b>Incident</b> to multiple <b>Attachment</b>.
     *
     */
    @SerializedName( "to_Attachments" )
    @JsonProperty( "to_Attachments" )
    @ODataField( odataName = "to_Attachments" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<Attachment> toAttachments;
    /**
     * Use with available fluent helpers to apply the <b>to_Location</b> navigation property to query operations.
     *
     */
    public final static IncidentOneToOneLink<Location> TO_LOCATION = new IncidentOneToOneLink<Location>("to_Location");
    /**
     * Use with available fluent helpers to apply the <b>to_Persons</b> navigation property to query operations.
     *
     */
    public final static IncidentLink<Person> TO_PERSONS = new IncidentLink<Person>("to_Persons");
    /**
     * Use with available fluent helpers to apply the <b>to_Attachments</b> navigation property to query operations.
     *
     */
    public final static IncidentLink<Attachment> TO_ATTACHMENTS = new IncidentLink<Attachment>("to_Attachments");

    @Nonnull
    @Override
    public Class<Incident> getType()
    {
        return Incident.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>IncidentID</b>
     * </p>
     *
     * @param incidentID
     *            Incident ID
     */
    public void setIncidentID( @Nullable final String incidentID )
    {
        rememberChangedField("IncidentID", this.incidentID);
        this.incidentID = incidentID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FilterByCurrentUser</b>
     * </p>
     *
     * @param filterByCurrentUser
     *            Filter by Current User
     */
    public void setFilterByCurrentUser( @Nullable final Boolean filterByCurrentUser )
    {
        rememberChangedField("FilterByCurrentUser", this.filterByCurrentUser);
        this.filterByCurrentUser = filterByCurrentUser;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>IncidentUUID</b>
     * </p>
     *
     * @param incidentUUID
     *            Incident Global Identification
     */
    public void setIncidentUUID( @Nullable final UUID incidentUUID )
    {
        rememberChangedField("IncidentUUID", this.incidentUUID);
        this.incidentUUID = incidentUUID;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>IncidentUTCDateTime</b>
     * </p>
     *
     * @param incidentUTCDateTime
     *            Incident Start Date/Time (UTC)
     */
    public void setIncidentUTCDateTime( @Nullable final ZonedDateTime incidentUTCDateTime )
    {
        rememberChangedField("IncidentUTCDateTime", this.incidentUTCDateTime);
        this.incidentUTCDateTime = incidentUTCDateTime;
    }

    /**
     * Constraints: Not nullable, Maximum length: 255
     * <p>
     * Original property name from the Odata EDM: <b>IncidentTitle</b>
     * </p>
     *
     * @param incidentTitle
     *            Incident Title
     */
    public void setIncidentTitle( @Nullable final String incidentTitle )
    {
        rememberChangedField("IncidentTitle", this.incidentTitle);
        this.incidentTitle = incidentTitle;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>IncidentStatus</b>
     * </p>
     *
     * @param incidentStatus
     *            Incident Status
     */
    public void setIncidentStatus( @Nullable final String incidentStatus )
    {
        rememberChangedField("IncidentStatus", this.incidentStatus);
        this.incidentStatus = incidentStatus;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>IncidentLocationDescription</b>
     * </p>
     *
     * @param incidentLocationDescription
     *            Additional Description of Incident Location
     */
    public void setIncidentLocationDescription( @Nullable final String incidentLocationDescription )
    {
        rememberChangedField("IncidentLocationDescription", this.incidentLocationDescription);
        this.incidentLocationDescription = incidentLocationDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 999999
     * <p>
     * Original property name from the Odata EDM: <b>IncidentDescriptionOfEvents</b>
     * </p>
     *
     * @param incidentDescriptionOfEvents
     *            Description
     */
    public void setIncidentDescriptionOfEvents( @Nullable final String incidentDescriptionOfEvents )
    {
        rememberChangedField("IncidentDescriptionOfEvents", this.incidentDescriptionOfEvents);
        this.incidentDescriptionOfEvents = incidentDescriptionOfEvents;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>IncidentCategory</b>
     * </p>
     *
     * @param incidentCategory
     *            Incident Category
     */
    public void setIncidentCategory( @Nullable final String incidentCategory )
    {
        rememberChangedField("IncidentCategory", this.incidentCategory);
        this.incidentCategory = incidentCategory;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EHSLocationUUID</b>
     * </p>
     *
     * @param eHSLocationUUID
     *            Location Global Identification
     */
    public void setEHSLocationUUID( @Nullable final UUID eHSLocationUUID )
    {
        rememberChangedField("EHSLocationUUID", this.eHSLocationUUID);
        this.eHSLocationUUID = eHSLocationUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Incident";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("IncidentUUID", getIncidentUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("IncidentID", getIncidentID());
        values.put("FilterByCurrentUser", getFilterByCurrentUser());
        values.put("IncidentUUID", getIncidentUUID());
        values.put("IncidentUTCDateTime", getIncidentUTCDateTime());
        values.put("IncidentTitle", getIncidentTitle());
        values.put("IncidentStatus", getIncidentStatus());
        values.put("IncidentLocationDescription", getIncidentLocationDescription());
        values.put("IncidentDescriptionOfEvents", getIncidentDescriptionOfEvents());
        values.put("IncidentCategory", getIncidentCategory());
        values.put("EHSLocationUUID", getEHSLocationUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("IncidentID") ) {
                final Object value = values.remove("IncidentID");
                if( (value == null) || (!value.equals(getIncidentID())) ) {
                    setIncidentID(((String) value));
                }
            }
            if( values.containsKey("FilterByCurrentUser") ) {
                final Object value = values.remove("FilterByCurrentUser");
                if( (value == null) || (!value.equals(getFilterByCurrentUser())) ) {
                    setFilterByCurrentUser(((Boolean) value));
                }
            }
            if( values.containsKey("IncidentUUID") ) {
                final Object value = values.remove("IncidentUUID");
                if( (value == null) || (!value.equals(getIncidentUUID())) ) {
                    setIncidentUUID(((UUID) value));
                }
            }
            if( values.containsKey("IncidentUTCDateTime") ) {
                final Object value = values.remove("IncidentUTCDateTime");
                if( (value == null) || (!value.equals(getIncidentUTCDateTime())) ) {
                    setIncidentUTCDateTime(((ZonedDateTime) value));
                }
            }
            if( values.containsKey("IncidentTitle") ) {
                final Object value = values.remove("IncidentTitle");
                if( (value == null) || (!value.equals(getIncidentTitle())) ) {
                    setIncidentTitle(((String) value));
                }
            }
            if( values.containsKey("IncidentStatus") ) {
                final Object value = values.remove("IncidentStatus");
                if( (value == null) || (!value.equals(getIncidentStatus())) ) {
                    setIncidentStatus(((String) value));
                }
            }
            if( values.containsKey("IncidentLocationDescription") ) {
                final Object value = values.remove("IncidentLocationDescription");
                if( (value == null) || (!value.equals(getIncidentLocationDescription())) ) {
                    setIncidentLocationDescription(((String) value));
                }
            }
            if( values.containsKey("IncidentDescriptionOfEvents") ) {
                final Object value = values.remove("IncidentDescriptionOfEvents");
                if( (value == null) || (!value.equals(getIncidentDescriptionOfEvents())) ) {
                    setIncidentDescriptionOfEvents(((String) value));
                }
            }
            if( values.containsKey("IncidentCategory") ) {
                final Object value = values.remove("IncidentCategory");
                if( (value == null) || (!value.equals(getIncidentCategory())) ) {
                    setIncidentCategory(((String) value));
                }
            }
            if( values.containsKey("EHSLocationUUID") ) {
                final Object value = values.remove("EHSLocationUUID");
                if( (value == null) || (!value.equals(getEHSLocationUUID())) ) {
                    setEHSLocationUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_Location") ) {
                final Object value = (values).remove("to_Location");
                if( value instanceof Map ) {
                    if( toLocation == null ) {
                        toLocation = new Location();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toLocation.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_Persons") ) {
                final Object value = (values).remove("to_Persons");
                if( value instanceof Iterable ) {
                    if( toPersons == null ) {
                        toPersons = Lists.newArrayList();
                    } else {
                        toPersons = Lists.newArrayList(toPersons);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        Person entity;
                        if( toPersons.size() > i ) {
                            entity = toPersons.get(i);
                        } else {
                            entity = new Person();
                            toPersons.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_Attachments") ) {
                final Object value = (values).remove("to_Attachments");
                if( value instanceof Iterable ) {
                    if( toAttachments == null ) {
                        toAttachments = Lists.newArrayList();
                    } else {
                        toAttachments = Lists.newArrayList(toAttachments);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        Attachment entity;
                        if( toAttachments.size() > i ) {
                            entity = toAttachments.get(i);
                        } else {
                            entity = new Attachment();
                            toAttachments.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> IncidentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new IncidentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> IncidentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new IncidentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toLocation != null ) {
            (values).put("to_Location", toLocation);
        }
        if( toPersons != null ) {
            (values).put("to_Persons", toPersons);
        }
        if( toAttachments != null ) {
            (values).put("to_Attachments", toAttachments);
        }
        return values;
    }

    /**
     * Fetches the <b>Location</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Location</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Location</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Location fetchLocation()
    {
        return fetchFieldAsSingle("to_Location", Location.class);
    }

    /**
     * Retrieval of associated <b>Location</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Location</b>.
     * <p>
     * If the navigation property <b>to_Location</b> of a queried <b>Incident</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Location</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Location getLocationOrFetch()
    {
        if( toLocation == null ) {
            toLocation = fetchLocation();
        }
        return toLocation;
    }

    /**
     * Retrieval of associated <b>Location</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_Location</b>.
     * <p>
     * If the navigation property for an entity <b>Incident</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Location</b> is already loaded, the result will contain
     *         the <b>Location</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Location> getLocationIfPresent()
    {
        return Option.of(toLocation);
    }

    /**
     * Overwrites the associated <b>Location</b> entity for the loaded navigation property <b>to_Location</b>.
     *
     * @param value
     *            New <b>Location</b> entity.
     */
    public void setLocation( final Location value )
    {
        toLocation = value;
    }

    /**
     * Fetches the <b>Person</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Persons</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>Person</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Person> fetchPersons()
    {
        return fetchFieldAsList("to_Persons", Person.class);
    }

    /**
     * Retrieval of associated <b>Person</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_Persons</b>.
     * <p>
     * If the navigation property <b>to_Persons</b> of a queried <b>Incident</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Person</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Person> getPersonsOrFetch()
    {
        if( toPersons == null ) {
            toPersons = fetchPersons();
        }
        return toPersons;
    }

    /**
     * Retrieval of associated <b>Person</b> entities (one to many). This corresponds to the OData navigation property
     * <b>to_Persons</b>.
     * <p>
     * If the navigation property for an entity <b>Incident</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Persons</b> is already loaded, the result will contain
     *         the <b>Person</b> entities. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<List<Person>> getPersonsIfPresent()
    {
        return Option.of(toPersons);
    }

    /**
     * Overwrites the list of associated <b>Person</b> entities for the loaded navigation property <b>to_Persons</b>.
     * <p>
     * If the navigation property <b>to_Persons</b> of a queried <b>Incident</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>Person</b> entities.
     */
    public void setPersons( @Nonnull final List<Person> value )
    {
        if( toPersons == null ) {
            toPersons = Lists.newArrayList();
        }
        toPersons.clear();
        toPersons.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>Person</b> entities. This corresponds to the OData navigation property
     * <b>to_Persons</b>.
     * <p>
     * If the navigation property <b>to_Persons</b> of a queried <b>Incident</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>Person</b> entities.
     */
    public void addPersons( Person... entity )
    {
        if( toPersons == null ) {
            toPersons = Lists.newArrayList();
        }
        toPersons.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>Attachment</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_Attachments</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>Attachment</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Attachment> fetchAttachments()
    {
        return fetchFieldAsList("to_Attachments", Attachment.class);
    }

    /**
     * Retrieval of associated <b>Attachment</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Attachments</b>.
     * <p>
     * If the navigation property <b>to_Attachments</b> of a queried <b>Incident</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Attachment</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<Attachment> getAttachmentsOrFetch()
    {
        if( toAttachments == null ) {
            toAttachments = fetchAttachments();
        }
        return toAttachments;
    }

    /**
     * Retrieval of associated <b>Attachment</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_Attachments</b>.
     * <p>
     * If the navigation property for an entity <b>Incident</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_Attachments</b> is already loaded, the result will
     *         contain the <b>Attachment</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<Attachment>> getAttachmentsIfPresent()
    {
        return Option.of(toAttachments);
    }

    /**
     * Overwrites the list of associated <b>Attachment</b> entities for the loaded navigation property
     * <b>to_Attachments</b>.
     * <p>
     * If the navigation property <b>to_Attachments</b> of a queried <b>Incident</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>Attachment</b> entities.
     */
    public void setAttachments( @Nonnull final List<Attachment> value )
    {
        if( toAttachments == null ) {
            toAttachments = Lists.newArrayList();
        }
        toAttachments.clear();
        toAttachments.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>Attachment</b> entities. This corresponds to the OData navigation
     * property <b>to_Attachments</b>.
     * <p>
     * If the navigation property <b>to_Attachments</b> of a queried <b>Incident</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>Attachment</b> entities.
     */
    public void addAttachments( Attachment... entity )
    {
        if( toAttachments == null ) {
            toAttachments = Lists.newArrayList();
        }
        toAttachments.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Incident instances.
     *
     */
    public final static class IncidentBuilder
    {

        private Location toLocation;
        private List<Person> toPersons = Lists.newArrayList();
        private List<Attachment> toAttachments = Lists.newArrayList();

        private Incident.IncidentBuilder toLocation( final Location value )
        {
            toLocation = value;
            return this;
        }

        /**
         * Navigation property <b>to_Location</b> for <b>Incident</b> to single <b>Location</b>.
         *
         * @param value
         *            The Location to build this Incident with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Incident.IncidentBuilder location( final Location value )
        {
            return toLocation(value);
        }

        private Incident.IncidentBuilder toPersons( final List<Person> value )
        {
            toPersons.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Persons</b> for <b>Incident</b> to multiple <b>Person</b>.
         *
         * @param value
         *            The Persons to build this Incident with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Incident.IncidentBuilder persons( Person... value )
        {
            return toPersons(Lists.newArrayList(value));
        }

        private Incident.IncidentBuilder toAttachments( final List<Attachment> value )
        {
            toAttachments.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_Attachments</b> for <b>Incident</b> to multiple <b>Attachment</b>.
         *
         * @param value
         *            The Attachments to build this Incident with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Incident.IncidentBuilder attachments( Attachment... value )
        {
            return toAttachments(Lists.newArrayList(value));
        }

    }

}
