/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.math.BigDecimal;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.LocationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.LocationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Location
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Location</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Location extends VdmEntity<Location>
{

    /**
     * Selector for all available fields of Location.
     *
     */
    public final static LocationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LocationUUID</b>
     * </p>
     *
     * @return Location Global Identification
     */
    @Key
    @SerializedName( "LocationUUID" )
    @JsonProperty( "LocationUUID" )
    @Nullable
    @ODataField( odataName = "LocationUUID" )
    private UUID locationUUID;
    /**
     * Use with available fluent helpers to apply the <b>LocationUUID</b> field to query operations.
     *
     */
    public final static LocationField<UUID> LOCATION_UUID = new LocationField<UUID>("LocationUUID");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LocationName</b>
     * </p>
     *
     * @return Location Name
     */
    @SerializedName( "LocationName" )
    @JsonProperty( "LocationName" )
    @Nullable
    @ODataField( odataName = "LocationName" )
    private String locationName;
    /**
     * Use with available fluent helpers to apply the <b>LocationName</b> field to query operations.
     *
     */
    public final static LocationField<String> LOCATION_NAME = new LocationField<String>("LocationName");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LocationType</b>
     * </p>
     *
     * @return Location Type
     */
    @SerializedName( "LocationType" )
    @JsonProperty( "LocationType" )
    @Nullable
    @ODataField( odataName = "LocationType" )
    private String locationType;
    /**
     * Use with available fluent helpers to apply the <b>LocationType</b> field to query operations.
     *
     */
    public final static LocationField<String> LOCATION_TYPE = new LocationField<String>("LocationType");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>LocationLatitude</b>
     * </p>
     *
     * @return Geo Location for Latitude
     */
    @SerializedName( "LocationLatitude" )
    @JsonProperty( "LocationLatitude" )
    @Nullable
    @ODataField( odataName = "LocationLatitude" )
    private BigDecimal locationLatitude;
    /**
     * Use with available fluent helpers to apply the <b>LocationLatitude</b> field to query operations.
     *
     */
    public final static LocationField<BigDecimal> LOCATION_LATITUDE = new LocationField<BigDecimal>("LocationLatitude");
    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>LocationLongtitude</b>
     * </p>
     *
     * @return Geo Location for Longtitude
     */
    @SerializedName( "LocationLongtitude" )
    @JsonProperty( "LocationLongtitude" )
    @Nullable
    @ODataField( odataName = "LocationLongtitude" )
    private BigDecimal locationLongtitude;
    /**
     * Use with available fluent helpers to apply the <b>LocationLongtitude</b> field to query operations.
     *
     */
    public final static LocationField<BigDecimal> LOCATION_LONGTITUDE =
        new LocationField<BigDecimal>("LocationLongtitude");

    @Nonnull
    @Override
    public Class<Location> getType()
    {
        return Location.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>LocationUUID</b>
     * </p>
     *
     * @param locationUUID
     *            Location Global Identification
     */
    public void setLocationUUID( @Nullable final UUID locationUUID )
    {
        rememberChangedField("LocationUUID", this.locationUUID);
        this.locationUUID = locationUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>LocationName</b>
     * </p>
     *
     * @param locationName
     *            Location Name
     */
    public void setLocationName( @Nullable final String locationName )
    {
        rememberChangedField("LocationName", this.locationName);
        this.locationName = locationName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>LocationType</b>
     * </p>
     *
     * @param locationType
     *            Location Type
     */
    public void setLocationType( @Nullable final String locationType )
    {
        rememberChangedField("LocationType", this.locationType);
        this.locationType = locationType;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>LocationLatitude</b>
     * </p>
     *
     * @param locationLatitude
     *            Geo Location for Latitude
     */
    public void setLocationLatitude( @Nullable final BigDecimal locationLatitude )
    {
        rememberChangedField("LocationLatitude", this.locationLatitude);
        this.locationLatitude = locationLatitude;
    }

    /**
     * Constraints: Not nullable, Precision: 15, Scale: 12
     * <p>
     * Original property name from the Odata EDM: <b>LocationLongtitude</b>
     * </p>
     *
     * @param locationLongtitude
     *            Geo Location for Longtitude
     */
    public void setLocationLongtitude( @Nullable final BigDecimal locationLongtitude )
    {
        rememberChangedField("LocationLongtitude", this.locationLongtitude);
        this.locationLongtitude = locationLongtitude;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Location";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("LocationUUID", getLocationUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("LocationUUID", getLocationUUID());
        values.put("LocationName", getLocationName());
        values.put("LocationType", getLocationType());
        values.put("LocationLatitude", getLocationLatitude());
        values.put("LocationLongtitude", getLocationLongtitude());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("LocationUUID") ) {
                final Object value = values.remove("LocationUUID");
                if( (value == null) || (!value.equals(getLocationUUID())) ) {
                    setLocationUUID(((UUID) value));
                }
            }
            if( values.containsKey("LocationName") ) {
                final Object value = values.remove("LocationName");
                if( (value == null) || (!value.equals(getLocationName())) ) {
                    setLocationName(((String) value));
                }
            }
            if( values.containsKey("LocationType") ) {
                final Object value = values.remove("LocationType");
                if( (value == null) || (!value.equals(getLocationType())) ) {
                    setLocationType(((String) value));
                }
            }
            if( values.containsKey("LocationLatitude") ) {
                final Object value = values.remove("LocationLatitude");
                if( (value == null) || (!value.equals(getLocationLatitude())) ) {
                    setLocationLatitude(((BigDecimal) value));
                }
            }
            if( values.containsKey("LocationLongtitude") ) {
                final Object value = values.remove("LocationLongtitude");
                if( (value == null) || (!value.equals(getLocationLongtitude())) ) {
                    setLocationLongtitude(((BigDecimal) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> LocationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new LocationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> LocationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new LocationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
