/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate;

import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.PersonField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable.PersonSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Person
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>Person</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Person extends VdmEntity<Person>
{

    /**
     * Selector for all available fields of Person.
     *
     */
    public final static PersonSelectable ALL_FIELDS = () -> "*";
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PersonId</b>
     * </p>
     *
     * @return Person Id
     */
    @SerializedName( "PersonId" )
    @JsonProperty( "PersonId" )
    @Nullable
    @ODataField( odataName = "PersonId" )
    private String personId;
    /**
     * Use with available fluent helpers to apply the <b>PersonId</b> field to query operations.
     *
     */
    public final static PersonField<String> PERSON_ID = new PersonField<String>("PersonId");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PersonFullName</b>
     * </p>
     *
     * @return Person Name
     */
    @SerializedName( "PersonFullName" )
    @JsonProperty( "PersonFullName" )
    @Nullable
    @ODataField( odataName = "PersonFullName" )
    private String personFullName;
    /**
     * Use with available fluent helpers to apply the <b>PersonFullName</b> field to query operations.
     *
     */
    public final static PersonField<String> PERSON_FULL_NAME = new PersonField<String>("PersonFullName");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>PersonInvolvedRole</b>
     * </p>
     *
     * @return Person Role
     */
    @Key
    @SerializedName( "PersonInvolvedRole" )
    @JsonProperty( "PersonInvolvedRole" )
    @Nullable
    @ODataField( odataName = "PersonInvolvedRole" )
    private String personInvolvedRole;
    /**
     * Use with available fluent helpers to apply the <b>PersonInvolvedRole</b> field to query operations.
     *
     */
    public final static PersonField<String> PERSON_INVOLVED_ROLE = new PersonField<String>("PersonInvolvedRole");
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PersonInvolvedUUID</b>
     * </p>
     *
     * @return Person Global Identification
     */
    @Key
    @SerializedName( "PersonInvolvedUUID" )
    @JsonProperty( "PersonInvolvedUUID" )
    @Nullable
    @ODataField( odataName = "PersonInvolvedUUID" )
    private UUID personInvolvedUUID;
    /**
     * Use with available fluent helpers to apply the <b>PersonInvolvedUUID</b> field to query operations.
     *
     */
    public final static PersonField<UUID> PERSON_INVOLVED_UUID = new PersonField<UUID>("PersonInvolvedUUID");

    @Nonnull
    @Override
    public Class<Person> getType()
    {
        return Person.class;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PersonId</b>
     * </p>
     *
     * @param personId
     *            Person Id
     */
    public void setPersonId( @Nullable final String personId )
    {
        rememberChangedField("PersonId", this.personId);
        this.personId = personId;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>PersonFullName</b>
     * </p>
     *
     * @param personFullName
     *            Person Name
     */
    public void setPersonFullName( @Nullable final String personFullName )
    {
        rememberChangedField("PersonFullName", this.personFullName);
        this.personFullName = personFullName;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 21
     * <p>
     * Original property name from the Odata EDM: <b>PersonInvolvedRole</b>
     * </p>
     *
     * @param personInvolvedRole
     *            Person Role
     */
    public void setPersonInvolvedRole( @Nullable final String personInvolvedRole )
    {
        rememberChangedField("PersonInvolvedRole", this.personInvolvedRole);
        this.personInvolvedRole = personInvolvedRole;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>PersonInvolvedUUID</b>
     * </p>
     *
     * @param personInvolvedUUID
     *            Person Global Identification
     */
    public void setPersonInvolvedUUID( @Nullable final UUID personInvolvedUUID )
    {
        rememberChangedField("PersonInvolvedUUID", this.personInvolvedUUID);
        this.personInvolvedUUID = personInvolvedUUID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_Person";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("PersonInvolvedRole", getPersonInvolvedRole());
        result.put("PersonInvolvedUUID", getPersonInvolvedUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("PersonId", getPersonId());
        values.put("PersonFullName", getPersonFullName());
        values.put("PersonInvolvedRole", getPersonInvolvedRole());
        values.put("PersonInvolvedUUID", getPersonInvolvedUUID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("PersonId") ) {
                final Object value = values.remove("PersonId");
                if( (value == null) || (!value.equals(getPersonId())) ) {
                    setPersonId(((String) value));
                }
            }
            if( values.containsKey("PersonFullName") ) {
                final Object value = values.remove("PersonFullName");
                if( (value == null) || (!value.equals(getPersonFullName())) ) {
                    setPersonFullName(((String) value));
                }
            }
            if( values.containsKey("PersonInvolvedRole") ) {
                final Object value = values.remove("PersonInvolvedRole");
                if( (value == null) || (!value.equals(getPersonInvolvedRole())) ) {
                    setPersonInvolvedRole(((String) value));
                }
            }
            if( values.containsKey("PersonInvolvedUUID") ) {
                final Object value = values.remove("PersonInvolvedUUID");
                if( (value == null) || (!value.equals(getPersonInvolvedUUID())) ) {
                    setPersonInvolvedUUID(((UUID) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PersonField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PersonField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PersonField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PersonField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService.DEFAULT_SERVICE_PATH);
    }

}
