/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.batch;

import javax.annotation.Nonnull;

import com.sap.cloud.sdk.datamodel.odata.helper.batch.BatchChangeSetFluentHelperBasic;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person;

/**
 * Implementation of the {@link EHSIncidentCreateServiceBatchChangeSet} interface, enabling you to combine multiple
 * operations into one changeset. For further information have a look into the
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService EHSIncidentCreateService}.
 *
 */
public class DefaultEHSIncidentCreateServiceBatchChangeSet
    extends
    BatchChangeSetFluentHelperBasic<EHSIncidentCreateServiceBatch, EHSIncidentCreateServiceBatchChangeSet>
    implements
    EHSIncidentCreateServiceBatchChangeSet
{

    @Nonnull
    @SuppressWarnings( "deprecation" )
    private final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService service;

    @SuppressWarnings( "deprecation" )
    DefaultEHSIncidentCreateServiceBatchChangeSet(
        @Nonnull final DefaultEHSIncidentCreateServiceBatch batchFluentHelper,
        @Nonnull final com.sap.cloud.sdk.s4hana.datamodel.odata.services.EHSIncidentCreateService service )
    {
        super(batchFluentHelper, batchFluentHelper);
        this.service = service;
    }

    @Nonnull
    @Override
    protected DefaultEHSIncidentCreateServiceBatchChangeSet getThis()
    {
        return this;
    }

    @Nonnull
    @Override
    public EHSIncidentCreateServiceBatchChangeSet createAttachment( @Nonnull final Attachment attachment )
    {
        return addRequestCreate(service::createAttachment, attachment);
    }

    @Nonnull
    @Override
    public EHSIncidentCreateServiceBatchChangeSet createIncident( @Nonnull final Incident incident )
    {
        return addRequestCreate(service::createIncident, incident);
    }

    @Nonnull
    @Override
    public EHSIncidentCreateServiceBatchChangeSet createPerson( @Nonnull final Person person )
    {
        return addRequestCreate(service::createPerson, person);
    }

}
