/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment Attachment}. This interface
 * is used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.AttachmentField
 * AttachmentField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.AttachmentLink
 * AttachmentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment#ATTACHMENT_DOCUMENT_UUID
 * ATTACHMENT_DOCUMENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment#MIME_TYPE MIME_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Attachment#FILE_NAME FILE_NAME}</li>
 * </ul>
 *
 */
public interface AttachmentSelectable extends EntitySelectable<Attachment>
{

}
