/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier
 * CurEHSLocationInclRootHier}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.CurEHSLocationInclRootHierField
 * CurEHSLocationInclRootHierField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.CurEHSLocationInclRootHierLink
 * CurEHSLocationInclRootHierLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_UUID
 * EHS_LOCATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_NAME
 * EHS_LOCATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_ID_AND_NAME
 * EHS_LOCATION_ID_AND_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_ID
 * EHS_LOCATION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_TYPE_TEXT
 * EHS_LOCATION_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_STATUS
 * EHS_LOCATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#PLANT
 * PLANT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#MY_EHS_LOCATION_UUID
 * MY_EHS_LOCATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_PARENT_LOCATION_UUID
 * EHS_PARENT_LOCATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_DRILL_STATE_STRING
 * EHS_LOCATION_DRILL_STATE_STRING}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_TYPE
 * EHS_LOCATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOCATION_AUTHORIZATION_GROUP
 * EHS_LOCATION_AUTHORIZATION_GROUP}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#COST_CENTER
 * COST_CENTER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#COMPANY_CODE
 * COMPANY_CODE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#BUSINESS_AREA
 * BUSINESS_AREA}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOC_CLASSIFIERS_TEXT
 * EHS_LOC_CLASSIFIERS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOC_HIERARCHY_NODE_UUID
 * EHS_LOC_HIERARCHY_NODE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#EHS_LOC_HIERARCHY_PARENT_NODE_UUID
 * EHS_LOC_HIERARCHY_PARENT_NODE_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.CurEHSLocationInclRootHier#HIERARCHY_LEVEL
 * HIERARCHY_LEVEL}</li>
 * </ul>
 *
 */
public interface CurEHSLocationInclRootHierSelectable extends EntitySelectable<CurEHSLocationInclRootHier>
{

}
