/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText
 * EHSLocClassifierText}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSLocClassifierTextField
 * EHSLocClassifierTextField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.EHSLocClassifierTextLink
 * EHSLocClassifierTextLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText#EHS_LOCATION_UUID
 * EHS_LOCATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText#EHS_LOC_CLASSIFIER_UUID
 * EHS_LOC_CLASSIFIER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText#EHS_LOC_CLASSIFIER_REF_UUID
 * EHS_LOC_CLASSIFIER_REF_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText#EHS_LOC_CLASSIFIER_ID
 * EHS_LOC_CLASSIFIER_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierText#EHS_LOC_CLASSIFIER_TEXT
 * EHS_LOC_CLASSIFIER_TEXT}</li>
 * </ul>
 *
 */
public interface EHSLocClassifierTextSelectable extends EntitySelectable<EHSLocClassifierText>
{

}
