/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH EHSLocClassifierVH}.
 * This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSLocClassifierVHField
 * EHSLocClassifierVHField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.EHSLocClassifierVHLink
 * EHSLocClassifierVHLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH#EHS_CLASSIFIER_UUID
 * EHS_CLASSIFIER_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH#EHS_CLASSIFIER_NAME_FREE_SEARCH
 * EHS_CLASSIFIER_NAME_FREE_SEARCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH#EHS_CLASSIFIER_NAME
 * EHS_CLASSIFIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocClassifierVH#EHS_LOC_CLASSIFIER_ID
 * EHS_LOC_CLASSIFIER_ID}</li>
 * </ul>
 *
 */
public interface EHSLocClassifierVHSelectable extends EntitySelectable<EHSLocClassifierVH>
{

}
