/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp
 * EHSLocationValueHelp}. This interface is used by
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.EHSLocationValueHelpField
 * EHSLocationValueHelpField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.EHSLocationValueHelpLink
 * EHSLocationValueHelpLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_UUID
 * EHS_LOCATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_NAME_FREE_SRCH
 * EHS_LOCATION_NAME_FREE_SRCH}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_NAME
 * EHS_LOCATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_ID_AND_NAME
 * EHS_LOCATION_ID_AND_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_ID
 * EHS_LOCATION_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_TYPE
 * EHS_LOCATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_TYPE_TEXT
 * EHS_LOCATION_TYPE_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_STATUS
 * EHS_LOCATION_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOCATION_STATUS_TEXT
 * EHS_LOCATION_STATUS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_CLASSIFIER_NAME
 * EHS_CLASSIFIER_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#EHS_LOC_CLASSIFIERS_TEXT
 * EHS_LOC_CLASSIFIERS_TEXT}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#GEOGRAPHICAL_LOCATION_LATITUDE
 * GEOGRAPHICAL_LOCATION_LATITUDE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#GEOGRAPHICAL_LOCATION_LONGITUDE
 * GEOGRAPHICAL_LOCATION_LONGITUDE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.EHSLocationValueHelp#TO_LOC_CLASSIFIER_TEXT
 * TO_LOC_CLASSIFIER_TEXT}</li>
 * </ul>
 *
 */
public interface EHSLocationValueHelpSelectable extends EntitySelectable<EHSLocationValueHelp>
{

}
