/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident Incident}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.IncidentField
 * IncidentField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.IncidentLink
 * IncidentLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_ID
 * INCIDENT_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#FILTER_BY_CURRENT_USER
 * FILTER_BY_CURRENT_USER}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_UUID
 * INCIDENT_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_UTC_DATE_TIME
 * INCIDENT_UTC_DATE_TIME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_TITLE
 * INCIDENT_TITLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_STATUS
 * INCIDENT_STATUS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_LOCATION_DESCRIPTION
 * INCIDENT_LOCATION_DESCRIPTION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_DESCRIPTION_OF_EVENTS
 * INCIDENT_DESCRIPTION_OF_EVENTS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#INCIDENT_CATEGORY
 * INCIDENT_CATEGORY}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#EHS_LOCATION_UUID
 * EHS_LOCATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#TO_LOCATION
 * TO_LOCATION}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#TO_PERSONS TO_PERSONS}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Incident#TO_ATTACHMENTS
 * TO_ATTACHMENTS}</li>
 * </ul>
 *
 */
public interface IncidentSelectable extends EntitySelectable<Incident>
{

}
