/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location Location}. This interface is
 * used by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.LocationField
 * LocationField} and {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.LocationLink
 * LocationLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location#LOCATION_UUID
 * LOCATION_UUID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location#LOCATION_NAME
 * LOCATION_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location#LOCATION_TYPE
 * LOCATION_TYPE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location#LOCATION_LATITUDE
 * LOCATION_LATITUDE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Location#LOCATION_LONGTITUDE
 * LOCATION_LONGTITUDE}</li>
 * </ul>
 *
 */
public interface LocationSelectable extends EntitySelectable<Location>
{

}
