/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.selectable;

import com.sap.cloud.sdk.datamodel.odata.helper.EntitySelectable;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person;

/**
 * Interface to enable OData entity selectors for
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person Person}. This interface is used
 * by {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.field.PersonField PersonField} and
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.link.PersonLink PersonLink}.
 *
 * <p>
 * Available instances:
 * <ul>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person#PERSON_ID PERSON_ID}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person#PERSON_FULL_NAME
 * PERSON_FULL_NAME}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person#PERSON_INVOLVED_ROLE
 * PERSON_INVOLVED_ROLE}</li>
 * <li>{@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.ehsincidentcreate.Person#PERSON_INVOLVED_UUID
 * PERSON_INVOLVED_UUID}</li>
 * </ul>
 *
 */
public interface PersonSelectable extends EntitySelectable<Person>
{

}
