/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EntProjElmntBlockFuncField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable.EntProjElmntBlockFuncSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * Project Element Block Function
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjElmntBlockFuncType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjElmntBlockFunc extends VdmEntity<EntProjElmntBlockFunc>
{

    /**
     * Selector for all available fields of EntProjElmntBlockFunc.
     *
     */
    public final static EntProjElmntBlockFuncSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<UUID> PROJECT_ELEMENT_UUID =
        new EntProjElmntBlockFuncField<UUID>("ProjectElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<UUID> PROJECT_UUID =
        new EntProjElmntBlockFuncField<UUID>("ProjectUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjTimeRecgIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjTimeRecgIsBlkd" )
    @JsonProperty( "EntProjTimeRecgIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjTimeRecgIsBlkd" )
    private Boolean entProjTimeRecgIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjTimeRecgIsBlkd</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<Boolean> ENT_PROJ_TIME_RECG_IS_BLKD =
        new EntProjElmntBlockFuncField<Boolean>("EntProjTimeRecgIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjStaffExpensePostgIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjStaffExpensePostgIsBlkd" )
    @JsonProperty( "EntProjStaffExpensePostgIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjStaffExpensePostgIsBlkd" )
    private Boolean entProjStaffExpensePostgIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjStaffExpensePostgIsBlkd</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<Boolean> ENT_PROJ_STAFF_EXPENSE_POSTG_IS_BLKD =
        new EntProjElmntBlockFuncField<Boolean>("EntProjStaffExpensePostgIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjServicePostingIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjServicePostingIsBlkd" )
    @JsonProperty( "EntProjServicePostingIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjServicePostingIsBlkd" )
    private Boolean entProjServicePostingIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjServicePostingIsBlkd</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<Boolean> ENT_PROJ_SERVICE_POSTING_IS_BLKD =
        new EntProjElmntBlockFuncField<Boolean>("EntProjServicePostingIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjOtherExpensePostgIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjOtherExpensePostgIsBlkd" )
    @JsonProperty( "EntProjOtherExpensePostgIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjOtherExpensePostgIsBlkd" )
    private Boolean entProjOtherExpensePostgIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjOtherExpensePostgIsBlkd</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<Boolean> ENT_PROJ_OTHER_EXPENSE_POSTG_IS_BLKD =
        new EntProjElmntBlockFuncField<Boolean>("EntProjOtherExpensePostgIsBlkd");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjPurchasingIsBlkd</b>
     * </p>
     *
     * @return Boolean Variable (X = True, - = False, Space = Unknown)
     */
    @SerializedName( "EntProjPurchasingIsBlkd" )
    @JsonProperty( "EntProjPurchasingIsBlkd" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "EntProjPurchasingIsBlkd" )
    private Boolean entProjPurchasingIsBlkd;
    /**
     * Use with available fluent helpers to apply the <b>EntProjPurchasingIsBlkd</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<Boolean> ENT_PROJ_PURCHASING_IS_BLKD =
        new EntProjElmntBlockFuncField<Boolean>("EntProjPurchasingIsBlkd");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "ProjectLastChangedDateTime" )
    @JsonProperty( "ProjectLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime projectLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProjectLastChangedDateTime</b> field to query operations.
     *
     */
    public final static EntProjElmntBlockFuncField<ZonedDateTime> PROJECT_LAST_CHANGED_DATE_TIME =
        new EntProjElmntBlockFuncField<ZonedDateTime>("ProjectLastChangedDateTime");

    @Nonnull
    @Override
    public Class<EntProjElmntBlockFunc> getType()
    {
        return EntProjElmntBlockFunc.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjTimeRecgIsBlkd</b>
     * </p>
     *
     * @param entProjTimeRecgIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjTimeRecgIsBlkd( @Nullable final Boolean entProjTimeRecgIsBlkd )
    {
        rememberChangedField("EntProjTimeRecgIsBlkd", this.entProjTimeRecgIsBlkd);
        this.entProjTimeRecgIsBlkd = entProjTimeRecgIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjStaffExpensePostgIsBlkd</b>
     * </p>
     *
     * @param entProjStaffExpensePostgIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjStaffExpensePostgIsBlkd( @Nullable final Boolean entProjStaffExpensePostgIsBlkd )
    {
        rememberChangedField("EntProjStaffExpensePostgIsBlkd", this.entProjStaffExpensePostgIsBlkd);
        this.entProjStaffExpensePostgIsBlkd = entProjStaffExpensePostgIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjServicePostingIsBlkd</b>
     * </p>
     *
     * @param entProjServicePostingIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjServicePostingIsBlkd( @Nullable final Boolean entProjServicePostingIsBlkd )
    {
        rememberChangedField("EntProjServicePostingIsBlkd", this.entProjServicePostingIsBlkd);
        this.entProjServicePostingIsBlkd = entProjServicePostingIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjOtherExpensePostgIsBlkd</b>
     * </p>
     *
     * @param entProjOtherExpensePostgIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjOtherExpensePostgIsBlkd( @Nullable final Boolean entProjOtherExpensePostgIsBlkd )
    {
        rememberChangedField("EntProjOtherExpensePostgIsBlkd", this.entProjOtherExpensePostgIsBlkd);
        this.entProjOtherExpensePostgIsBlkd = entProjOtherExpensePostgIsBlkd;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>EntProjPurchasingIsBlkd</b>
     * </p>
     *
     * @param entProjPurchasingIsBlkd
     *            Boolean Variable (X = True, - = False, Space = Unknown)
     */
    public void setEntProjPurchasingIsBlkd( @Nullable final Boolean entProjPurchasingIsBlkd )
    {
        rememberChangedField("EntProjPurchasingIsBlkd", this.entProjPurchasingIsBlkd);
        this.entProjPurchasingIsBlkd = entProjPurchasingIsBlkd;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @param projectLastChangedDateTime
     *            Timestamp of Last Object Change
     */
    public void setProjectLastChangedDateTime( @Nullable final ZonedDateTime projectLastChangedDateTime )
    {
        rememberChangedField("ProjectLastChangedDateTime", this.projectLastChangedDateTime);
        this.projectLastChangedDateTime = projectLastChangedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjElmntBlockFunc";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectElementUUID", getProjectElementUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("EntProjTimeRecgIsBlkd", getEntProjTimeRecgIsBlkd());
        values.put("EntProjStaffExpensePostgIsBlkd", getEntProjStaffExpensePostgIsBlkd());
        values.put("EntProjServicePostingIsBlkd", getEntProjServicePostingIsBlkd());
        values.put("EntProjOtherExpensePostgIsBlkd", getEntProjOtherExpensePostgIsBlkd());
        values.put("EntProjPurchasingIsBlkd", getEntProjPurchasingIsBlkd());
        values.put("ProjectLastChangedDateTime", getProjectLastChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("EntProjTimeRecgIsBlkd") ) {
                final Object value = values.remove("EntProjTimeRecgIsBlkd");
                if( (value == null) || (!value.equals(getEntProjTimeRecgIsBlkd())) ) {
                    setEntProjTimeRecgIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjStaffExpensePostgIsBlkd") ) {
                final Object value = values.remove("EntProjStaffExpensePostgIsBlkd");
                if( (value == null) || (!value.equals(getEntProjStaffExpensePostgIsBlkd())) ) {
                    setEntProjStaffExpensePostgIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjServicePostingIsBlkd") ) {
                final Object value = values.remove("EntProjServicePostingIsBlkd");
                if( (value == null) || (!value.equals(getEntProjServicePostingIsBlkd())) ) {
                    setEntProjServicePostingIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjOtherExpensePostgIsBlkd") ) {
                final Object value = values.remove("EntProjOtherExpensePostgIsBlkd");
                if( (value == null) || (!value.equals(getEntProjOtherExpensePostgIsBlkd())) ) {
                    setEntProjOtherExpensePostgIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("EntProjPurchasingIsBlkd") ) {
                final Object value = values.remove("EntProjPurchasingIsBlkd");
                if( (value == null) || (!value.equals(getEntProjPurchasingIsBlkd())) ) {
                    setEntProjPurchasingIsBlkd(((Boolean) value));
                }
            }
            if( values.containsKey("ProjectLastChangedDateTime") ) {
                final Object value = values.remove("ProjectLastChangedDateTime");
                if( (value == null) || (!value.equals(getProjectLastChangedDateTime())) ) {
                    setProjectLastChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> EntProjElmntBlockFuncField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new EntProjElmntBlockFuncField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjElmntBlockFuncField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjElmntBlockFuncField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService.DEFAULT_SERVICE_PATH);
    }

}
