/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject;

import java.time.ZonedDateTime;
import java.util.Map;
import java.util.UUID;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.field.EntProjectElmntPublicSectorField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.link.EntProjectElmntPublicSectorOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.enterpriseproject.selectable.EntProjectElmntPublicSectorSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Project Element Public Sector
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>A_EntProjectElmntPublicSectorType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class EntProjectElmntPublicSector extends VdmEntity<EntProjectElmntPublicSector>
{

    /**
     * Selector for all available fields of EntProjectElmntPublicSector.
     *
     */
    public final static EntProjectElmntPublicSectorSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @Key
    @SerializedName( "ProjectElementUUID" )
    @JsonProperty( "ProjectElementUUID" )
    @Nullable
    @ODataField( odataName = "ProjectElementUUID" )
    private UUID projectElementUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectElementUUID</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<UUID> PROJECT_ELEMENT_UUID =
        new EntProjectElmntPublicSectorField<UUID>("ProjectElementUUID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @return Entity Guid
     */
    @SerializedName( "ProjectUUID" )
    @JsonProperty( "ProjectUUID" )
    @Nullable
    @ODataField( odataName = "ProjectUUID" )
    private UUID projectUUID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectUUID</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<UUID> PROJECT_UUID =
        new EntProjectElmntPublicSectorField<UUID>("ProjectUUID");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     * <p>
     * If you assign the budget to a fund, you can obtain a detailed list of origin for the amounts involved.
     * </p>
     *
     * @return Key which uniquely identifies the fund.
     */
    @SerializedName( "Fund" )
    @JsonProperty( "Fund" )
    @Nullable
    @ODataField( odataName = "Fund" )
    private String fund;
    /**
     * Use with available fluent helpers to apply the <b>Fund</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<String> FUND =
        new EntProjectElmntPublicSectorField<String>("Fund");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FundIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Fund with Fixed Assignment
     */
    @SerializedName( "FundIsFixAssigned" )
    @JsonProperty( "FundIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FundIsFixAssigned" )
    private Boolean fundIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>FundIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<Boolean> FUND_IS_FIX_ASSIGNED =
        new EntProjectElmntPublicSectorField<Boolean>("FundIsFixAssigned");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Functional Area with Fixed Assignment
     */
    @SerializedName( "FunctionalAreaIsFixAssigned" )
    @JsonProperty( "FunctionalAreaIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FunctionalAreaIsFixAssigned" )
    private Boolean functionalAreaIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalAreaIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<Boolean> FUNCTIONAL_AREA_IS_FIX_ASSIGNED =
        new EntProjectElmntPublicSectorField<Boolean>("FunctionalAreaIsFixAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     * <p>
     * A grant may be for any purpose and cover all or only part of the costs of the project in question. You must enter
     * a grant type for each grant you create in Grants Management (GM).The grant as an object has a finite lifecycle,
     * divided into stages. Each stage is represented in the GM solution by a system status. The following are the
     * stages of a grant's lifecycle:Initial DraftThis is the first stage of a grant. It is a working copy that can be
     * modified as many times as needed.ProposalWhen the initial draft becomes a formal and complete document, it
     * becomes a proposal.ApplicationWhen a proposal is routed to the sponsor for approval, it becomes an application.
     * This application might contain changes in the budget or other adjustments.AwardIf the sponsor approves an
     * application, an award is created. This is the real operative stage of a grant. The creation and consumption of
     * the grant's budget occurs at this stage. This stage also represents the binding contract between the sponsor and
     * the grantee.ClosingWhen an award is expiring, a phase of closing is established. Only restricted operations can
     * be performed in this stage.ClosedThis stage defines an expired and closed grant. No further operations are
     * allowed except archiving.
     * </p>
     *
     * @return Legal instrument used to establish a funding relationship between a sponsor (grantor) and grantee, in
     *         order to carry out a public purpose of support or stimulation in which the sponsor does not expect to be
     *         substantially involved.
     */
    @SerializedName( "GrantID" )
    @JsonProperty( "GrantID" )
    @Nullable
    @ODataField( odataName = "GrantID" )
    private String grantID;
    /**
     * Use with available fluent helpers to apply the <b>GrantID</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<String> GRANT_ID =
        new EntProjectElmntPublicSectorField<String>("GrantID");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsFixAssigned</b>
     * </p>
     *
     * @return Indicator for Grant with Fixed Assignment
     */
    @SerializedName( "GrantIsFixAssigned" )
    @JsonProperty( "GrantIsFixAssigned" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "GrantIsFixAssigned" )
    private Boolean grantIsFixAssigned;
    /**
     * Use with available fluent helpers to apply the <b>GrantIsFixAssigned</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<Boolean> GRANT_IS_FIX_ASSIGNED =
        new EntProjectElmntPublicSectorField<Boolean>("GrantIsFixAssigned");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     * <p>
     * The sponsored program is used to group costs in order to satisfy the sponsor's view and reporting needs; it is
     * used in all Grants Management (GM) activities. One grant might fund several sponsored programs and one sponsored
     * program might be funded by several grants.The sponsored program provides a link between GM and Funds Management
     * (FM). In particular, it provides a link to funds centers, functional areas, and funded programs for the purpose
     * of budget transfers.The assignment tool should be used to derive the sponsored program during actual postings.
     * </p>
     *
     * @return The sponsored program is a fundamental part of the sponsor's view. It is a dimension that defines, in the
     *         sponsor's view and terms, a program to be funded. Whenever a grantee has to report back to the sponsor,
     *         the sponsored program is in fact, the program dimension that the sponsor will recognize.
     */
    @SerializedName( "SponsoredProgram" )
    @JsonProperty( "SponsoredProgram" )
    @Nullable
    @ODataField( odataName = "SponsoredProgram" )
    private String sponsoredProgram;
    /**
     * Use with available fluent helpers to apply the <b>SponsoredProgram</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<String> SPONSORED_PROGRAM =
        new EntProjectElmntPublicSectorField<String>("SponsoredProgram");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @return Timestamp of Last Object Change
     */
    @SerializedName( "ProjectLastChangedDateTime" )
    @JsonProperty( "ProjectLastChangedDateTime" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonZonedDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeAdapter.class )
    @ODataField(
        odataName = "ProjectLastChangedDateTime",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ZonedDateTimeCalendarConverter.class )
    private ZonedDateTime projectLastChangedDateTime;
    /**
     * Use with available fluent helpers to apply the <b>ProjectLastChangedDateTime</b> field to query operations.
     *
     */
    public final static EntProjectElmntPublicSectorField<ZonedDateTime> PROJECT_LAST_CHANGED_DATE_TIME =
        new EntProjectElmntPublicSectorField<ZonedDateTime>("ProjectLastChangedDateTime");
    /**
     * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjectElmntPublicSector</b> to single
     * <b>EnterpriseProjectElement</b>.
     *
     */
    @SerializedName( "to_EnterpriseProjectElement" )
    @JsonProperty( "to_EnterpriseProjectElement" )
    @ODataField( odataName = "to_EnterpriseProjectElement" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private EnterpriseProjectElement toEnterpriseProjectElement;
    /**
     * Use with available fluent helpers to apply the <b>to_EnterpriseProjectElement</b> navigation property to query
     * operations.
     *
     */
    public final static EntProjectElmntPublicSectorOneToOneLink<EnterpriseProjectElement> TO_ENTERPRISE_PROJECT_ELEMENT =
        new EntProjectElmntPublicSectorOneToOneLink<EnterpriseProjectElement>("to_EnterpriseProjectElement");

    @Nonnull
    @Override
    public Class<EntProjectElmntPublicSector> getType()
    {
        return EntProjectElmntPublicSector.class;
    }

    /**
     * (Key Field) Constraints: Not nullable
     * <p>
     * Original property name from the Odata EDM: <b>ProjectElementUUID</b>
     * </p>
     *
     * @param projectElementUUID
     *            Entity Guid
     */
    public void setProjectElementUUID( @Nullable final UUID projectElementUUID )
    {
        rememberChangedField("ProjectElementUUID", this.projectElementUUID);
        this.projectElementUUID = projectElementUUID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>ProjectUUID</b>
     * </p>
     *
     * @param projectUUID
     *            Entity Guid
     */
    public void setProjectUUID( @Nullable final UUID projectUUID )
    {
        rememberChangedField("ProjectUUID", this.projectUUID);
        this.projectUUID = projectUUID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Fund</b>
     * </p>
     * <p>
     * If you assign the budget to a fund, you can obtain a detailed list of origin for the amounts involved.
     * </p>
     *
     * @param fund
     *            Key which uniquely identifies the fund.
     */
    public void setFund( @Nullable final String fund )
    {
        rememberChangedField("Fund", this.fund);
        this.fund = fund;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FundIsFixAssigned</b>
     * </p>
     *
     * @param fundIsFixAssigned
     *            Indicator for Fund with Fixed Assignment
     */
    public void setFundIsFixAssigned( @Nullable final Boolean fundIsFixAssigned )
    {
        rememberChangedField("FundIsFixAssigned", this.fundIsFixAssigned);
        this.fundIsFixAssigned = fundIsFixAssigned;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalAreaIsFixAssigned</b>
     * </p>
     *
     * @param functionalAreaIsFixAssigned
     *            Indicator for Functional Area with Fixed Assignment
     */
    public void setFunctionalAreaIsFixAssigned( @Nullable final Boolean functionalAreaIsFixAssigned )
    {
        rememberChangedField("FunctionalAreaIsFixAssigned", this.functionalAreaIsFixAssigned);
        this.functionalAreaIsFixAssigned = functionalAreaIsFixAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>GrantID</b>
     * </p>
     * <p>
     * A grant may be for any purpose and cover all or only part of the costs of the project in question. You must enter
     * a grant type for each grant you create in Grants Management (GM).The grant as an object has a finite lifecycle,
     * divided into stages. Each stage is represented in the GM solution by a system status. The following are the
     * stages of a grant's lifecycle:Initial DraftThis is the first stage of a grant. It is a working copy that can be
     * modified as many times as needed.ProposalWhen the initial draft becomes a formal and complete document, it
     * becomes a proposal.ApplicationWhen a proposal is routed to the sponsor for approval, it becomes an application.
     * This application might contain changes in the budget or other adjustments.AwardIf the sponsor approves an
     * application, an award is created. This is the real operative stage of a grant. The creation and consumption of
     * the grant's budget occurs at this stage. This stage also represents the binding contract between the sponsor and
     * the grantee.ClosingWhen an award is expiring, a phase of closing is established. Only restricted operations can
     * be performed in this stage.ClosedThis stage defines an expired and closed grant. No further operations are
     * allowed except archiving.
     * </p>
     *
     * @param grantID
     *            Legal instrument used to establish a funding relationship between a sponsor (grantor) and grantee, in
     *            order to carry out a public purpose of support or stimulation in which the sponsor does not expect to
     *            be substantially involved.
     */
    public void setGrantID( @Nullable final String grantID )
    {
        rememberChangedField("GrantID", this.grantID);
        this.grantID = grantID;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>GrantIsFixAssigned</b>
     * </p>
     *
     * @param grantIsFixAssigned
     *            Indicator for Grant with Fixed Assignment
     */
    public void setGrantIsFixAssigned( @Nullable final Boolean grantIsFixAssigned )
    {
        rememberChangedField("GrantIsFixAssigned", this.grantIsFixAssigned);
        this.grantIsFixAssigned = grantIsFixAssigned;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SponsoredProgram</b>
     * </p>
     * <p>
     * The sponsored program is used to group costs in order to satisfy the sponsor's view and reporting needs; it is
     * used in all Grants Management (GM) activities. One grant might fund several sponsored programs and one sponsored
     * program might be funded by several grants.The sponsored program provides a link between GM and Funds Management
     * (FM). In particular, it provides a link to funds centers, functional areas, and funded programs for the purpose
     * of budget transfers.The assignment tool should be used to derive the sponsored program during actual postings.
     * </p>
     *
     * @param sponsoredProgram
     *            The sponsored program is a fundamental part of the sponsor's view. It is a dimension that defines, in
     *            the sponsor's view and terms, a program to be funded. Whenever a grantee has to report back to the
     *            sponsor, the sponsored program is in fact, the program dimension that the sponsor will recognize.
     */
    public void setSponsoredProgram( @Nullable final String sponsoredProgram )
    {
        rememberChangedField("SponsoredProgram", this.sponsoredProgram);
        this.sponsoredProgram = sponsoredProgram;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProjectLastChangedDateTime</b>
     * </p>
     *
     * @param projectLastChangedDateTime
     *            Timestamp of Last Object Change
     */
    public void setProjectLastChangedDateTime( @Nullable final ZonedDateTime projectLastChangedDateTime )
    {
        rememberChangedField("ProjectLastChangedDateTime", this.projectLastChangedDateTime);
        this.projectLastChangedDateTime = projectLastChangedDateTime;
    }

    @Override
    protected String getEntityCollection()
    {
        return "A_EntProjectElmntPublicSector";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProjectElementUUID", getProjectElementUUID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProjectElementUUID", getProjectElementUUID());
        values.put("ProjectUUID", getProjectUUID());
        values.put("Fund", getFund());
        values.put("FundIsFixAssigned", getFundIsFixAssigned());
        values.put("FunctionalAreaIsFixAssigned", getFunctionalAreaIsFixAssigned());
        values.put("GrantID", getGrantID());
        values.put("GrantIsFixAssigned", getGrantIsFixAssigned());
        values.put("SponsoredProgram", getSponsoredProgram());
        values.put("ProjectLastChangedDateTime", getProjectLastChangedDateTime());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProjectElementUUID") ) {
                final Object value = values.remove("ProjectElementUUID");
                if( (value == null) || (!value.equals(getProjectElementUUID())) ) {
                    setProjectElementUUID(((UUID) value));
                }
            }
            if( values.containsKey("ProjectUUID") ) {
                final Object value = values.remove("ProjectUUID");
                if( (value == null) || (!value.equals(getProjectUUID())) ) {
                    setProjectUUID(((UUID) value));
                }
            }
            if( values.containsKey("Fund") ) {
                final Object value = values.remove("Fund");
                if( (value == null) || (!value.equals(getFund())) ) {
                    setFund(((String) value));
                }
            }
            if( values.containsKey("FundIsFixAssigned") ) {
                final Object value = values.remove("FundIsFixAssigned");
                if( (value == null) || (!value.equals(getFundIsFixAssigned())) ) {
                    setFundIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("FunctionalAreaIsFixAssigned") ) {
                final Object value = values.remove("FunctionalAreaIsFixAssigned");
                if( (value == null) || (!value.equals(getFunctionalAreaIsFixAssigned())) ) {
                    setFunctionalAreaIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("GrantID") ) {
                final Object value = values.remove("GrantID");
                if( (value == null) || (!value.equals(getGrantID())) ) {
                    setGrantID(((String) value));
                }
            }
            if( values.containsKey("GrantIsFixAssigned") ) {
                final Object value = values.remove("GrantIsFixAssigned");
                if( (value == null) || (!value.equals(getGrantIsFixAssigned())) ) {
                    setGrantIsFixAssigned(((Boolean) value));
                }
            }
            if( values.containsKey("SponsoredProgram") ) {
                final Object value = values.remove("SponsoredProgram");
                if( (value == null) || (!value.equals(getSponsoredProgram())) ) {
                    setSponsoredProgram(((String) value));
                }
            }
            if( values.containsKey("ProjectLastChangedDateTime") ) {
                final Object value = values.remove("ProjectLastChangedDateTime");
                if( (value == null) || (!value.equals(getProjectLastChangedDateTime())) ) {
                    setProjectLastChangedDateTime(((ZonedDateTime) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_EnterpriseProjectElement") ) {
                final Object value = (values).remove("to_EnterpriseProjectElement");
                if( value instanceof Map ) {
                    if( toEnterpriseProjectElement == null ) {
                        toEnterpriseProjectElement = new EnterpriseProjectElement();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toEnterpriseProjectElement.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> EntProjectElmntPublicSectorField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new EntProjectElmntPublicSectorField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> EntProjectElmntPublicSectorField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new EntProjectElmntPublicSectorField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.EnterpriseProjectService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toEnterpriseProjectElement != null ) {
            (values).put("to_EnterpriseProjectElement", toEnterpriseProjectElement);
        }
        return values;
    }

    /**
     * Fetches the <b>EnterpriseProjectElement</b> entity (one to one) associated with this entity. This corresponds to
     * the OData navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>EnterpriseProjectElement</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement fetchEnterpriseProjectElement()
    {
        return fetchFieldAsSingle("to_EnterpriseProjectElement", EnterpriseProjectElement.class);
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property <b>to_EnterpriseProjectElement</b> of a queried <b>EntProjectElmntPublicSector</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>EnterpriseProjectElement</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public EnterpriseProjectElement getEnterpriseProjectElementOrFetch()
    {
        if( toEnterpriseProjectElement == null ) {
            toEnterpriseProjectElement = fetchEnterpriseProjectElement();
        }
        return toEnterpriseProjectElement;
    }

    /**
     * Retrieval of associated <b>EnterpriseProjectElement</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_EnterpriseProjectElement</b>.
     * <p>
     * If the navigation property for an entity <b>EntProjectElmntPublicSector</b> has not been resolved yet, this
     * method will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_EnterpriseProjectElement</b> is already loaded, the
     *         result will contain the <b>EnterpriseProjectElement</b> entity. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<EnterpriseProjectElement> getEnterpriseProjectElementIfPresent()
    {
        return Option.of(toEnterpriseProjectElement);
    }

    /**
     * Overwrites the associated <b>EnterpriseProjectElement</b> entity for the loaded navigation property
     * <b>to_EnterpriseProjectElement</b>.
     *
     * @param value
     *            New <b>EnterpriseProjectElement</b> entity.
     */
    public void setEnterpriseProjectElement( final EnterpriseProjectElement value )
    {
        toEnterpriseProjectElement = value;
    }

    /**
     * Helper class to allow for fluent creation of EntProjectElmntPublicSector instances.
     *
     */
    public final static class EntProjectElmntPublicSectorBuilder
    {

        private EnterpriseProjectElement toEnterpriseProjectElement;

        private EntProjectElmntPublicSector.EntProjectElmntPublicSectorBuilder toEnterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            toEnterpriseProjectElement = value;
            return this;
        }

        /**
         * Navigation property <b>to_EnterpriseProjectElement</b> for <b>EntProjectElmntPublicSector</b> to single
         * <b>EnterpriseProjectElement</b>.
         *
         * @param value
         *            The EnterpriseProjectElement to build this EntProjectElmntPublicSector with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public EntProjectElmntPublicSector.EntProjectElmntPublicSectorBuilder enterpriseProjectElement(
            final EnterpriseProjectElement value )
        {
            return toEnterpriseProjectElement(value);
        }

    }

}
